/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "symbol.h"

typedef enum   // next element for attribute checking: meta
{   a_unknown,
    a_abbr, a_accept, a_acceptcharset, a_accesskey, a_action, a_allowfullscreen, a_allowpaymentrequest, a_allowusermedia, a_alt, a_ariastar, a_as, a_async, a_autocapitalise,
    a_autocomplete, a_autofocus, a_autoplay, a_border, a_capture, a_charset, a_checked, a_cite, a_class, a_classid, a_codebase, a_cols, a_colspan, a_coords, a_content,
    a_contenteditable, a_controls, a_crossorigin, a_data, a_datastar, a_datetime, a_decoding, a_default, a_defer, a_dir, a_dirname, a_disabled, a_disableremoteplayback, a_download,
    a_draggable, a_enctype, a_for, a_form, a_formaction, a_formenctype, a_formmethod, a_formnovalidate, a_formtarget, a_headers, a_height, a_hidden, a_high, a_href,
    a_hreflang, a_html, a_httpequiv, a_id, a_inputtype, a_integrity, a_is, a_ismap, a_itemid, a_itemprop, a_itemref, a_itemscope, a_itemtype, a_kind, a_label, a_lang, a_list, a_longdesc, a_loop, a_low,
    a_manifest, a_max, a_maxlength, a_media, a_metaname, a_method, a_min, a_minlength, a_multiple, a_muted, a_name, a_nonce, a_novalidate, a_onafterprint, a_onbeforeprint,
    a_onbeforeunload, a_onhashchange, a_onlanguagechange, a_onmessage, a_onoffline, a_ononline, a_onpagehide, a_onpageshow, a_onpopstate, a_onrejectionhandled,
    a_onstorage, a_onunhandledrejection, a_onunload, a_open, a_optimum, a_pattern, a_ping, a_placeholder, a_poster, a_preload, a_profile, a_public, a_readonly, a_referrerpolicy,
    a_rel, a_required, a_rev, a_reversed, a_role, a_rows, a_rowspan, a_sandbox, a_scope, a_selected, a_shape, a_size, a_sizes, a_span, a_spellcheck, a_src, a_srcdoc,
    a_srclang, a_srcset, a_start, a_step, a_style, a_system, a_tabindex, a_target, a_title, a_translate, a_type, a_typemustmatch, a_usemap, a_value, a_width, a_wrap, a_xmlbase,
    a_xmllang, a_xmlns }
e_attribute;

struct attr : symbol < e_attribute >
{   static e_attribute parse (const ::std::string& x);
    static void init ();
    bool unknown () const { return (symbol < e_attribute > :: unknown ()) || (symbol < e_attribute > :: get () == a_unknown); }
    attr () {}
    attr (const ::std::string& x) { set (parse (x)); } };
