/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "common.h"
#include <memory>

class context;
class external;

class directory
{   typedef ::std::shared_ptr < directory > self_ptr;
    typedef ssc_map < ::std::string, self_ptr > map_t;
    typedef map_t::value_type value_t;
    ::boost::filesystem::path path_;
    map_t content_;
    bool offsite_;
    const directory* mummy_;
    static directory* root_;
    static external external_;
    bool add_to_content (::boost::filesystem::directory_entry& i);
    bool is_present (::boost::filesystem::path::iterator& i, const ::boost::filesystem::path::iterator& last) const;
    bool unguarded_verify_url (const ::std::string& url, ::std::ostringstream& ss) const;
protected:
    directory (const ::std::string& name, const directory* mummy) : path_ (name), mummy_ (mummy), offsite_ (false)
    {   scan (); }
public:
    explicit directory (const ::std::string& name) : path_ (name), mummy_ (nullptr), offsite_ (false)
    {   if (root_ == nullptr) root_ = this; }
    directory (const ::std::string& name, const bool offsite) : path_ (name), mummy_ (nullptr), offsite_ (offsite)
    {   }
    void swap (directory& d) noexcept
    {   path_.swap (d.path_);
        content_.swap (d.content_);
        ::std::swap (offsite_, d.offsite_);
        ::std::swap (mummy_, d.mummy_); }
    static void set_root (directory* root) { root_ = root; }
    const ::std::string& name () const { return path_.filename ().string (); }
    bool empty () const { return content_.empty (); }
    bool offsite () const { return offsite_; }
    bool invalid () const;
    bool is_present (const ::boost::filesystem::path& link) const;
    bool add_virtual (const ::std::string& virt, const ::std::string& path);
    bool scan ();
    void examine ();
    bool verify_url (const ::std::string& url, ::std::ostringstream& ss) const;
    bool verify_external (const ::std::string& url, ::std::ostringstream& ss) const; };

bool add_virtual (directory& d, const ::std::string& assignment);
bool is_webpage (const ::std::string& name, const vstr_t& extensions);
