/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "elem.h"
#include "context.h"
#include "quote.h"

size_t elem::max_tag_ = TAG_MORE_ELEM;

#define ELEMENT__UNDEF "_UNDEF"
#define ELEMENT__TEXT "_TEXT"
#define ELEMENT__COMMENT "_COMMENT"
#define ELEMENT__DOCTYPE "_DOCTYPE"
#define ELEMENT_A "A"
#define ELEMENT_ABBR "ABBR"
#define ELEMENT_ACRONYM "ACRONYM"
#define ELEMENT_ADDRESS "ADDRESS"
#define ELEMENT_ANNOTATION_XML "ANNOTATION_XML"
#define ELEMENT_APPLET "APPLET"
#define ELEMENT_AREA "AREA"
#define ELEMENT_ARTICLE "ARTICLE"
#define ELEMENT_ASIDE "ASIDE"
#define ELEMENT_AUDIO "AUDIO"
#define ELEMENT_B "B"
#define ELEMENT_BASE "BASE"
#define ELEMENT_BASEFONT "BASEFONT"
#define ELEMENT_BDI "BDI"
#define ELEMENT_BDO "BDO"
#define ELEMENT_BGSOUND "BGSOUND"
#define ELEMENT_BIG "BIG"
#define ELEMENT_BLINK "BLINK"
#define ELEMENT_BLOCKQUOTE "BLOCKQUOTE"
#define ELEMENT_BODY "BODY"
#define ELEMENT_BR "BR"
#define ELEMENT_BUTTON "BUTTON"
#define ELEMENT_CANVAS "CANVAS"
#define ELEMENT_CAPTION "CAPTION"
#define ELEMENT_CENTER "CENTER"
#define ELEMENT_CITE "CITE"
#define ELEMENT_CODE "CODE"
#define ELEMENT_COL "COL"
#define ELEMENT_COLGROUP "COLGROUP"
#define ELEMENT_COMMAND "COMMAND"
#define ELEMENT_COMMENT "COMMENT"
#define ELEMENT_DATALIST "DATALIST"
#define ELEMENT_DD "DD"
#define ELEMENT_DEL "DEL"
#define ELEMENT_DETAILS "DETAILS"
#define ELEMENT_DFN "DFN"
#define ELEMENT_DIALOG "DIALOG"
#define ELEMENT_DIR "DIR"
#define ELEMENT_DIV "DIV"
#define ELEMENT_DL "DL"
#define ELEMENT_DT "DT"
#define ELEMENT_EM "EM"
#define ELEMENT_EMBED "EMBED"
#define ELEMENT_FIELDSET "FIELDSET"
#define ELEMENT_FIGCAPTION "FIGCAPTION"
#define ELEMENT_FIGURE "FIGURE"
#define ELEMENT_FONT "FONT"
#define ELEMENT_FOOTER "FOOTER"
#define ELEMENT_FORM "FORM"
#define ELEMENT_FRAME "FRAME"
#define ELEMENT_FRAMESET "FRAMESET"
#define ELEMENT_H1 "H1"
#define ELEMENT_H2 "H2"
#define ELEMENT_H3 "H3"
#define ELEMENT_H4 "H4"
#define ELEMENT_H5 "H5"
#define ELEMENT_H6 "H6"
#define ELEMENT_HEAD "HEAD"
#define ELEMENT_HEADER "HEADER"
#define ELEMENT_HGROUP "HGROUP"
#define ELEMENT_HR "HR"
#define ELEMENT_HTML "HTML"
#define ELEMENT_I "I"
#define ELEMENT_IFRAME "IFRAME"
#define ELEMENT_IMAGE "IMAGE"
#define ELEMENT_IMG "IMG"
#define ELEMENT_INPUT "INPUT"
#define ELEMENT_INS "INS"
#define ELEMENT_ISINDEX "ISINDEX"
#define ELEMENT_KBD "KBD"
#define ELEMENT_KEYGEN "KEYGEN"
#define ELEMENT_LABEL "LABEL"
#define ELEMENT_LEGEND "LEGEND"
#define ELEMENT_LI "LI"
#define ELEMENT_LINK "LINK"
#define ELEMENT_LISTING "LISTING"
#define ELEMENT_MAIN "MAIN"
#define ELEMENT_MAP "MAP"
#define ELEMENT_MARK "MARK"
#define ELEMENT_MARQUEE "MARQUEE"
#define ELEMENT_MENU "MENU"
#define ELEMENT_MENUITEM "MENUITEM"
#define ELEMENT_META "META"
#define ELEMENT_METER "METER"
#define ELEMENT_MTEXT "MTEXT"
#define ELEMENT_NAV "NAV"
#define ELEMENT_NOBR "NOBR"
#define ELEMENT_NOEMBED "NOEMBED"
#define ELEMENT_NOFRAMES "NOFRAMES"
#define ELEMENT_NOSCRIPT "NOSCRIPT"
#define ELEMENT_OBJECT "OBJECT"
#define ELEMENT_OL "OL"
#define ELEMENT_OPTGROUP "OPTGROUP"
#define ELEMENT_OPTION "OPTION"
#define ELEMENT_OUTPUT "OUTPUT"
#define ELEMENT_P "P"
#define ELEMENT_PARAM "PARAM"
#define ELEMENT_PLAINTEXT "PLAINTEXT"
#define ELEMENT_PRE "PRE"
#define ELEMENT_PROGRESS "PROGRESS"
#define ELEMENT_Q "Q"
#define ELEMENT_RB "RB"
#define ELEMENT_RP "RP"
#define ELEMENT_RT "RT"
#define ELEMENT_RTC "RTC"
#define ELEMENT_RUBY "RUBY"
#define ELEMENT_S "S"
#define ELEMENT_SAMP "SAMP"
#define ELEMENT_SCRIPT "SCRIPT"
#define ELEMENT_SECTION "SECTION"
#define ELEMENT_SELECT "SELECT"
#define ELEMENT_SMALL "SMALL"
#define ELEMENT_SOURCE "SOURCE"
#define ELEMENT_SPAN "SPAN"
#define ELEMENT_STRIKE "STRIKE"
#define ELEMENT_STRONG "STRONG"
#define ELEMENT_STYLE "STYLE"
#define ELEMENT_SUB "SUB"
#define ELEMENT_SUMMARY "SUMMARY"
#define ELEMENT_SUP "SUP"
#define ELEMENT_SVG "SVG"
#define ELEMENT_TABLE "TABLE"
#define ELEMENT_TBODY "TBODY"
#define ELEMENT_TD "TD"
#define ELEMENT_TEMPLATE "TEMPLATE"
#define ELEMENT_TEXTAREA "TEXTAREA"
#define ELEMENT_TFOOT "TFOOT"
#define ELEMENT_TH "TH"
#define ELEMENT_THEAD "THEAD"
#define ELEMENT_TIME "TIME"
#define ELEMENT_TITLE "TITLE"
#define ELEMENT_TR "TR"
#define ELEMENT_TRACK "TRACK"
#define ELEMENT_TT "TT"
#define ELEMENT_U "U"
#define ELEMENT_UL "UL"
#define ELEMENT_VAR "VAR"
#define ELEMENT_VIDEO "VIDEO"
#define ELEMENT_WBR "WBR"
#define ELEMENT_XMP "XMP"
#define ELEMENT_ALTGLYPH "ALTGLYPH"
#define ELEMENT_ALTGLYPHDEF "ALTGLYPHDEF"
#define ELEMENT_ALTGLYPHITEM "ALTGLYPHITEM"
#define ELEMENT_ANIMATE "ANIMATE"
#define ELEMENT_ANIMATECOLOR "ANIMATECOLOR"
#define ELEMENT_ANIMATEMOTION "ANIMATEMOTION"
#define ELEMENT_ANIMATETRANSFORM "ANIMATETRANSFORM"
#define ELEMENT_CIRCLE "CIRCLE"
#define ELEMENT_CLIPPATH "CLIPPATH"
#define ELEMENT_COLOR_PROFILE "COLOR_PROFILE"
#define ELEMENT_CURSOR "CURSOR"
#define ELEMENT_DEFS "DEFS"
#define ELEMENT_DESC "DESC"
#define ELEMENT_ELLIPSE "ELLIPSE"
#define ELEMENT_FEBLEND "FEBLEND"
#define ELEMENT_FECOLORMATRIX "FECOLORMATRIX"
#define ELEMENT_FECOMPONENTTRANSFER "FECOMPONENTTRANSFER"
#define ELEMENT_FECOMPOSITE "FECOMPOSITE"
#define ELEMENT_FECONVOLVEMATRIX "FECONVOLVEMATRIX"
#define ELEMENT_FEDIFFUSELIGHTING "FEDIFFUSELIGHTING"
#define ELEMENT_FEDISPLACEMENTMAP "FEDISPLACEMENTMAP"
#define ELEMENT_FEDISTANTLIGHT "FEDISTANTLIGHT"
#define ELEMENT_FEDROPSHADOW "FEDROPSHADOW"
#define ELEMENT_FEFLOOD "FEFLOOD"
#define ELEMENT_FEFUNCA "FEFUNCA"
#define ELEMENT_FEFUNCB "FEFUNCB"
#define ELEMENT_FEFUNCG "FEFUNCG"
#define ELEMENT_FEFUNCR "FEFUNCR"
#define ELEMENT_FEGAUSSIANBLUR "FEGAUSSIANBLUR"
#define ELEMENT_FEIMAGE "FEIMAGE"
#define ELEMENT_FEMERGE "FEMERGE"
#define ELEMENT_FEMERGENODE "FEMERGENODE"
#define ELEMENT_FEMORPHOLOGY "FEMORPHOLOGY"
#define ELEMENT_FEOFFSET "FEOFFSET"
#define ELEMENT_FEPOINTLIGHT "FEPOINTLIGHT"
#define ELEMENT_FESPECULARLIGHTING "FESPECULARLIGHTING"
#define ELEMENT_FESPOTLIGHT "FESPOTLIGHT"
#define ELEMENT_FETILE "FETILE"
#define ELEMENT_FETURBULENCE "FETURBULENCE"
#define ELEMENT_FILTER "FILTER"
#define ELEMENT_FONT_FACE "FONT_FACE"
#define ELEMENT_FONT_FACE_FORMAT "FONT_FACE_FORMAT"
#define ELEMENT_FONT_FACE_NAME "FONT_FACE_NAME"
#define ELEMENT_FONT_FACE_SRC "FONT_FACE_SRC"
#define ELEMENT_FONT_FACE_URI "FONT_FACE_URI"
#define ELEMENT_FOREIGNOBJECT "FOREIGNOBJECT"
#define ELEMENT_G "G"
#define ELEMENT_GLYPH "GLYPH"
#define ELEMENT_GLYPHREF "GLYPHREF"
#define ELEMENT_HKERN "HKERN"
#define ELEMENT_LINE "LINE"
#define ELEMENT_LINEARGRADIENT "LINEARGRADIENT"
#define ELEMENT_MARKER "MARKER"
#define ELEMENT_MASK "MASK"
#define ELEMENT_METADATA "METADATA"
#define ELEMENT_MISSING_GLYPH "MISSING_GLYPH"
#define ELEMENT_MPATH "MPATH"
#define ELEMENT_PATH "PATH"
#define ELEMENT_PATTERN "PATTERN"
#define ELEMENT_POLYGON "POLYGON"
#define ELEMENT_POLYLINE "POLYLINE"
#define ELEMENT_RADIALGRADIENT "RADIALGRADIENT"
#define ELEMENT_RECT "RECT"
#define ELEMENT_SET "SET"
#define ELEMENT_STOP "STOP"
#define ELEMENT_SWITCH "SWITCH"
#define ELEMENT_SYMBOL "SYMBOL"
#define ELEMENT_TEXT "TEXT"
#define ELEMENT_TEXTPATH "TEXTPATH"
#define ELEMENT_TREF "TREF"
#define ELEMENT_TSPAN "TSPAN"
#define ELEMENT_USE "USE"
#define ELEMENT_VIEW "VIEW"
#define ELEMENT_VKERN "VKERN"
#define ELEMENT_MATH "MATH"
#define ELEMENT_MACTION "MACTION"
#define ELEMENT_MALIGNGROUP "MALIGNGROUP"
#define ELEMENT_MALIGNMARK "MALIGNMARK"
#define ELEMENT_MENCLOSE "MENCLOSE"
#define ELEMENT_MERROR "MERROR"
#define ELEMENT_MFENCED "MFENCED"
#define ELEMENT_MFRAC "MFRAC"
#define ELEMENT_MGLYPH "MGLYPH"
#define ELEMENT_MI "MI"
#define ELEMENT_MLABELEDTR "MLABELEDTR"
#define ELEMENT_MLONGDIV "MLONGDIV"
#define ELEMENT_MMULTISCRIPTS "MMULTISCRIPTS"
#define ELEMENT_MN "MN"
#define ELEMENT_MO "MO"
#define ELEMENT_MOVER "MOVER"
#define ELEMENT_MPADDED "MPADDED"
#define ELEMENT_MPHANTOM "MPHANTOM"
#define ELEMENT_MROOT "MROOT"
#define ELEMENT_MROW "MROW"
#define ELEMENT_MS "MS"
#define ELEMENT_MSCARRIES "MSCARRIES"
#define ELEMENT_MSCARRY "MSCARRY"
#define ELEMENT_MSGROUP "MSGROUP"
#define ELEMENT_MSLINE "MSLINE"
#define ELEMENT_MSPACE "MSPACE"
#define ELEMENT_MSQRT "MSQRT"
#define ELEMENT_MSROW "MSROW"
#define ELEMENT_MSTACK "MSTACK"
#define ELEMENT_MSTYLE "MSTYLE"
#define ELEMENT_MSUB "MSUB"
#define ELEMENT_MSUP "MSUP"
#define ELEMENT_MSUBSUP "MSUBSUP"

#define ELEMENT_DATA "DATA"
#define ELEMENT_PICTURE "PICTURE"
#define ELEMENT_SLOT "SLOT"
#define ELEMENT_WEBMENTION "WEBMENTION"

#define ELEMENT_EOF "-end-of-file"

struct symbol_entry < size_t > elem_symbol_table [] =
{   { ELEMENT__UNDEF, MyHTML_TAG__UNDEF },
    { ELEMENT__TEXT, MyHTML_TAG__TEXT },
    { ELEMENT__COMMENT, MyHTML_TAG__COMMENT },
    { ELEMENT__DOCTYPE, MyHTML_TAG__DOCTYPE },
    { ELEMENT_A, MyHTML_TAG_A },
    { ELEMENT_ABBR, MyHTML_TAG_ABBR },
    { ELEMENT_ACRONYM, MyHTML_TAG_ACRONYM },
    { ELEMENT_ADDRESS, MyHTML_TAG_ADDRESS },
    { ELEMENT_ANNOTATION_XML, MyHTML_TAG_ANNOTATION_XML },
    { ELEMENT_APPLET, MyHTML_TAG_APPLET },
    { ELEMENT_AREA, MyHTML_TAG_AREA },
    { ELEMENT_ARTICLE, MyHTML_TAG_ARTICLE },
    { ELEMENT_ASIDE, MyHTML_TAG_ASIDE },
    { ELEMENT_AUDIO, MyHTML_TAG_AUDIO },
    { ELEMENT_B, MyHTML_TAG_B },
    { ELEMENT_BASE, MyHTML_TAG_BASE },
    { ELEMENT_BASEFONT, MyHTML_TAG_BASEFONT },
    { ELEMENT_BDI, MyHTML_TAG_BDI },
    { ELEMENT_BDO, MyHTML_TAG_BDO },
    { ELEMENT_BGSOUND, MyHTML_TAG_BGSOUND },
    { ELEMENT_BIG, MyHTML_TAG_BIG },
    { ELEMENT_BLINK, MyHTML_TAG_BLINK },
    { ELEMENT_BLOCKQUOTE, MyHTML_TAG_BLOCKQUOTE },
    { ELEMENT_BODY, MyHTML_TAG_BODY },
    { ELEMENT_BR, MyHTML_TAG_BR },
    { ELEMENT_BUTTON, MyHTML_TAG_BUTTON },
    { ELEMENT_CANVAS, MyHTML_TAG_CANVAS },
    { ELEMENT_CAPTION, MyHTML_TAG_CAPTION },
    { ELEMENT_CENTER, MyHTML_TAG_CENTER },
    { ELEMENT_CITE, MyHTML_TAG_CITE },
    { ELEMENT_CODE, MyHTML_TAG_CODE },
    { ELEMENT_COL, MyHTML_TAG_COL },
    { ELEMENT_COLGROUP, MyHTML_TAG_COLGROUP },
    { ELEMENT_COMMAND, MyHTML_TAG_COMMAND },
    { ELEMENT_COMMENT, MyHTML_TAG_COMMENT },
    { ELEMENT_DATALIST, MyHTML_TAG_DATALIST },
    { ELEMENT_DD, MyHTML_TAG_DD },
    { ELEMENT_DEL, MyHTML_TAG_DEL },
    { ELEMENT_DETAILS, MyHTML_TAG_DETAILS },
    { ELEMENT_DFN, MyHTML_TAG_DFN },
    { ELEMENT_DIALOG, MyHTML_TAG_DIALOG },
    { ELEMENT_DIR, MyHTML_TAG_DIR },
    { ELEMENT_DIV, MyHTML_TAG_DIV },
    { ELEMENT_DL, MyHTML_TAG_DL },
    { ELEMENT_DT, MyHTML_TAG_DT },
    { ELEMENT_EM, MyHTML_TAG_EM },
    { ELEMENT_EMBED, MyHTML_TAG_EMBED },
    { ELEMENT_FIELDSET, MyHTML_TAG_FIELDSET },
    { ELEMENT_FIGCAPTION, MyHTML_TAG_FIGCAPTION },
    { ELEMENT_FIGURE, MyHTML_TAG_FIGURE },
    { ELEMENT_FONT, MyHTML_TAG_FONT },
    { ELEMENT_FOOTER, MyHTML_TAG_FOOTER },
    { ELEMENT_FORM, MyHTML_TAG_FORM },
    { ELEMENT_FRAME, MyHTML_TAG_FRAME },
    { ELEMENT_FRAMESET, MyHTML_TAG_FRAMESET },
    { ELEMENT_H1, MyHTML_TAG_H1 },
    { ELEMENT_H2, MyHTML_TAG_H2 },
    { ELEMENT_H3, MyHTML_TAG_H3 },
    { ELEMENT_H4, MyHTML_TAG_H4 },
    { ELEMENT_H5, MyHTML_TAG_H5 },
    { ELEMENT_H6, MyHTML_TAG_H6 },
    { ELEMENT_HEAD, MyHTML_TAG_HEAD },
    { ELEMENT_HEADER, MyHTML_TAG_HEADER },
    { ELEMENT_HGROUP, MyHTML_TAG_HGROUP },
    { ELEMENT_HR, MyHTML_TAG_HR },
    { ELEMENT_HTML, MyHTML_TAG_HTML },
    { ELEMENT_I, MyHTML_TAG_I },
    { ELEMENT_IFRAME, MyHTML_TAG_IFRAME },
    { ELEMENT_IMAGE, MyHTML_TAG_IMAGE },
    { ELEMENT_IMG, MyHTML_TAG_IMG },
    { ELEMENT_INPUT, MyHTML_TAG_INPUT },
    { ELEMENT_INS, MyHTML_TAG_INS },
    { ELEMENT_ISINDEX, MyHTML_TAG_ISINDEX },
    { ELEMENT_KBD, MyHTML_TAG_KBD },
    { ELEMENT_KEYGEN, MyHTML_TAG_KEYGEN },
    { ELEMENT_LABEL, MyHTML_TAG_LABEL },
    { ELEMENT_LEGEND, MyHTML_TAG_LEGEND },
    { ELEMENT_LI, MyHTML_TAG_LI },
    { ELEMENT_LINK, MyHTML_TAG_LINK },
    { ELEMENT_LISTING, MyHTML_TAG_LISTING },
    { ELEMENT_MAIN, MyHTML_TAG_MAIN },
    { ELEMENT_MAP, MyHTML_TAG_MAP },
    { ELEMENT_MARK, MyHTML_TAG_MARK },
    { ELEMENT_MARQUEE, MyHTML_TAG_MARQUEE },
    { ELEMENT_MENU, MyHTML_TAG_MENU },
    { ELEMENT_MENUITEM, MyHTML_TAG_MENUITEM },
    { ELEMENT_META, MyHTML_TAG_META },
    { ELEMENT_METER, MyHTML_TAG_METER },
    { ELEMENT_MTEXT, MyHTML_TAG_MTEXT },
    { ELEMENT_NAV, MyHTML_TAG_NAV },
    { ELEMENT_NOBR, MyHTML_TAG_NOBR },
    { ELEMENT_NOEMBED, MyHTML_TAG_NOEMBED },
    { ELEMENT_NOFRAMES, MyHTML_TAG_NOFRAMES },
    { ELEMENT_NOSCRIPT, MyHTML_TAG_NOSCRIPT },
    { ELEMENT_OBJECT, MyHTML_TAG_OBJECT },
    { ELEMENT_OL, MyHTML_TAG_OL },
    { ELEMENT_OPTGROUP, MyHTML_TAG_OPTGROUP },
    { ELEMENT_OPTION, MyHTML_TAG_OPTION },
    { ELEMENT_OUTPUT, MyHTML_TAG_OUTPUT },
    { ELEMENT_P, MyHTML_TAG_P },
    { ELEMENT_PARAM, MyHTML_TAG_PARAM },
    { ELEMENT_PLAINTEXT, MyHTML_TAG_PLAINTEXT },
    { ELEMENT_PRE, MyHTML_TAG_PRE },
    { ELEMENT_PROGRESS, MyHTML_TAG_PROGRESS },
    { ELEMENT_Q, MyHTML_TAG_Q },
    { ELEMENT_RB, MyHTML_TAG_RB },
    { ELEMENT_RP, MyHTML_TAG_RP },
    { ELEMENT_RT, MyHTML_TAG_RT },
    { ELEMENT_RTC, MyHTML_TAG_RTC },
    { ELEMENT_RUBY, MyHTML_TAG_RUBY },
    { ELEMENT_S, MyHTML_TAG_S },
    { ELEMENT_SAMP, MyHTML_TAG_SAMP },
    { ELEMENT_SCRIPT, MyHTML_TAG_SCRIPT },
    { ELEMENT_SECTION, MyHTML_TAG_SECTION },
    { ELEMENT_SELECT, MyHTML_TAG_SELECT },
    { ELEMENT_SMALL, MyHTML_TAG_SMALL },
    { ELEMENT_SOURCE, MyHTML_TAG_SOURCE },
    { ELEMENT_SPAN, MyHTML_TAG_SPAN },
    { ELEMENT_STRIKE, MyHTML_TAG_STRIKE },
    { ELEMENT_STRONG, MyHTML_TAG_STRONG },
    { ELEMENT_STYLE, MyHTML_TAG_STYLE },
    { ELEMENT_SUB, MyHTML_TAG_SUB },
    { ELEMENT_SUMMARY, MyHTML_TAG_SUMMARY },
    { ELEMENT_SUP, MyHTML_TAG_SUP },
    { ELEMENT_SVG, MyHTML_TAG_SVG },
    { ELEMENT_TABLE, MyHTML_TAG_TABLE },
    { ELEMENT_TBODY, MyHTML_TAG_TBODY },
    { ELEMENT_TD, MyHTML_TAG_TD },
    { ELEMENT_TEMPLATE, MyHTML_TAG_TEMPLATE },
    { ELEMENT_TEXTAREA, MyHTML_TAG_TEXTAREA },
    { ELEMENT_TFOOT, MyHTML_TAG_TFOOT },
    { ELEMENT_TH, MyHTML_TAG_TH },
    { ELEMENT_THEAD, MyHTML_TAG_THEAD },
    { ELEMENT_TIME, MyHTML_TAG_TIME },
    { ELEMENT_TITLE, MyHTML_TAG_TITLE },
    { ELEMENT_TR, MyHTML_TAG_TR },
    { ELEMENT_TRACK, MyHTML_TAG_TRACK },
    { ELEMENT_TT, MyHTML_TAG_TT },
    { ELEMENT_U, MyHTML_TAG_U },
    { ELEMENT_UL, MyHTML_TAG_UL },
    { ELEMENT_VAR, MyHTML_TAG_VAR },
    { ELEMENT_VIDEO, MyHTML_TAG_VIDEO },
    { ELEMENT_WBR, MyHTML_TAG_WBR },
    { ELEMENT_XMP, MyHTML_TAG_XMP },
    { ELEMENT_ALTGLYPH, MyHTML_TAG_ALTGLYPH },
    { ELEMENT_ALTGLYPHDEF, MyHTML_TAG_ALTGLYPHDEF },
    { ELEMENT_ALTGLYPHITEM, MyHTML_TAG_ALTGLYPHITEM },
    { ELEMENT_ANIMATE, MyHTML_TAG_ANIMATE },
    { ELEMENT_ANIMATECOLOR, MyHTML_TAG_ANIMATECOLOR },
    { ELEMENT_ANIMATEMOTION, MyHTML_TAG_ANIMATEMOTION },
    { ELEMENT_ANIMATETRANSFORM, MyHTML_TAG_ANIMATETRANSFORM },
    { ELEMENT_CIRCLE, MyHTML_TAG_CIRCLE },
    { ELEMENT_CLIPPATH, MyHTML_TAG_CLIPPATH },
    { ELEMENT_COLOR_PROFILE, MyHTML_TAG_COLOR_PROFILE },
    { ELEMENT_CURSOR, MyHTML_TAG_CURSOR },
    { ELEMENT_DEFS, MyHTML_TAG_DEFS },
    { ELEMENT_DESC, MyHTML_TAG_DESC },
    { ELEMENT_ELLIPSE, MyHTML_TAG_ELLIPSE },
    { ELEMENT_FEBLEND, MyHTML_TAG_FEBLEND },
    { ELEMENT_FECOLORMATRIX, MyHTML_TAG_FECOLORMATRIX },
    { ELEMENT_FECOMPONENTTRANSFER, MyHTML_TAG_FECOMPONENTTRANSFER },
    { ELEMENT_FECOMPOSITE, MyHTML_TAG_FECOMPOSITE },
    { ELEMENT_FECONVOLVEMATRIX, MyHTML_TAG_FECONVOLVEMATRIX },
    { ELEMENT_FEDIFFUSELIGHTING, MyHTML_TAG_FEDIFFUSELIGHTING },
    { ELEMENT_FEDISPLACEMENTMAP, MyHTML_TAG_FEDISPLACEMENTMAP },
    { ELEMENT_FEDISTANTLIGHT, MyHTML_TAG_FEDISTANTLIGHT },
    { ELEMENT_FEDROPSHADOW, MyHTML_TAG_FEDROPSHADOW },
    { ELEMENT_FEFLOOD, MyHTML_TAG_FEFLOOD },
    { ELEMENT_FEFUNCA, MyHTML_TAG_FEFUNCA },
    { ELEMENT_FEFUNCB, MyHTML_TAG_FEFUNCB },
    { ELEMENT_FEFUNCG, MyHTML_TAG_FEFUNCG },
    { ELEMENT_FEFUNCR, MyHTML_TAG_FEFUNCR },
    { ELEMENT_FEGAUSSIANBLUR, MyHTML_TAG_FEGAUSSIANBLUR },
    { ELEMENT_FEIMAGE, MyHTML_TAG_FEIMAGE },
    { ELEMENT_FEMERGE, MyHTML_TAG_FEMERGE },
    { ELEMENT_FEMERGENODE, MyHTML_TAG_FEMERGENODE },
    { ELEMENT_FEMORPHOLOGY, MyHTML_TAG_FEMORPHOLOGY },
    { ELEMENT_FEOFFSET, MyHTML_TAG_FEOFFSET },
    { ELEMENT_FEPOINTLIGHT, MyHTML_TAG_FEPOINTLIGHT },
    { ELEMENT_FESPECULARLIGHTING, MyHTML_TAG_FESPECULARLIGHTING },
    { ELEMENT_FESPOTLIGHT, MyHTML_TAG_FESPOTLIGHT },
    { ELEMENT_FETILE, MyHTML_TAG_FETILE },
    { ELEMENT_FETURBULENCE, MyHTML_TAG_FETURBULENCE },
    { ELEMENT_FILTER, MyHTML_TAG_FILTER },
    { ELEMENT_FONT_FACE, MyHTML_TAG_FONT_FACE },
    { ELEMENT_FONT_FACE_FORMAT, MyHTML_TAG_FONT_FACE_FORMAT },
    { ELEMENT_FONT_FACE_NAME, MyHTML_TAG_FONT_FACE_NAME },
    { ELEMENT_FONT_FACE_SRC, MyHTML_TAG_FONT_FACE_SRC },
    { ELEMENT_FONT_FACE_URI, MyHTML_TAG_FONT_FACE_URI },
    { ELEMENT_FOREIGNOBJECT, MyHTML_TAG_FOREIGNOBJECT },
    { ELEMENT_G, MyHTML_TAG_G },
    { ELEMENT_GLYPH, MyHTML_TAG_GLYPH },
    { ELEMENT_GLYPHREF, MyHTML_TAG_GLYPHREF },
    { ELEMENT_HKERN, MyHTML_TAG_HKERN },
    { ELEMENT_LINE, MyHTML_TAG_LINE },
    { ELEMENT_LINEARGRADIENT, MyHTML_TAG_LINEARGRADIENT },
    { ELEMENT_MARKER, MyHTML_TAG_MARKER },
    { ELEMENT_MASK, MyHTML_TAG_MASK },
    { ELEMENT_METADATA, MyHTML_TAG_METADATA },
    { ELEMENT_MISSING_GLYPH, MyHTML_TAG_MISSING_GLYPH },
    { ELEMENT_MPATH, MyHTML_TAG_MPATH },
    { ELEMENT_PATH, MyHTML_TAG_PATH },
    { ELEMENT_PATTERN, MyHTML_TAG_PATTERN },
    { ELEMENT_POLYGON, MyHTML_TAG_POLYGON },
    { ELEMENT_POLYLINE, MyHTML_TAG_POLYLINE },
    { ELEMENT_RADIALGRADIENT, MyHTML_TAG_RADIALGRADIENT },
    { ELEMENT_RECT, MyHTML_TAG_RECT },
    { ELEMENT_SET, MyHTML_TAG_SET },
    { ELEMENT_STOP, MyHTML_TAG_STOP },
    { ELEMENT_SWITCH, MyHTML_TAG_SWITCH },
    { ELEMENT_SYMBOL, MyHTML_TAG_SYMBOL },
    { ELEMENT_TEXT, MyHTML_TAG_TEXT },
    { ELEMENT_TEXTPATH, MyHTML_TAG_TEXTPATH },
    { ELEMENT_TREF, MyHTML_TAG_TREF },
    { ELEMENT_TSPAN, MyHTML_TAG_TSPAN },
    { ELEMENT_USE, MyHTML_TAG_USE },
    { ELEMENT_VIEW, MyHTML_TAG_VIEW },
    { ELEMENT_VKERN, MyHTML_TAG_VKERN },
    { ELEMENT_MATH, MyHTML_TAG_MATH },
    { ELEMENT_MACTION, MyHTML_TAG_MACTION },
    { ELEMENT_MALIGNGROUP, MyHTML_TAG_MALIGNGROUP },
    { ELEMENT_MALIGNMARK, MyHTML_TAG_MALIGNMARK },
    { ELEMENT_MENCLOSE, MyHTML_TAG_MENCLOSE },
    { ELEMENT_MERROR, MyHTML_TAG_MERROR },
    { ELEMENT_MFENCED, MyHTML_TAG_MFENCED },
    { ELEMENT_MFRAC, MyHTML_TAG_MFRAC },
    { ELEMENT_MGLYPH, MyHTML_TAG_MGLYPH },
    { ELEMENT_MI, MyHTML_TAG_MI },
    { ELEMENT_MLABELEDTR, MyHTML_TAG_MLABELEDTR },
    { ELEMENT_MLONGDIV, MyHTML_TAG_MLONGDIV },
    { ELEMENT_MMULTISCRIPTS, MyHTML_TAG_MMULTISCRIPTS },
    { ELEMENT_MN, MyHTML_TAG_MN },
    { ELEMENT_MO, MyHTML_TAG_MO },
    { ELEMENT_MOVER, MyHTML_TAG_MOVER },
    { ELEMENT_MPADDED, MyHTML_TAG_MPADDED },
    { ELEMENT_MPHANTOM, MyHTML_TAG_MPHANTOM },
    { ELEMENT_MROOT, MyHTML_TAG_MROOT },
    { ELEMENT_MROW, MyHTML_TAG_MROW },
    { ELEMENT_MS, MyHTML_TAG_MS },
    { ELEMENT_MSCARRIES, MyHTML_TAG_MSCARRIES },
    { ELEMENT_MSCARRY, MyHTML_TAG_MSCARRY },
    { ELEMENT_MSGROUP, MyHTML_TAG_MSGROUP },
    { ELEMENT_MSLINE, MyHTML_TAG_MSLINE },
    { ELEMENT_MSPACE, MyHTML_TAG_MSPACE },
    { ELEMENT_MSQRT, MyHTML_TAG_MSQRT },
    { ELEMENT_MSROW, MyHTML_TAG_MSROW },
    { ELEMENT_MSTACK, MyHTML_TAG_MSTACK },
    { ELEMENT_MSTYLE, MyHTML_TAG_MSTYLE },
    { ELEMENT_MSUB, MyHTML_TAG_MSUB },
    { ELEMENT_MSUP, MyHTML_TAG_MSUP },
    { ELEMENT_MSUBSUP, MyHTML_TAG_MSUBSUP },

    { ELEMENT_DATA, TAG_DATA },
    { ELEMENT_PICTURE, TAG_PICTURE },
    { ELEMENT_SLOT, TAG_SLOT },
    { ELEMENT_WEBMENTION, TAG_WEBMENTION }
};

void elem::init ()
{   symbol::init (elem_symbol_table, sizeof (elem_symbol_table) / sizeof (symbol_entry < size_t >), true); }

size_t elem::parse (const ::std::string& x)
{   assert (! x.empty ());
    ::std::string lc (::boost::algorithm::to_upper_copy (x));
    size_t res = MyHTML_TAG__UNDEF;
    symbol::find (lc, res);
    return res; }

size_t elem::add_tag (const ::std::string& x, ::std::ostringstream& ss)
{   ::std::string tag (::boost::algorithm::to_upper_copy (x));
    if (context.tell (e_warning))
        if (tag == "CENTRE") ss << "centre spelt correctly. ";
        else if (tag == "DIALOGUE") ss << "dialogue spelt correctly. ";
        else if (tag == "COLOUR_PROFILE") ss << "colour spelt correctly ";
    append (tag, ++max_tag_);
    if (context.tell (e_warning)) ss << "Unrecognised element " <<  quote (x);
    return max_tag_; }
