/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once
#include "microformat.h"

typedef microformat < v_unknown, c_generic, ela_ok, ela_ok, name_at > mf_unknown;
typedef microformat < h_adr, c_microformat, ela_ok, ela_ok, altitude_at, country_name_at, extended_address_at, geo_at, ugeo_at, label_at, latitude_at, locality_at,
                        longitude_at, post_office_box_at, postal_code_at, region_at, street_address_at, geo_ht > mf_adr;
typedef microformat < h_breadcrumb, c_microformat, ela_ok, ela_ok, name_at, url_at > mf_breadcrumb;
typedef microformat < h_card, c_microformat, ela_ok, ela_ok, anniversary_at, bday_at, rev_at, additional_name_at, adr_at, altitude_at, category_at, country_name_at,
                        extended_address_at, family_name_at, gender_identity_at, geo_at, ugeo_at, given_name_at, honorific_prefix_at,
                        honorific_suffix_at, impp_at, job_title_at, key_at, label_at, latitude_at, locality_at, longitude_at,
                        name_at, nickname_at, note_at, org_at, organization_name_at, organization_unit_at, post_office_box_at,
                        postal_code_at, region_at, role_at, sex_at, sort_string_at, street_address_at, tel_at, tz_at,
                        email_at, ugeo_at, impp_at, key_at, logo_at, photo_at, sound_at, uid_at, url_at > mf_card;
typedef microformat < h_cite, c_microformat, ela_ok, ela_ok, accessed_at, published_at, author_at, content_at, name_at, publication_at, uid_at, url_at > mf_hcite;
typedef microformat < h_entry, c_microformat, ela_ok, ela_ok, published_at, updated_at, bookmark_of_at, comment_at, content_et, content_ht, author_at, category_at, geo_ht,
                        like_of_at, latitude_at, location_at, longitude_at, name_at, repost_of_at, rsvp_at, summary_at,
                        audio_at, featured_at, in_reply_to_at, like_at, photo_at, repost_at, syndication_at,
                        uid_at, url_at, video_at > mf_entry;
typedef microformat < h_event, c_microformat, ela_ok, ela_ok, duration_at, end_at, start_at, attendee_at, category_at, content_ht, description_at, geo_ht,
                        latitude_at, location_at, longitude_at, name_at, summary_at, url_at > mf_event;
typedef microformat < h_feed, c_microformat, ela_ok, ela_ok, name_at, author_at, url_at, photo_at, summary_at, entry_at > mf_feed;
typedef microformat < h_geo, c_microformat, ela_ok, ela_ok, latitude_at, longitude_at, altitude_at > mf_geo;
typedef microformat < h_item, c_microformat, ela_ok, ela_ok, name_at, url_at, photo_at > mf_item;
typedef microformat < h_listing, c_microformat, ela_ok, ela_ok, lister_at, listed_at, expired_at, price_at, category_at, action_at, url_at > mf_listing;
typedef microformat < h_product, c_microformat, ela_ok, ela_ok, description_ht, brand_at, category_at, name_at, price_at, review_at, identifier_at, photo_at,
                        url_at > mf_product;
typedef microformat < h_recipe, c_microformat, ela_ok, ela_ok, duration_at, published_at, instructions_at, author_at, category_at, ingredient_at, name_at,
                        nutrition_at, summary_at, yield_at, photo_at > mf_recipe;
typedef microformat < h_resume, c_microformat, ela_ok, ela_ok, affiliation_at, contact_at, education_at, experience_at, name_at, skill_at, summary_at > mf_resume;
typedef microformat < h_review, c_microformat, ela_ok, ela_ok, author_at, best_at, category_at, content_et, item_at, location_at, name_at, published_at,
                        rating_at, summary_at, syndication_at, url_at, worst_at > mf_review;
typedef microformat < h_aggregate, c_microformat, ela_ok, ela_ok, average_at, best_at, category_at, count_at, item_at, name_at, rating_at, votes_at, worst_at >
                        mf_aggregate;

typedef microformat < rel_about, c_generic, ela_ok, ela_ok, about_rt > mf_about;
typedef microformat < rel_accessibility, c_draft, ela_ok, ela_ok, accessibility_rt > mf_accessibility;
typedef microformat < rel_acquaintance, c_xfn, ela_no, ela_external, acquaintance_rt > mf_acquaintance;
typedef microformat < rel_alternative, c_html4 | c_atom, ela_external, ela_external, alternative_rt > mf_alternative;
typedef microformat < rel_amphtml, 0x0100, ela_hyperlink, ela_hyperlink, amphtml_rt > mf_amphtml; // https://github.com/ampproject/amphtml
typedef microformat < rel_appendix, c_html4, ela_ok, ela_ok, appendix_rt > mf_appendix;
typedef microformat < rel_apple_touch_icon, c_safari, ela_external, ela_no, apple_touch_icon_rt > mf_apple_touch_icon;
typedef microformat < rel_apple_touch_icon_precomposed, c_safari, ela_external, ela_no, apple_touch_icon_precomposed_rt > mf_apple_touch_icon_precomposed;
typedef microformat < rel_apple_touch_startup_image, c_safari, ela_external, ela_no, apple_touch_startup_image_rt > mf_apple_touch_startup_image;
typedef microformat < rel_archived, c_generic, ela_external, ela_hyperlink, archived_rt > mf_archived;     // https://sitemorse.com/rel-archived/
typedef microformat < rel_archives, c_generic, ela_ok, ela_ok, archives_rt > mf_archives;
typedef microformat < rel_attachment, c_generic, ela_hyperlink, ela_hyperlink, attachment_rt > mf_attachment;
typedef microformat < rel_author, c_microformat, ela_ok, ela_ok, author_rt > mf_author;
typedef microformat < rel_authorisation_endpoint, c_indieauth, ela_external, ela_no, authorisation_endpoint_rt > mf_authorisation_endpoint;
typedef microformat < rel_banner, c_html3 | c_dropped, ela_ok, ela_ok, banner_rt > mf_banner;
typedef microformat < rel_begin, c_html4 | c_dropped, ela_ok, ela_ok, begin_rt > mf_begin;
typedef microformat < rel_biblioentry, c_html4 | c_dropped, ela_ok, ela_ok, biblioentry_rt > mf_biblioentry;
typedef microformat < rel_bibliography, c_draft | c_html4 | c_dropped, ela_ok, ela_ok, bibliography_rt > mf_bibliography;
typedef microformat < rel_blocked_by, c_generic, ela_ok, ela_ok, blocked_by_rt > mf_blocked_by;
typedef microformat < rel_bookmark, c_html4, ela_no, ela_ok, bookmark_rt > mf_bookmark;
typedef microformat < rel_canonical, c_generic, ela_hyperlink, ela_hyperlink, canonical_rt > mf_canonical;
typedef microformat < rel_category, c_generic, ela_hyperlink, ela_hyperlink, category_rt > mf_category;

typedef microformat < rel_cc_permits, c_cc, ela_ok, ela_ok, cc_permits_rt > mf_cc_permits;
typedef microformat < rel_cc_requires, c_cc, ela_ok, ela_ok, cc_requires_rt > mf_cc_requires;
typedef microformat < rel_cc_prohibits, c_cc, ela_ok, ela_ok, cc_prohibits_rt > mf_cc_prohibits;
typedef microformat < rel_cc_jurisdiction, c_cc, ela_ok, ela_ok, cc_jurisdiction_rt > mf_cc_jurisdiction;
typedef microformat < rel_cc_legalcode, c_cc, ela_ok, ela_ok, cc_legalcode_rt > mf_cc_legalcode;
typedef microformat < rel_cc_deprecatedon, c_cc, ela_ok, ela_ok, cc_deprecatedon_rt > mf_cc_deprecatedon;
typedef microformat < rel_cc_licence, c_cc, ela_ok, ela_ok, cc_licence_rt > mf_cc_licence;
typedef microformat < rel_cc_morepermissions, c_cc, ela_ok, ela_ok, cc_morepermissions_rt > mf_cc_morepermissions;
// typedef microformat < rel_cc_attributionname, c_cc, ela_ok, ela_ok, cc_attributionname_rt > mf_cc_attributionname;
typedef microformat < rel_cc_attributionurl, c_cc, ela_ok, ela_ok, cc_attributionurl_rt > mf_cc_attributionurl;
typedef microformat < rel_cc_useguidelines, c_cc, ela_ok, ela_ok, cc_useguidelines_rt > mf_cc_useguidelines;

typedef microformat < rel_chapter, c_html4, ela_ok, ela_ok, chapter_rt > mf_chapter;
typedef microformat < rel_child, c_xfn | c_html4 | c_dropped, ela_external, ela_external, child_rt > mf_child;
typedef microformat < rel_chrome_webstore_item, c_generic, ela_external, ela_no, chrome_webstore_item_rt > mf_chrome_webstore_item;
typedef microformat < rel_citation, c_html4 | c_dropped, ela_ok, ela_ok, citation_rt > mf_citation;
typedef microformat < rel_cite, c_draft, ela_ok, ela_ok, cite_rt > mf_relcite;
typedef microformat < rel_cite_as, c_generic, ela_ok, ela_ok, cite_as_rt > mf_cite_as;
typedef microformat < rel_code_licence, c_generic, ela_hyperlink, ela_hyperlink, code_licence_rt > mf_code_licence;
typedef microformat < rel_code_repository, c_generic, ela_hyperlink, ela_hyperlink, code_licence_rt > mf_code_repository;
typedef microformat < rel_colleague, c_xfn, ela_no, ela_external, colleague_rt > mf_colleague;
typedef microformat < rel_collection, c_html4 | c_dropped, ela_ok, ela_ok, collection_rt > mf_collection;
typedef microformat < rel_comment, c_generic, ela_ok, ela_ok, comment_rt > mf_comment;
typedef microformat < rel_component, c_generic, ela_external, ela_no, component_rt > mf_component;
typedef microformat < rel_contact, c_xfn, ela_no, ela_external, contact_rt > mf_contact;
typedef microformat < rel_content_licence, c_generic, ela_ok, ela_ok, content_licence_rt > mf_content_licence;
typedef microformat < rel_content_repository, c_generic, ela_hyperlink, ela_hyperlink, content_repository_rt > mf_content_repository;
typedef microformat < rel_contents, c_html4, ela_ok, ela_ok, contents_rt > mf_contents;
typedef microformat < rel_contribution, c_generic, ela_ok, ela_ok, contribution_rt > mf_contribution;
typedef microformat < rel_convertedfrom, c_generic, ela_ok, ela_ok, convertedfrom_rt > mf_convertedfrom;
typedef microformat < rel_copyright, c_html4, ela_ok, ela_ok, copyright_rt > mf_copyright;
typedef microformat < rel_coresident, c_xfn, ela_no, ela_external, coresident_rt > mf_coresident;
typedef microformat < rel_coworker, c_xfn, ela_no, ela_external, coworker_rt > mf_coworker;
typedef microformat < rel_create_form, c_generic, ela_ok, ela_ok, create_form_rt > mf_create_form;
typedef microformat < rel_crush, c_xfn, ela_no, ela_external, crush_rt > mf_crush;
typedef microformat < rel_current, c_generic, ela_ok, ela_ok, current_rt > mf_current;
typedef microformat < rel_date, c_xfn, ela_no, ela_external, date_rt > mf_date;
typedef microformat < rel_dcterms_conformsto, c_dcterms, ela_external, ela_no, dcterms_conformsto_rt > mf_dcterms_conformsto;
typedef microformat < rel_dcterms_contributor, c_dcterms, ela_external, ela_no, dcterms_contributor_rt > mf_dcterms_contributor;
typedef microformat < rel_dcterms_creator, c_dcterms, ela_external, ela_no, dcterms_creator_rt > mf_dcterms_creator;
typedef microformat < rel_dcterms_description, c_dcterms, ela_external, ela_no, dcterms_description_rt > mf_dcterms_description;
typedef microformat < rel_dcterms_hasformat, c_dcterms, ela_external, ela_no, dcterms_hasformat_rt > mf_dcterms_hasformat;
typedef microformat < rel_dcterms_haspart, c_dcterms, ela_external, ela_no, dcterms_haspart_rt > mf_dcterms_haspart;
typedef microformat < rel_dcterms_hasversion, c_dcterms, ela_external, ela_no, dcterms_hasversion_rt > mf_dcterms_hasversion;
typedef microformat < rel_dcterms_isformatof, c_dcterms, ela_external, ela_no, dcterms_isformatof_rt > mf_dcterms_isformatof;
typedef microformat < rel_dcterms_ispartof, c_dcterms, ela_external, ela_no, dcterms_ispartof_rt > mf_dcterms_ispartof;
typedef microformat < rel_dcterms_isreferencedby, c_dcterms, ela_external, ela_no, dcterms_isreferencedby_rt > mf_dcterms_isreferencedby;
typedef microformat < rel_dcterms_isreplacedby, c_dcterms, ela_external, ela_no, dcterms_isreplacedby_rt > mf_dcterms_isreplacedby;
typedef microformat < rel_dcterms_isrequiredby, c_dcterms, ela_external, ela_no, dcterms_isrequiredby_rt > mf_dcterms_isrequiredby;
typedef microformat < rel_dcterms_isversionof, c_dcterms, ela_external, ela_no, dcterms_isversionof_rt > mf_dcterms_isversionof;
typedef microformat < rel_dcterms_licence, c_dcterms, ela_external, ela_no, dcterms_licence_rt > mf_dcterms_licence;
typedef microformat < rel_dcterms_mediator, c_dcterms, ela_external, ela_no, dcterms_mediator_rt > mf_dcterms_mediator;
typedef microformat < rel_dcterms_publisher, c_dcterms, ela_external, ela_no, dcterms_publisher_rt > mf_dcterms_publisher;
typedef microformat < rel_dcterms_references, c_dcterms, ela_external, ela_no, dcterms_references_rt > mf_dcterms_references;
typedef microformat < rel_dcterms_relation, c_dcterms, ela_external, ela_no, dcterms_relation_rt > mf_dcterms_relation;
typedef microformat < rel_dcterms_replaces, c_dcterms, ela_external, ela_no, dcterms_replaces_rt > mf_dcterms_replaces;
typedef microformat < rel_dcterms_requires, c_dcterms, ela_external, ela_no, dcterms_requires_rt > mf_dcterms_requires;
typedef microformat < rel_dcterms_rightsholder, c_dcterms, ela_external, ela_no, dcterms_rightsholder_rt > mf_dcterms_rightsholder;
typedef microformat < rel_dcterms_source, c_dcterms, ela_external, ela_no, dcterms_source_rt > mf_dcterms_source;
typedef microformat < rel_dcterms_subject, c_dcterms, ela_external, ela_no, dcterms_subject_rt > mf_dcterms_subject;
typedef microformat < rel_definition, c_html4 | c_dropped, ela_ok, ela_ok, definition_rt > mf_definition;
typedef microformat < rel_describedby, c_generic, ela_ok, ela_ok, describedby_rt > mf_describedby;
typedef microformat < rel_describes, c_generic, ela_ok, ela_ok, describes_rt > mf_describes;
typedef microformat < rel_directory, c_draft | c_microformat, ela_ok, ela_ok, directory_rt > mf_directory;
typedef microformat < rel_disclaimer, c_html4 | c_dropped, ela_ok, ela_ok, disclaimer_rt > mf_disclaimer;
typedef microformat < rel_disclosure, c_generic, ela_no, ela_external, disclosure_rt > mf_disclosure;
typedef microformat < rel_discussion, c_draft | c_microformat, ela_hyperlink, ela_hyperlink, discussion_rt > mf_discussion;
typedef microformat < rel_dnsprefetch, c_generic, ela_external, ela_no, dnsprefetch_rt > mf_dnsprefetch;
typedef microformat < rel_docs_oasis_open_org_ns_cmis_link_200908_acl, c_generic, ela_external, ela_external, docs_oasis_open_org_ns_cmis_link_200908_acl_rt > mf_docs_oasis_open_org_ns_cmis_link_200908_acl;
typedef microformat < rel_duplicate, c_generic, ela_ok, ela_ok, duplicate_rt > mf_duplicate;
typedef microformat < rel_edit, c_generic, ela_hyperlink, ela_no, edit_rt > mf_edit;
typedef microformat < rel_edit_form, c_generic, ela_ok, ela_ok, edit_form_rt > mf_edit_form;
typedef microformat < rel_edit_media, c_generic, ela_ok, ela_ok, edit_media_rt > mf_edit_media;
typedef microformat < rel_editor, c_html4 | c_dropped, ela_ok, ela_ok, editor_rt > mf_editor;
typedef microformat < rel_edituri, c_atom, ela_external, ela_no, edituri_rt > mf_edituri;
typedef microformat < rel_enclosure, c_draft | c_microformat | c_atom, ela_external, ela_external, enclosure_rt > mf_enclosure;
typedef microformat < rel_end, c_html4 | c_dropped, ela_ok, ela_ok, end_rt > mf_end;
typedef microformat < rel_endorsed, c_generic, ela_ok, ela_ok, endorsed_rt > mf_endorsed;
typedef microformat < rel_entry_content, c_generic, ela_ok, ela_ok, entry_content_rt > mf_entry_content;
typedef microformat < rel_external, c_generic, ela_ok, ela_ok, external_rt > mf_external;
typedef microformat < rel_fan, c_generic, ela_ok, ela_ok, fan_rt > mf_fan;
typedef microformat < rel_feed, c_generic, ela_ok, ela_ok, feed_rt > mf_relfeed;
typedef microformat < rel_first, c_html4 | c_dropped, ela_hyperlink, ela_hyperlink, first_rt > mf_first;
typedef microformat < rel_footnote, c_html4 | c_dropped, ela_ok, ela_ok, footnote_rt > mf_footnote;
typedef microformat < rel_friend, c_xfn, ela_no, ela_external, friend_rt > mf_friend;
typedef microformat < rel_gbfs, c_generic, ela_external, ela_no, gbfs_rt > mf_gbfs;
typedef microformat < rel_gtfs_realtime, c_generic, ela_external, ela_no, gtfs_realtime_rt > mf_gtfs_realtime;
typedef microformat < rel_gtfs_static, c_generic, ela_external, ela_no, gtfs_static_rt > mf_gtfs_static;
typedef microformat < rel_glossary, c_html4, ela_ok, ela_ok, glossary_rt > mf_glossary;
typedef microformat < rel_group, c_draft, ela_ok, ela_ok, group_rt > mf_group;
typedef microformat < rel_help, c_html4, ela_ok, ela_ok, help_rt > mf_help;
typedef microformat < rel_home, c_draft | c_microformat, ela_hyperlink, ela_hyperlink, home_rt > mf_home;
typedef microformat < rel_hosts, c_generic, ela_ok, ela_ok, hosts_rt > mf_hosts;
typedef microformat < rel_hub, c_generic, ela_hyperlink, ela_hyperlink, hub_rt > mf_hub;
typedef microformat < rel_icon, c_generic, ela_ok, ela_ok, icon_rt > mf_icon;
typedef microformat < rel_image_src, c_generic, ela_external, ela_no, image_src_rt > mf_image_src;
typedef microformat < rel_import, c_generic, ela_external, ela_no, import_rt > mf_import;
typedef microformat < rel_in_reply_to, c_generic, ela_hyperlink, ela_hyperlink, in_reply_to_rt > mf_in_reply_to;
typedef microformat < rel_index, c_html4 | c_dropped, ela_hyperlink, ela_hyperlink, index_rt > mf_index;
typedef microformat < rel_intervalafter, c_generic, ela_ok, ela_ok, intervalafter_rt > mf_intervalafter;
typedef microformat < rel_intervalbefore, c_generic, ela_ok, ela_ok, intervalbefore_rt > mf_intervalbefore;
typedef microformat < rel_intervalcontains, c_generic, ela_ok, ela_ok, intervalcontains_rt > mf_intervalcontains;
typedef microformat < rel_intervaldisjoint, c_generic, ela_ok, ela_ok, intervaldisjoint_rt > mf_intervaldisjoint;
typedef microformat < rel_intervalduring, c_generic, ela_ok, ela_ok, intervalduring_rt > mf_intervalduring;
typedef microformat < rel_intervalequals, c_generic, ela_ok, ela_ok, intervalequals_rt > mf_intervalequals;
typedef microformat < rel_intervalfinishedby, c_generic, ela_ok, ela_ok, intervalfinishedby_rt > mf_intervalfinishedby;
typedef microformat < rel_intervalfinishes, c_generic, ela_ok, ela_ok, intervalfinishes_rt > mf_intervalfinishes;
typedef microformat < rel_intervalin, c_generic, ela_ok, ela_ok, intervalin_rt > mf_intervalin;
typedef microformat < rel_intervalmeets, c_generic, ela_ok, ela_ok, intervalmeets_rt > mf_intervalmeets;
typedef microformat < rel_intervalmetby, c_generic, ela_ok, ela_ok, intervalmetby_rt > mf_intervalmetby;
typedef microformat < rel_intervaloverlappedby, c_generic, ela_ok, ela_ok, intervaloverlappedby_rt > mf_intervaloverlappedby;
typedef microformat < rel_intervaloverlaps, c_generic, ela_ok, ela_ok, intervaloverlaps_rt > mf_intervaloverlaps;
typedef microformat < rel_intervalstartedby, c_generic, ela_ok, ela_ok, intervalstartedby_rt > mf_intervalstartedby;
typedef microformat < rel_intervalstarts, c_generic, ela_ok, ela_ok, intervalstarts_rt > mf_intervalstarts;
typedef microformat < rel_issues, c_generic, ela_hyperlink, ela_hyperlink, issues_rt > mf_issues;
typedef microformat < rel_item, c_generic, ela_ok, ela_ok, item_rt > mf_relitem;
typedef microformat < rel_item, c_generic, ela_ok, ela_ok, item_rt > mf_rtitem;
typedef microformat < rel_its_rules, c_its, ela_ok, ela_no, its_rules_rt > mf_its_rules;
typedef microformat < rel_jslicence, c_generic, ela_hyperlink, ela_hyperlink, jslicence_rt > mf_jslicence;
typedef microformat < rel_kin, c_xfn, ela_no, ela_external, kin_rt > mf_kin;
typedef microformat < rel_kinetic_stylesheet, c_generic, ela_ok, ela_ok, kinetic_stylesheet_rt > mf_kinetic_stylesheet;
typedef microformat < rel_last, c_html4 | c_dropped, ela_hyperlink, ela_hyperlink, last_rt > mf_last;
typedef microformat < rel_latest_version, c_generic, ela_ok, ela_ok, latest_version_rt > mf_latest_version;
typedef microformat < rel_licence, c_microformat, ela_ok, ela_ok, licence_rt > mf_licence;
typedef microformat < rel_lightbox, c_lightbox, ela_no, ela_popup, lightbox_rt > mf_lightbox;
typedef microformat < rel_lightvideo, c_lightbox, ela_no, ela_popup, lightvideo_rt > mf_lightvideo;
typedef microformat < rel_logo, c_rejected, ela_ok, ela_ok, logo_rt > mf_logo;
typedef microformat < rel_longdesc, c_draft, ela_ok, ela_ok, longdesc_rt > mf_longdesc;
typedef microformat < rel_lrdd, c_generic, ela_ok, ela_ok, lrdd_rt > mf_lrdd;
typedef microformat < rel_m_pagescroll2id, c_generic, ela_ok, ela_ok, m_pagescroll2id_rt > mf_m_pagescroll2id;
typedef microformat < rel_made, c_generic, ela_ok, ela_ok, made_rt > mf_made;
typedef microformat < rel_manifest, c_generic, ela_external, ela_no, manifest_rt > mf_manifest;
typedef microformat < rel_map, c_draft, ela_ok, ela_ok, map_rt > mf_map;
typedef microformat < rel_maskicon, c_safari, ela_external, ela_no, maskicon_rt > mf_maskicon;
typedef microformat < rel_me, c_xfn | c_microformat, ela_ok, ela_ok, me_rt > mf_me;
typedef microformat < rel_member, c_draft, ela_ok, ela_ok, member_rt > mf_member;
typedef microformat < rel_memento, c_generic, ela_ok, ela_ok, memento_rt > mf_memento;
typedef microformat < rel_met, c_xfn, ela_no, ela_external, met_rt > mf_met;
typedef microformat < rel_meta, c_generic, ela_external, ela_no, meta_rt > mf_meta;
typedef microformat < rel_micropub, c_generic, ela_external, ela_no, micropub_rt > mf_micropub;
typedef microformat < rel_microsummary, c_generic, ela_ok, ela_ok, microsummary_rt > mf_microsummary;
typedef microformat < rel_monitor, c_generic, ela_ok, ela_ok, monitor_rt > mf_monitor;
typedef microformat < rel_monitor_group, c_generic, ela_ok, ela_ok, monitor_group_rt > mf_monitor_group;
typedef microformat < rel_muse, c_xfn, ela_no, ela_external, muse_rt > mf_muse;
typedef microformat < rel_navigate, c_html4 | c_dropped, ela_ok, ela_ok, navigate_rt > mf_navigate;
typedef microformat < rel_neighbour, c_xfn, ela_no, ela_external, neighbour_rt > mf_neighbour;
typedef microformat < rel_next, c_html4, ela_external, ela_external, next_rt > mf_next;
typedef microformat < rel_next_archive, c_generic, ela_ok, ela_ok, next_archive_rt > mf_next_archive;
typedef microformat < rel_nofollow, c_microformat, ela_no, ela_external, nofollow_rt > mf_nofollow;
typedef microformat < rel_noopener, c_generic, ela_no, c_annotation, noopener_rt > mf_noopener;
typedef microformat < rel_noreferrer, c_generic, ela_ok, ela_ok, noreferrer_rt > mf_noreferrer;
typedef microformat < rel_openid2_local_id, c_openid, ela_external, ela_no, openid2_local_id_rt > mf_openid2_local_id;
typedef microformat < rel_openid2_provider, c_openid, ela_external, ela_no, openid2_provider_rt > mf_openid2_provider;
typedef microformat < rel_openid_delegate, c_openid, ela_external, ela_no, openid_delegate_rt > mf_openid_delegate;
typedef microformat < rel_openid_server, c_openid, ela_external, ela_no, openid_server_rt > mf_openid_server;
typedef microformat < rel_origin, c_html4 | c_dropped, ela_ok, ela_ok, origin_rt > mf_origin;
typedef microformat < rel_original, c_generic, ela_ok, ela_ok, original_rt > mf_original;
typedef microformat < rel_p3pv1, c_generic, ela_external, ela_no, p3pv1_rt > mf_p3pv1;
typedef microformat < rel_parent, c_xfn | c_html4 | c_dropped, ela_external, ela_external, parent_rt > mf_parent;
typedef microformat < rel_pavatar, c_rejected, ela_ok, ela_ok, pavatar_rt > mf_pavatar;
typedef microformat < rel_payment, c_draft | c_microformat, ela_ok, ela_ok, payment_rt > mf_payment;
typedef microformat < rel_permalink, c_generic, ela_ok, ela_ok, permalink_rt > mf_permalink;
typedef microformat < rel_pgpkey, c_generic, ela_external, ela_no, pgpkey_rt > mf_pgpkey;
typedef microformat < rel_pingback, c_generic, ela_external, ela_no, pingback_rt > mf_pingback;
typedef microformat < rel_pointer, c_html4 | c_dropped, ela_ok, ela_ok, pointer_rt > mf_pointer;
typedef microformat < rel_popover, c_generic, ela_ok, ela_ok, popover_rt > mf_popover;
typedef microformat < rel_preconnect, c_generic, ela_external, ela_no, preconnect_rt > mf_preconnect;
typedef microformat < rel_predecessor_version, c_generic, ela_ok, ela_ok, predecessor_version_rt > mf_predecessor_version;
typedef microformat < rel_prefetch, c_draft, ela_ok, ela_ok, prefetch_rt > mf_prefetch;
typedef microformat < rel_preload, c_draft, ela_ok, ela_ok, preload_rt > mf_preload;
typedef microformat < rel_prerender, c_draft, ela_external, ela_external, prerender_rt > mf_prerender;
typedef microformat < rel_prev, c_html4, ela_external, ela_external, prev_rt > mf_prev;
typedef microformat < rel_prev_archive, c_generic, ela_ok, ela_ok, prev_archive_rt > mf_prev_archive;
typedef microformat < rel_preview, c_html4, ela_external, ela_external, preview_rt > mf_preview;
typedef microformat < rel_privacy, c_generic, ela_ok, ela_ok, privacy_rt > mf_privacy;
typedef microformat < rel_privacy_policy, c_generic, ela_ok, ela_ok, privacy_policy_rt > mf_privacy_policy;
typedef microformat < rel_profile, c_draft, ela_external, ela_external_contextual, profile_rt > mf_profile;
typedef microformat < rel_pronunciation, c_draft | c_microformat, ela_ok, ela_ok, pronunciation_rt > mf_pronunciation;
typedef microformat < rel_publickey, c_generic, ela_ok, ela_ok, publickey_rt > mf_publickey;
typedef microformat < rel_publisher, c_html4 | c_dropped, ela_external, ela_external, publisher_rt > mf_publisher;
typedef microformat < rel_radioepg, c_generic, ela_external, ela_external, radioepg_rt > mf_radioepg;
typedef microformat < rel_referral, c_generic, ela_ok, ela_ok, referral_rt > mf_referral;
typedef microformat < rel_related, c_atom, ela_ok, ela_ok, related_rt > mf_related;
typedef microformat < rel_rendition, c_generic, ela_external, ela_external, rendition_rt > mf_rendition;
typedef microformat < rel_replies, c_generic, ela_ok, ela_ok, replies_rt > mf_replies;
typedef microformat < rel_reply_to, c_generic, ela_external, ela_hyperlink, reply_to_rt > mf_reply_to;
typedef microformat < rel_resource, c_generic, ela_ok, ela_ok, resource_rt > mf_resource;
typedef microformat < rel_respond_proxy, c_generic, ela_ok, ela_ok, respond_proxy_rt > mf_respond_proxy;
typedef microformat < rel_respond_redirect, c_generic, ela_ok, ela_ok, respond_redirect_rt > mf_respond_redirect;
typedef microformat < rel_restconf, c_generic, ela_ok, ela_ok, restconf_rt > mf_restconf;
typedef microformat < rel_root, c_generic, ela_hyperlink, ela_hyperlink, root_rt > mf_root;
typedef microformat < rel_schema_dc, c_dcterms, ela_external, ela_no, schema_dc_rt > mf_schema_dc;
typedef microformat < rel_schema_dcterms, c_dcterms, ela_external, ela_no, schema_dcterms_rt > mf_schema_dcterms;
typedef microformat < rel_search, c_generic, ela_ok, ela_ok, search_rt > mf_search;
typedef microformat < rel_section, c_html4, ela_ok, ela_ok, section_rt > mf_section;
typedef microformat < rel_self, c_atom, ela_ok, ela_ok, self_rt > mf_self;
typedef microformat < rel_service, c_atom,  ela_external, ela_no, service_rt > mf_service;
typedef microformat < rel_service_desc, c_generic, ela_ok, ela_ok, service_desc_rt > mf_service_desc;
typedef microformat < rel_service_doc, c_generic, ela_ok, ela_ok, service_doc_rt > mf_service_doc;
typedef microformat < rel_service_meta, c_generic, ela_ok, ela_ok, service_meta_rt > mf_service_meta;
typedef microformat < rel_shortlink, c_draft,  ela_external, ela_no, shortlink_rt > mf_shortlink;
typedef microformat < rel_sibling, c_xfn | c_html4 | c_dropped, ela_no, ela_external, sibling_rt > mf_sibling;
typedef microformat < rel_sidebar, c_generic, ela_hyperlink, ela_hyperlink, sidebar_rt > mf_sidebar;
typedef microformat < rel_sitemap, c_generic, ela_external, ela_no, sitemap_rt > mf_sitemap;
typedef microformat < rel_source, c_draft, ela_ok, ela_ok, source_rt > mf_source;
typedef microformat < rel_sponsor, c_generic, ela_ok, ela_ok, sponsor_rt > mf_sponsor;
typedef microformat < rel_spouse, c_xfn, ela_no, ela_external, spouse_rt > mf_spouse;
typedef microformat < rel_start, c_html4, ela_ok, ela_ok, start_rt > mf_start;
typedef microformat < rel_status, c_draft, ela_ok, ela_ok, status_rt > mf_status;
typedef microformat < rel_stylesheet, c_html4, ela_external, ela_no, stylesheet_rt > mf_stylesheet;
typedef microformat < rel_stylesheetless, c_generic, ela_external, ela_no, stylesheetless_rt > mf_stylesheetless;
typedef microformat < rel_subresource, c_generic, ela_external, ela_no, subresource_rt > mf_subresource;
typedef microformat < rel_subsection, c_html4, ela_ok, ela_ok, subsection_rt > mf_subsection;
typedef microformat < rel_successor_version, c_generic, ela_ok, ela_ok, successor_version_rt > mf_successor_version;
typedef microformat < rel_sunset, c_generic, ela_ok, ela_ok, sunset_rt > mf_sunset;
typedef microformat < rel_supercedes, c_generic, ela_ok, ela_ok, supercedes_rt > mf_supercedes;
typedef microformat < rel_sweetheart, c_xfn, ela_no, ela_external, sweetheart_rt > mf_sweetheart;
typedef microformat < rel_sword, c_generic, ela_hyperlink, ela_no, sword_rt > mf_sword;
typedef microformat < rel_syndication, c_generic, ela_hyperlink, ela_hyperlink, syndication_rt > mf_syndication;
typedef microformat < rel_tag, c_microformat, ela_no, ela_ok, tag_rt > mf_tag;
typedef microformat < rel_terms_of_service, c_generic, ela_ok, ela_ok, terms_of_service_rt > mf_terms_of_service;
typedef microformat < rel_timegate, c_generic, ela_ok, ela_ok, timegate_rt > mf_timegate;
typedef microformat < rel_timemap, c_generic, ela_ok, ela_ok, timemap_rt > mf_timemap;
typedef microformat < rel_timesheet, c_generic, ela_external, ela_no, timesheet_rt > mf_timesheet;
typedef microformat < rel_toc, c_html4, ela_ok, ela_ok, toc_rt > mf_toc;
typedef microformat < rel_token_endpoint, c_generic, ela_external, ela_no, token_endpoint_rt > mf_token_endpoint;
typedef microformat < rel_tooltip, c_generic, ela_ok, ela_ok, tooltip_rt > mf_tooltip;
typedef microformat < rel_top, c_html4 | c_dropped, ela_ok, ela_ok, top_rt > mf_top;
typedef microformat < rel_trackback, c_generic, ela_ok, ela_ok, trackback_rt > mf_trackback;
typedef microformat < rel_trademark, c_html4 | c_dropped, ela_ok, ela_ok, trademark_rt > mf_trademark;
typedef microformat < rel_transformation, c_grddl, ela_ok, ela_ok, transformation_rt > mf_transformation;
typedef microformat < rel_translation, c_html4 | c_dropped, ela_ok, ela_ok, translation_rt > mf_translation;
typedef microformat < rel_type, c_generic, ela_ok, ela_ok, type_rt > mf_type;
typedef microformat < rel_unendorsed, c_generic, ela_ok, ela_ok, unendorsed_rt > mf_unendorsed;
typedef microformat < rel_up, c_html4 | c_dropped, ela_ok, ela_ok, up_rt > mf_up;
typedef microformat < rel_urc, c_html4 | c_dropped, ela_ok, ela_ok, urc_rt > mf_urc;
typedef microformat < rel_user, c_generic, ela_ok, ela_ok, user_rt > mf_user;
typedef microformat < rel_vcalendar_child, c_draft | c_hcal, ela_ok, ela_ok, vcalendar_child_rt > mf_vcalendar_child;
typedef microformat < rel_vcalendar_parent, c_draft | c_hcal, ela_ok, ela_ok, vcalendar_parent_rt > mf_vcalendar_parent;
typedef microformat < rel_vcalendar_sibling, c_draft | c_hcal, ela_ok, ela_ok, vcalendar_sibling_rt > mf_vcalendar_sibling;
typedef microformat < rel_vcs_git, c_vcs, ela_ok, ela_ok, vcs_git_rt > mf_vcs_git;
typedef microformat < rel_vcs_svn, c_vcs, ela_ok, ela_ok, vcs_svn_rt > mf_vcs_svn;
typedef microformat < rel_version_history, c_generic, ela_ok, ela_ok, version_history_rt > mf_version_history;
typedef microformat < rel_via, c_atom, ela_ok, ela_ok, via_rt > mf_via;
typedef microformat < rel_w_api_org, c_draft, ela_ok, ela_ok, w_api_org_rt > mf_w_api_org;
typedef microformat < rel_webmention, c_generic, ela_external, ela_hyperlink, webmention_rt > mf_webmention;
typedef microformat < rel_widget, c_generic, ela_external, ela_external, widget_rt > mf_widget;
typedef microformat < rel_wlwmanifest, c_generic, ela_external, ela_no, wlwmanifest_rt > mf_wlwmanifest;
typedef microformat < rel_working_copy, c_generic, ela_ok, ela_ok, working_copy_rt > mf_working_copy;
typedef microformat < rel_working_copy_of, c_generic, ela_ok, ela_ok, working_copy_of_rt > mf_working_copy_of;
typedef microformat < rel_yandex_tableau_widget, c_generic, ela_external, ela_no, yandex_tableau_widget_rt > mf_yandex_tableau_widget;
typedef microformat < v_error, c_rejected, ela_ok, ela_ok, name_at > mf_error;


typedef ::std::shared_ptr < mf_about > about_ptr;
typedef ::std::shared_ptr < mf_accessibility > accessibility_ptr;
typedef ::std::shared_ptr < mf_acquaintance > acquaintance_ptr;
typedef ::std::shared_ptr < mf_adr > adr_ptr;
typedef ::std::shared_ptr < mf_aggregate > aggregate_ptr;
typedef ::std::shared_ptr < mf_alternative > alternative_ptr;
typedef ::std::shared_ptr < mf_amphtml > amphtml_ptr;
typedef ::std::shared_ptr < mf_appendix > appendix_ptr;
typedef ::std::shared_ptr < mf_apple_touch_icon > apple_touch_icon_ptr;
typedef ::std::shared_ptr < mf_apple_touch_icon_precomposed > apple_touch_icon_precomposed_ptr;
typedef ::std::shared_ptr < mf_apple_touch_startup_image > apple_touch_startup_image_ptr;
typedef ::std::shared_ptr < mf_archived > archived_ptr;
typedef ::std::shared_ptr < mf_archives > archives_ptr;
typedef ::std::shared_ptr < mf_attachment > attachment_ptr;
typedef ::std::shared_ptr < mf_author > author_ptr;
typedef ::std::shared_ptr < mf_authorisation_endpoint > authorisation_endpoint_ptr;
typedef ::std::shared_ptr < mf_banner > banner_ptr;
typedef ::std::shared_ptr < mf_begin > begin_ptr;
typedef ::std::shared_ptr < mf_biblioentry > biblioentry_ptr;
typedef ::std::shared_ptr < mf_bibliography > bibliography_ptr;
typedef ::std::shared_ptr < mf_bibliography > bibliography_ptr;
typedef ::std::shared_ptr < mf_blocked_by > blocked_by_ptr;
typedef ::std::shared_ptr < mf_bookmark > bookmark_ptr;
typedef ::std::shared_ptr < mf_breadcrumb > breadcrumb_ptr;
typedef ::std::shared_ptr < mf_canonical > canonical_ptr;
typedef ::std::shared_ptr < mf_card > card_ptr;
typedef ::std::shared_ptr < mf_category > category_ptr;

typedef ::std::shared_ptr < mf_cc_permits > cc_permits_ptr;
typedef ::std::shared_ptr < mf_cc_requires > cc_requires_ptr;
typedef ::std::shared_ptr < mf_cc_prohibits > cc_prohibits_ptr;
typedef ::std::shared_ptr < mf_cc_jurisdiction > cc_jurisdiction_ptr;
typedef ::std::shared_ptr < mf_cc_legalcode > cc_legalcode_ptr;
typedef ::std::shared_ptr < mf_cc_deprecatedon > cc_deprecatedon_ptr;
typedef ::std::shared_ptr < mf_cc_licence > cc_licence_ptr;
typedef ::std::shared_ptr < mf_cc_morepermissions > cc_morepermissions_ptr;
// typedef ::std::shared_ptr < mf_cc_attributionname > cc_attributionname_ptr;
typedef ::std::shared_ptr < mf_cc_attributionurl > cc_attributionurl_ptr;
typedef ::std::shared_ptr < mf_cc_useguidelines > cc_useguidelines_ptr;

typedef ::std::shared_ptr < mf_chapter > chapter_ptr;
typedef ::std::shared_ptr < mf_child > child_ptr;
typedef ::std::shared_ptr < mf_chrome_webstore_item > chrome_webstore_item_ptr;
typedef ::std::shared_ptr < mf_citation > citation_ptr;
typedef ::std::shared_ptr < mf_cite_as > cite_as_ptr;
typedef ::std::shared_ptr < mf_code_licence > code_licence_ptr;
typedef ::std::shared_ptr < mf_code_repository > code_repository_ptr;
typedef ::std::shared_ptr < mf_colleague > colleague_ptr;
typedef ::std::shared_ptr < mf_collection > collection_ptr;
typedef ::std::shared_ptr < mf_comment > comment_ptr;
typedef ::std::shared_ptr < mf_component > component_ptr;
typedef ::std::shared_ptr < mf_contact > contact_ptr;
typedef ::std::shared_ptr < mf_content_licence > content_licence_ptr;
typedef ::std::shared_ptr < mf_content_repository > content_repository_ptr;
typedef ::std::shared_ptr < mf_contents > contents_ptr;
typedef ::std::shared_ptr < mf_contribution > contribution_ptr;
typedef ::std::shared_ptr < mf_convertedfrom > convertedfrom_ptr;
typedef ::std::shared_ptr < mf_copyright > copyright_ptr;
typedef ::std::shared_ptr < mf_coresident > coresident_ptr;
typedef ::std::shared_ptr < mf_coworker > coworker_ptr;
typedef ::std::shared_ptr < mf_create_form > create_form_ptr;
typedef ::std::shared_ptr < mf_crush > crush_ptr;
typedef ::std::shared_ptr < mf_current > current_ptr;
typedef ::std::shared_ptr < mf_date > date_ptr;
typedef ::std::shared_ptr < mf_dcterms_conformsto > dcterms_conformsto_ptr;
typedef ::std::shared_ptr < mf_dcterms_contributor > dcterms_contributor_ptr;
typedef ::std::shared_ptr < mf_dcterms_creator > dcterms_creator_ptr;
typedef ::std::shared_ptr < mf_dcterms_description > dcterms_description_ptr;
typedef ::std::shared_ptr < mf_dcterms_hasformat > dcterms_hasformat_ptr;
typedef ::std::shared_ptr < mf_dcterms_haspart > dcterms_haspart_ptr;
typedef ::std::shared_ptr < mf_dcterms_hasversion > dcterms_hasversion_ptr;
typedef ::std::shared_ptr < mf_dcterms_isformatof > dcterms_isformatof_ptr;
typedef ::std::shared_ptr < mf_dcterms_ispartof > dcterms_ispartof_ptr;
typedef ::std::shared_ptr < mf_dcterms_isreferencedby > dcterms_isreferencedby_ptr;
typedef ::std::shared_ptr < mf_dcterms_isreplacedby > dcterms_isreplacedby_ptr;
typedef ::std::shared_ptr < mf_dcterms_isrequiredby > dcterms_isrequiredby_ptr;
typedef ::std::shared_ptr < mf_dcterms_isversionof > dcterms_isversionof_ptr;
typedef ::std::shared_ptr < mf_dcterms_licence > dcterms_licence_ptr;
typedef ::std::shared_ptr < mf_dcterms_mediator > dcterms_mediator_ptr;
typedef ::std::shared_ptr < mf_dcterms_publisher > dcterms_publisher_ptr;
typedef ::std::shared_ptr < mf_dcterms_references > dcterms_references_ptr;
typedef ::std::shared_ptr < mf_dcterms_relation > dcterms_relation_ptr;
typedef ::std::shared_ptr < mf_dcterms_replaces > dcterms_replaces_ptr;
typedef ::std::shared_ptr < mf_dcterms_requires > dcterms_requires_ptr;
typedef ::std::shared_ptr < mf_dcterms_rightsholder > dcterms_rightsholder_ptr;
typedef ::std::shared_ptr < mf_dcterms_source > dcterms_source_ptr;
typedef ::std::shared_ptr < mf_dcterms_subject > dcterms_subject_ptr;
typedef ::std::shared_ptr < mf_definition > definition_ptr;
typedef ::std::shared_ptr < mf_describedby > describedby_ptr;
typedef ::std::shared_ptr < mf_describes > describes_ptr;
typedef ::std::shared_ptr < mf_directory > directory_ptr;
typedef ::std::shared_ptr < mf_disclaimer > disclaimer_ptr;
typedef ::std::shared_ptr < mf_disclosure > disclosure_ptr;
typedef ::std::shared_ptr < mf_discussion > discussion_ptr;
typedef ::std::shared_ptr < mf_dnsprefetch > dnsprefetch_ptr;
typedef ::std::shared_ptr < mf_docs_oasis_open_org_ns_cmis_link_200908_acl > docs_oasis_open_org_ns_cmis_link_200908_acl_ptr;
typedef ::std::shared_ptr < mf_duplicate > duplicate_ptr;
typedef ::std::shared_ptr < mf_edit > edit_ptr;
typedef ::std::shared_ptr < mf_edit_form > edit_form_ptr;
typedef ::std::shared_ptr < mf_edit_media > edit_media_ptr;
typedef ::std::shared_ptr < mf_editor > editor_ptr;
typedef ::std::shared_ptr < mf_edituri > edituri_ptr;
typedef ::std::shared_ptr < mf_enclosure > enclosure_ptr;
typedef ::std::shared_ptr < mf_end > end_ptr;
typedef ::std::shared_ptr < mf_endorsed > endorsed_ptr;
typedef ::std::shared_ptr < mf_entry > entry_ptr;
typedef ::std::shared_ptr < mf_entry_content > entry_content_ptr;
typedef ::std::shared_ptr < mf_event > event_ptr;
typedef ::std::shared_ptr < mf_external > external_ptr;
typedef ::std::shared_ptr < mf_fan > fan_ptr;
typedef ::std::shared_ptr < mf_feed > feed_ptr;
typedef ::std::shared_ptr < mf_first > first_ptr;
typedef ::std::shared_ptr < mf_footnote > footnote_ptr;
typedef ::std::shared_ptr < mf_friend > friend_ptr;
typedef ::std::shared_ptr < mf_gbfs > gbfs_ptr;
typedef ::std::shared_ptr < mf_gtfs_realtime > gtfs_realtime_ptr;
typedef ::std::shared_ptr < mf_gtfs_static > gtfs_static_ptr;
typedef ::std::shared_ptr < mf_geo > geo_ptr;
typedef ::std::shared_ptr < mf_glossary > glossary_ptr;
typedef ::std::shared_ptr < mf_group > group_ptr;
typedef ::std::shared_ptr < mf_hcite > hcite_ptr;
typedef ::std::shared_ptr < mf_help > help_ptr;
typedef ::std::shared_ptr < mf_home > home_ptr;
typedef ::std::shared_ptr < mf_hosts > hosts_ptr;
typedef ::std::shared_ptr < mf_hub > hub_ptr;
typedef ::std::shared_ptr < mf_icon > icon_ptr;
typedef ::std::shared_ptr < mf_image_src > image_src_ptr;
typedef ::std::shared_ptr < mf_import > import_ptr;
typedef ::std::shared_ptr < mf_in_reply_to > in_reply_to_ptr;
typedef ::std::shared_ptr < mf_index > index_ptr;
typedef ::std::shared_ptr < mf_intervalafter > intervalafter_ptr;
typedef ::std::shared_ptr < mf_intervalbefore > intervalbefore_ptr;
typedef ::std::shared_ptr < mf_intervalcontains > intervalcontains_ptr;
typedef ::std::shared_ptr < mf_intervaldisjoint > intervaldisjoint_ptr;
typedef ::std::shared_ptr < mf_intervalduring > intervalduring_ptr;
typedef ::std::shared_ptr < mf_intervalequals > intervalequals_ptr;
typedef ::std::shared_ptr < mf_intervalfinishedby > intervalfinishedby_ptr;
typedef ::std::shared_ptr < mf_intervalfinishes > intervalfinishes_ptr;
typedef ::std::shared_ptr < mf_intervalin > intervalin_ptr;
typedef ::std::shared_ptr < mf_intervalmeets > intervalmeets_ptr;
typedef ::std::shared_ptr < mf_intervalmetby > intervalmetby_ptr;
typedef ::std::shared_ptr < mf_intervaloverlappedby > intervaloverlappedby_ptr;
typedef ::std::shared_ptr < mf_intervaloverlaps > intervaloverlaps_ptr;
typedef ::std::shared_ptr < mf_intervalstartedby > intervalstartedby_ptr;
typedef ::std::shared_ptr < mf_intervalstarts > intervalstarts_ptr;
typedef ::std::shared_ptr < mf_issues > issues_ptr;
typedef ::std::shared_ptr < mf_item > item_ptr;
typedef ::std::shared_ptr < mf_its_rules > its_rules_ptr;
typedef ::std::shared_ptr < mf_jslicence > jslicence_ptr;
typedef ::std::shared_ptr < mf_kin > kin_ptr;
typedef ::std::shared_ptr < mf_kinetic_stylesheet > kinetic_stylesheet_ptr;
typedef ::std::shared_ptr < mf_last > last_ptr;
typedef ::std::shared_ptr < mf_latest_version > latest_version_ptr;
typedef ::std::shared_ptr < mf_licence > licence_ptr;
typedef ::std::shared_ptr < mf_lightbox > lightbox_ptr;
typedef ::std::shared_ptr < mf_lightvideo > lightvideo_ptr;
typedef ::std::shared_ptr < mf_listing > listing_ptr;
typedef ::std::shared_ptr < mf_logo > logo_ptr;
typedef ::std::shared_ptr < mf_longdesc > longdesc_ptr;
typedef ::std::shared_ptr < mf_lrdd > lrdd_ptr;
typedef ::std::shared_ptr < mf_m_pagescroll2id > m_pagescroll2id_ptr;
typedef ::std::shared_ptr < mf_made > made_ptr;
typedef ::std::shared_ptr < mf_manifest > manifest_ptr;
typedef ::std::shared_ptr < mf_map > map_ptr;
typedef ::std::shared_ptr < mf_maskicon > maskicon_ptr;
typedef ::std::shared_ptr < mf_me > me_ptr;
typedef ::std::shared_ptr < mf_member > member_ptr;
typedef ::std::shared_ptr < mf_memento > memento_ptr;
typedef ::std::shared_ptr < mf_met > met_ptr;
typedef ::std::shared_ptr < mf_meta > meta_ptr;
typedef ::std::shared_ptr < mf_micropub > micropub_ptr;
typedef ::std::shared_ptr < mf_microsummary > microsummary_ptr;
typedef ::std::shared_ptr < mf_monitor > monitor_ptr;
typedef ::std::shared_ptr < mf_monitor_group > monitor_group_ptr;
typedef ::std::shared_ptr < mf_muse > muse_ptr;
typedef ::std::shared_ptr < mf_navigate > navigate_ptr;
typedef ::std::shared_ptr < mf_neighbour > neighbour_ptr;
typedef ::std::shared_ptr < mf_next > next_ptr;
typedef ::std::shared_ptr < mf_next_archive > next_archive_ptr;
typedef ::std::shared_ptr < mf_nofollow > nofollow_ptr;
typedef ::std::shared_ptr < mf_noopener > noopener_ptr;
typedef ::std::shared_ptr < mf_noreferrer > noreferrer_ptr;
typedef ::std::shared_ptr < mf_openid2_local_id > openid2_local_id_ptr;
typedef ::std::shared_ptr < mf_openid2_provider > openid2_provider_ptr;
typedef ::std::shared_ptr < mf_openid_delegate > openid_delegate_ptr;
typedef ::std::shared_ptr < mf_openid_server > openid_server_ptr;
typedef ::std::shared_ptr < mf_origin > origin_ptr;
typedef ::std::shared_ptr < mf_original > original_ptr;
typedef ::std::shared_ptr < mf_p3pv1 > p3pv1_ptr;
typedef ::std::shared_ptr < mf_parent > parent_ptr;
typedef ::std::shared_ptr < mf_pavatar > pavatar_ptr;
typedef ::std::shared_ptr < mf_payment > payment_ptr;
typedef ::std::shared_ptr < mf_permalink > permalink_ptr;
typedef ::std::shared_ptr < mf_pgpkey > pgpkey_ptr;
typedef ::std::shared_ptr < mf_pingback > pingback_ptr;
typedef ::std::shared_ptr < mf_pointer > pointer_ptr;
typedef ::std::shared_ptr < mf_popover > popover_ptr;
typedef ::std::shared_ptr < mf_preconnect > preconnect_ptr;
typedef ::std::shared_ptr < mf_predecessor_version > predecessor_version_ptr;
typedef ::std::shared_ptr < mf_prefetch > prefetch_ptr;
typedef ::std::shared_ptr < mf_preload > preload_ptr;
typedef ::std::shared_ptr < mf_prerender > prerender_ptr;
typedef ::std::shared_ptr < mf_prev > prev_ptr;
typedef ::std::shared_ptr < mf_prev_archive > prev_archive_ptr;
typedef ::std::shared_ptr < mf_preview > preview_ptr;
typedef ::std::shared_ptr < mf_privacy > privacy_ptr;
typedef ::std::shared_ptr < mf_privacy_policy > privacy_policy_ptr;
typedef ::std::shared_ptr < mf_product > product_ptr;
typedef ::std::shared_ptr < mf_profile > profile_ptr;
typedef ::std::shared_ptr < mf_pronunciation > pronunciation_ptr;
typedef ::std::shared_ptr < mf_publickey > publickey_ptr;
typedef ::std::shared_ptr < mf_publisher > publisher_ptr;
typedef ::std::shared_ptr < mf_radioepg > radioepg_ptr;
typedef ::std::shared_ptr < mf_recipe > recipe_ptr;
typedef ::std::shared_ptr < mf_referral > referral_ptr;
typedef ::std::shared_ptr < mf_related > related_ptr;
typedef ::std::shared_ptr < mf_relcite > relcite_ptr;
typedef ::std::shared_ptr < mf_relfeed > relfeed_ptr;
typedef ::std::shared_ptr < mf_relitem > relitem_ptr;
typedef ::std::shared_ptr < mf_rendition > rendition_ptr;
typedef ::std::shared_ptr < mf_replies > replies_ptr;
typedef ::std::shared_ptr < mf_reply_to > reply_to_ptr;
typedef ::std::shared_ptr < mf_resource > resource_ptr;
typedef ::std::shared_ptr < mf_respond_proxy > respond_proxy_ptr;
typedef ::std::shared_ptr < mf_respond_redirect > respond_redirect_ptr;
typedef ::std::shared_ptr < mf_restconf > restconf_ptr;
typedef ::std::shared_ptr < mf_resume > resume_ptr;
typedef ::std::shared_ptr < mf_review > review_ptr;
typedef ::std::shared_ptr < mf_root > root_ptr;
typedef ::std::shared_ptr < mf_rtitem > rtitem_ptr;
typedef ::std::shared_ptr < mf_schema_dc > schema_dc_ptr;
typedef ::std::shared_ptr < mf_schema_dcterms > schema_dcterms_ptr;
typedef ::std::shared_ptr < mf_search > search_ptr;
typedef ::std::shared_ptr < mf_section > section_ptr;
typedef ::std::shared_ptr < mf_self > self_ptr;
typedef ::std::shared_ptr < mf_service > service_ptr;
typedef ::std::shared_ptr < mf_service_desc > service_desc_ptr;
typedef ::std::shared_ptr < mf_service_doc > service_doc_ptr;
typedef ::std::shared_ptr < mf_service_meta > service_meta_ptr;
typedef ::std::shared_ptr < mf_shortlink > shortlink_ptr;
typedef ::std::shared_ptr < mf_sibling > sibling_ptr;
typedef ::std::shared_ptr < mf_sidebar > sidebar_ptr;
typedef ::std::shared_ptr < mf_sitemap > sitemap_ptr;
typedef ::std::shared_ptr < mf_source > source_ptr;
typedef ::std::shared_ptr < mf_sponsor > sponsor_ptr;
typedef ::std::shared_ptr < mf_spouse > spouse_ptr;
typedef ::std::shared_ptr < mf_start > start_ptr;
typedef ::std::shared_ptr < mf_status > status_ptr;
typedef ::std::shared_ptr < mf_stylesheet > stylesheet_ptr;
typedef ::std::shared_ptr < mf_stylesheetless > stylesheetless_ptr;
typedef ::std::shared_ptr < mf_subresource > subresource_ptr;
typedef ::std::shared_ptr < mf_subsection > subsection_ptr;
typedef ::std::shared_ptr < mf_successor_version > successor_version_ptr;
typedef ::std::shared_ptr < mf_sunset > sunset_ptr;
typedef ::std::shared_ptr < mf_supercedes > supercedes_ptr;
typedef ::std::shared_ptr < mf_sweetheart > sweetheart_ptr;
typedef ::std::shared_ptr < mf_sword > sword_ptr;
typedef ::std::shared_ptr < mf_syndication > syndication_ptr;
typedef ::std::shared_ptr < mf_tag > tag_ptr;
typedef ::std::shared_ptr < mf_terms_of_service > terms_of_service_ptr;
typedef ::std::shared_ptr < mf_timegate > timegate_ptr;
typedef ::std::shared_ptr < mf_timemap > timemap_ptr;
typedef ::std::shared_ptr < mf_timesheet > timesheet_ptr;
typedef ::std::shared_ptr < mf_toc > toc_ptr;
typedef ::std::shared_ptr < mf_token_endpoint > token_endpoint_ptr;
typedef ::std::shared_ptr < mf_tooltip > tooltip_ptr;
typedef ::std::shared_ptr < mf_top > top_ptr;
typedef ::std::shared_ptr < mf_trackback > trackback_ptr;
typedef ::std::shared_ptr < mf_trademark > trademark_ptr;
typedef ::std::shared_ptr < mf_transformation > transformation_ptr;
typedef ::std::shared_ptr < mf_translation > translation_ptr;
typedef ::std::shared_ptr < mf_type > type_ptr;
typedef ::std::shared_ptr < mf_unendorsed > unendorsed_ptr;
typedef ::std::shared_ptr < mf_unknown > unknown_ptr;
typedef ::std::shared_ptr < mf_up > up_ptr;
typedef ::std::shared_ptr < mf_urc > urc_ptr;
typedef ::std::shared_ptr < mf_user > user_ptr;
typedef ::std::shared_ptr < mf_vcalendar_child > vcalendar_child_ptr;
typedef ::std::shared_ptr < mf_vcalendar_parent > vcalendar_parent_ptr;
typedef ::std::shared_ptr < mf_vcalendar_sibling > vcalendar_sibling_ptr;
typedef ::std::shared_ptr < mf_vcs_git > vcs_git_ptr;
typedef ::std::shared_ptr < mf_vcs_svn > vcs_svn_ptr;
typedef ::std::shared_ptr < mf_version_history > version_history_ptr;
typedef ::std::shared_ptr < mf_via > via_ptr;
typedef ::std::shared_ptr < mf_w_api_org > w_api_org_ptr;
typedef ::std::shared_ptr < mf_webmention > webmention_ptr;
typedef ::std::shared_ptr < mf_widget > widget_ptr;
typedef ::std::shared_ptr < mf_wlwmanifest > wlwmanifest_ptr;
typedef ::std::shared_ptr < mf_working_copy > working_copy_ptr;
typedef ::std::shared_ptr < mf_working_copy_of > working_copy_of_ptr;
typedef ::std::shared_ptr < mf_yandex_tableau_widget > yandex_tableau_widget_ptr;
typedef ::std::shared_ptr < mf_error > error_ptr;
