/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "property.h"
#include "reldef.h"

#define CSTR_dt_anniversary "dt-anniversary"
#define CSTR_dt_accessed "dt-accessed"
#define CSTR_dt_bday "dt-bday"
#define CSTR_dt_duration "dt-duration"
#define CSTR_dt_end "dt-end"
#define CSTR_dt_expired "dt-expired"
#define CSTR_dt_listed "dt-listed"
#define CSTR_dt_published "dt-published"
#define CSTR_dt_rev "dt-rev"
#define CSTR_dt_reviewed "dt-reviewed"
#define CSTR_dt_start "dt-start"
#define CSTR_dt_updated "dt-updated"
#define CSTR_e_content "e-content"
#define CSTR_e_description "e-description"
#define CSTR_e_instructions "e-instructions"
#define CSTR_p_action "p-action"
#define CSTR_p_additional_name "p-additional-name"
#define CSTR_p_adr "p-adr"
#define CSTR_p_affiliation "p-affiliation"
#define CSTR_p_altitude "p-altitude"
#define CSTR_p_attendee "p-attendee"
#define CSTR_p_author "p-author"
#define CSTR_p_average "p-average"
#define CSTR_p_best "p-best"
#define CSTR_p_brand "p-brand"
#define CSTR_p_category "p-category"
#define CSTR_p_comment "p-comment"
#define CSTR_p_contact "p-contact"
#define CSTR_p_content "p-content"
#define CSTR_p_count "p-count"
#define CSTR_p_country_name "p-country-name"
#define CSTR_p_description "p-description"
#define CSTR_p_education "p-education"
#define CSTR_p_entry "p-entry"
#define CSTR_p_experience "p-experience"
#define CSTR_p_extended_address "p-extended-address"
#define CSTR_p_family_name "p-family-name"
#define CSTR_p_gender_identity "p-gender-identity"
#define CSTR_p_geo "p-geo"
#define CSTR_p_given_name "p-given-name"
#define CSTR_p_honorific_prefix "p-honorific-prefix"
#define CSTR_p_honorific_suffix "p-honorific-suffix"
#define CSTR_p_ingredient "p-ingredient"
#define CSTR_p_item "p-item"
#define CSTR_p_job_title "p-job-title"
#define CSTR_p_label "p-label"
#define CSTR_p_latitude "p-latitude"
#define CSTR_p_lister "p-lister"
#define CSTR_p_locality "p-locality"
#define CSTR_p_location "p-location"
#define CSTR_p_longitude "p-longitude"
#define CSTR_p_name "p-name"
#define CSTR_p_nickname "p-nickname"
#define CSTR_p_note "p-note"
#define CSTR_p_nutrition "p-nutrition"
#define CSTR_p_org "p-org"
#define CSTR_p_organization_name "p-organization-name"
#define CSTR_p_organization_unit "p-organization-unit"
#define CSTR_p_organizer "p-organizer"
#define CSTR_p_post_office_box "p-post-office-box"
#define CSTR_p_postal_code "p-postal-code"
#define CSTR_p_price "p-price"
#define CSTR_p_publication "p-publication"
#define CSTR_p_rating "p-rating"
#define CSTR_p_region "p-region"
#define CSTR_p_review "p-review"
#define CSTR_p_reviewer "p-reviewer"
#define CSTR_p_role "p-role"
#define CSTR_p_rsvp "p-rsvp"
#define CSTR_p_sex "p-sex"
#define CSTR_p_skill "p-skill"
#define CSTR_p_sort_string "p-sort-string"
#define CSTR_p_street_address "p-street-address"
#define CSTR_p_summary "p-summary"
#define CSTR_p_tel "p-tel"
#define CSTR_p_tz "p-tz"
#define CSTR_p_votes "p-votes"
#define CSTR_p_worst "p-worst"
#define CSTR_p_yield "p-yield"
#define CSTR_u_audio "u-audio"
#define CSTR_u_bookmark_of "u-bookmark-of"
#define CSTR_u_email "u-email"
#define CSTR_u_featured "u-featured"
#define CSTR_u_geo "u-geo"
#define CSTR_u_identifier "u-identifier"
#define CSTR_u_impp "u-impp"
#define CSTR_u_in_reply_to "u-in-reply-to"
#define CSTR_u_key "u-key"
#define CSTR_u_like "u-like"
#define CSTR_u_like_of "u-like-of"
#define CSTR_u_logo "u-logo"
#define CSTR_u_photo "u-photo"
#define CSTR_u_repost "u-repost"
#define CSTR_u_repost_of "u-repost-of"
#define CSTR_u_sound "u-sound "
#define CSTR_u_syndication "u-syndication"
#define CSTR_u_uid "u-uid"
#define CSTR_u_url "u-url"
#define CSTR_u_video "u-video"
#define CSTR_u_dnsprefetch "u-dnsprefetch"
#define CSTR_u_external "u-external"
#define CSTR_u_icon "u-icon"
#define CSTR_u_noopener "u-noopener"
#define CSTR_u_noreferrer "u-noreferrer"
#define CSTR_u_preconnect "u-preconnect"
#define CSTR_u_prefetch "u-prefetch"
#define CSTR_u_preload "u-preload"
#define CSTR_u_prerender "u-prerender"
#define CSTR_u_search "u-search"

const int min_prop_length = 2;

struct symbol_entry < e_property > property_symbol_table [] =
{   {   CSTR_dt_anniversary, dt_anniversary },
    {   CSTR_dt_accessed, dt_accessed },
    {   CSTR_dt_bday, dt_bday },
    {   CSTR_dt_duration, dt_duration },
    {   CSTR_dt_end, dt_end },
    {   CSTR_dt_expired, dt_expired },
    {   CSTR_dt_listed, dt_listed },
    {   CSTR_dt_published, dt_published },
    {   CSTR_dt_rev, dt_rev },
    {   CSTR_dt_reviewed, dt_reviewed },
    {   CSTR_dt_start, dt_start },
    {   CSTR_dt_updated, dt_updated },
    {   CSTR_e_content, e_content },
    {   CSTR_e_description, e_description },
    {   CSTR_e_instructions, e_instructions },
    {   CSTR_p_action, p_action },
    {   CSTR_p_additional_name, p_additional_name },
    {   CSTR_p_adr, p_adr },
    {   CSTR_p_affiliation, p_affiliation },
    {   CSTR_p_altitude, p_altitude },
    {   CSTR_p_attendee, p_attendee },
    {   CSTR_p_author, p_author },
    {   CSTR_p_average, p_average },
    {   CSTR_p_best, p_best },
    {   CSTR_p_brand, p_brand },
    {   CSTR_p_category, p_category },
    {   CSTR_p_comment, p_comment },
    {   CSTR_p_contact, p_contact },
    {   CSTR_p_content, p_content },
    {   CSTR_p_count, p_count },
    {   CSTR_p_country_name, p_country_name },
    {   CSTR_p_description, p_description },
    {   CSTR_p_education, p_education },
    {   CSTR_p_entry, p_entry },
    {   CSTR_p_experience, p_experience },
    {   CSTR_p_extended_address, p_extended_address },
    {   CSTR_p_family_name, p_family_name },
    {   CSTR_p_gender_identity, p_gender_identity },
    {   CSTR_p_geo, p_geo },
    {   CSTR_p_given_name, p_given_name },
    {   CSTR_p_honorific_prefix, p_honorific_prefix },
    {   CSTR_p_honorific_suffix, p_honorific_suffix },
    {   CSTR_p_ingredient, p_ingredient },
    {   CSTR_p_item, p_item },
    {   CSTR_p_job_title, p_job_title },
    {   CSTR_p_label, p_label },
    {   CSTR_p_latitude, p_latitude },
    {   CSTR_p_lister, p_lister },
    {   CSTR_p_locality, p_locality },
    {   CSTR_p_location, p_location },
    {   CSTR_p_longitude, p_longitude },
    {   CSTR_p_name, p_name },
    {   CSTR_p_nickname, p_nickname },
    {   CSTR_p_note, p_note },
    {   CSTR_p_nutrition, p_nutrition },
    {   CSTR_p_org, p_org },
    {   CSTR_p_organization_name, p_organization_name },
    {   CSTR_p_organization_unit, p_organization_unit },
    {   CSTR_p_organizer, p_organizer },
    {   CSTR_p_post_office_box, p_post_office_box },
    {   CSTR_p_postal_code, p_postal_code },
    {   CSTR_p_price, p_price },
    {   CSTR_p_publication, p_publication },
    {   CSTR_p_rating, p_rating },
    {   CSTR_p_region, p_region },
    {   CSTR_p_review, p_review },
    {   CSTR_p_reviewer, p_reviewer },
    {   CSTR_p_role, p_role },
    {   CSTR_p_rsvp, p_rsvp },
    {   CSTR_p_sex, p_sex },
    {   CSTR_p_skill, p_skill },
    {   CSTR_p_sort_string, p_sort_string },
    {   CSTR_p_street_address, p_street_address },
    {   CSTR_p_summary, p_summary },
    {   CSTR_p_tel, p_tel },
    {   CSTR_p_tz, p_tz },
    {   CSTR_p_votes, p_votes },
    {   CSTR_p_worst, p_worst },
    {   CSTR_p_yield, p_yield },
    {   CSTR_u_audio, u_audio },
    {   CSTR_u_bookmark_of, u_bookmark_of },
    {   CSTR_u_email, u_email },
    {   CSTR_u_featured, u_featured },
    {   CSTR_u_geo, u_geo },
    {   CSTR_u_identifier, u_identifier },
    {   CSTR_u_impp, u_impp },
    {   CSTR_u_in_reply_to, u_in_reply_to },
    {   CSTR_u_key, u_key },
    {   CSTR_u_like, u_like },
    {   CSTR_u_like_of, u_like_of },
    {   CSTR_u_logo, u_logo },
    {   CSTR_u_photo, u_photo },
    {   CSTR_u_repost, u_repost },
    {   CSTR_u_repost_of, u_repost_of },
    {   CSTR_u_sound, u_sound },
    {   CSTR_u_syndication, u_syndication },
    {   CSTR_u_uid, u_uid },
    {   CSTR_u_url, u_url },
    {   CSTR_u_video, u_video },
    {   CSTR_u_dnsprefetch, u_dnsprefetch },
    {   CSTR_u_external, u_external },
    {   CSTR_u_icon, u_icon },
    {   CSTR_u_noopener, u_noopener },
    {   CSTR_u_noreferrer, u_noreferrer },
    {   CSTR_u_preconnect, u_preconnect },
    {   CSTR_u_prefetch, u_prefetch },
    {   CSTR_u_preload, u_preload },
    {   CSTR_u_prerender, u_prerender },
    {   CSTR_u_search, u_search },

    {   R_ABOUT, r_about },
    {   R_ACCESSIBILITY, r_accessibility },
    {   R_ACQUAINTANCE, r_acquaintance },
    {   R_ALTERNATIVE, r_alternative },
    {   R_AMPHTML, r_amphtml },
    {   R_APPENDIX, r_appendix },
    {   R_APPLE_TOUCH_ICON, r_apple_touch_icon },
    {   R_APPLE_TOUCH_ICON_PRECOMPOSED, r_apple_touch_icon_precomposed },
    {   R_APPLE_TOUCH_STARTUP_IMAGE, r_apple_touch_startup_image },
    {   R_ARCHIVED, r_archived },
    {   R_ARCHIVES, r_archives },
    {   R_ATTACHMENT, r_attachment },
    {   R_AUTHOR, r_author },
    {   R_AUTHORISATION_ENDPOINT, r_authorisation_endpoint },
    {   R_BANNER, r_banner },
    {   R_BEGIN, r_begin },
    {   R_BIBLIOENTRY, r_biblioentry },
    {   R_BIBLIOGRAPHY, r_bibliography },
    {   R_BLOCKED_BY, r_blocked_by },
    {   R_BOOKMARK, r_bookmark },
    {   R_CANONICAL, r_canonical },
    {   R_CATEGORY, r_category },
    {   R_CHAPTER, r_chapter },
    {   R_CHILD, r_child },
    {   R_CHROME_WEBSTORE_ITEM, r_chrome_webstore_item },
    {   R_CITATION, r_citation },
    {   R_CITE, r_cite },
    {   R_CITE_AS, r_cite_as },
    {   R_CMIS, r_docs_oasis_open_org_ns_cmis_link_200908_acl },
    {   R_CODE_LICENCE, r_code_licence },
    {   R_CODE_REPOSITORY, r_code_repository },
    {   R_COLLEAGUE, r_colleague },
    {   R_COLLECTION, r_collection },
    {   R_COMMENT, r_comment },
    {   R_COMPONENT, r_component },
    {   R_CONTACT, r_contact },
    {   R_CONTENTS, r_contents },
    {   R_CONTENT_LICENCE, r_content_licence },
    {   R_CONTENT_REPOSITORY, r_content_repository },
    {   R_CONTRIBUTION, r_contribution },
    {   R_CONVERTED_FROM, r_convertedfrom },
    {   R_COPYRIGHT, r_copyright },
    {   R_CORESIDENT, r_coresident },
    {   R_COWORKER, r_coworker },
    {   R_CREATE_FORM, r_create_form },
    {   R_CRUSH, r_crush },
    {   R_CURRENT, r_current },
    {   R_DATE, r_date },
    {   R_DCTERMS_CONFORMS_TO, r_dcterms_conformsto },
    {   R_DCTERMS_CONTRIBUTOR, r_dcterms_contributor },
    {   R_DCTERMS_CREATOR, r_dcterms_creator },
    {   R_DCTERMS_DESCRIPTION, r_dcterms_description },
    {   R_DCTERMS_HAS_FORMAT, r_dcterms_hasformat },
    {   R_DCTERMS_HAS_PART, r_dcterms_haspart },
    {   R_DCTERMS_HAS_VERSION, r_dcterms_hasversion },
    {   R_DCTERMS_IS_FORMAT_OF, r_dcterms_isformatof },
    {   R_DCTERMS_IS_PART_OF, r_dcterms_ispartof },
    {   R_DCTERMS_IS_REFERENCED_BY, r_dcterms_isreferencedby },
    {   R_DCTERMS_IS_REPLACED_BY, r_dcterms_isreplacedby },
    {   R_DCTERMS_IS_REQUIRED_BY, r_dcterms_isrequiredby },
    {   R_DCTERMS_IS_VERSION_OF, r_dcterms_isversionof },
    {   R_DCTERMS_LICENCE, r_dcterms_licence },
    {   R_DCTERMS_MEDIATOR, r_dcterms_mediator },
    {   R_DCTERMS_PUBLISHER, r_dcterms_publisher },
    {   R_DCTERMS_REFERENCES, r_dcterms_references },
    {   R_DCTERMS_RELATION, r_dcterms_relation },
    {   R_DCTERMS_REPLACES, r_dcterms_replaces },
    {   R_DCTERMS_REQUIRES, r_dcterms_requires },
    {   R_DCTERMS_RIGHTS_HOLDER, r_dcterms_rightsholder },
    {   R_DCTERMS_SOURCE, r_dcterms_source },
    {   R_DCTERMS_SUBJECT, r_dcterms_subject },
    {   R_DEFINITION, r_definition },
    {   R_DESCRIBED_BY, r_describedby },
    {   R_DESCRIBES, r_describes },
    {   R_DIRECTORY, r_directory },
    {   R_DISCLAIMER, r_disclaimer },
    {   R_DISCLOSURE, r_disclosure },
    {   R_DISCUSSION, r_discussion },
    {   R_DNSPREFETCH, r_dnsprefetch },
    {   R_DUPLICATE, r_duplicate },
    {   R_EDIT, r_edit },
    {   R_EDITOR, r_editor },
    {   R_EDIT_FORM, r_edit_form },
    {   R_EDIT_MEDIA, r_edit_media },
    {   R_EDIT_URI, r_edituri },
    {   R_ENCLOSURE, r_enclosure },
    {   R_END, r_end },
    {   R_ENDORSED, r_endorsed },
    {   R_ENTRY_CONTENT, r_entry_content },
    {   R_EXTERNAL, r_external },
    {   R_FAN, r_fan },
    {   R_FEED, r_feed },
    {   R_FIRST, r_first },
    {   R_FOOTNOTE, r_footnote },
    {   R_FRIEND, r_friend },
    {   R_GBFS, r_gbfs },
    {   R_GTFS_REALTIME, r_gtfs_realtime },
    {   R_GTFS_STATIC, r_gtfs_static },
    {   R_GLOSSARY, r_glossary },
    {   R_GROUP, r_group },
    {   R_HELP, r_help },
    {   R_HOME, r_home },
    {   R_HOSTS, r_hosts },
    {   R_HUB, r_hub },
    {   R_ICON, r_icon },
    {   R_IMAGE_SRC, r_image_src },
    {   R_IMPORT, r_import },
    {   R_INDEX, r_index },
    {   R_INTERVAL_AFTER, r_intervalafter },
    {   R_INTERVAL_BEFORE, r_intervalbefore },
    {   R_INTERVAL_CONTAINS, r_intervalcontains },
    {   R_INTERVAL_DISJOINT, r_intervaldisjoint },
    {   R_INTERVAL_DURING, r_intervalduring },
    {   R_INTERVAL_EQUALS, r_intervalequals },
    {   R_INTERVAL_FINISHED_BY, r_intervalfinishedby },
    {   R_INTERVAL_FINISHES, r_intervalfinishes },
    {   R_INTERVAL_IN, r_intervalin },
    {   R_INTERVAL_MEETS, r_intervalmeets },
    {   R_INTERVAL_MET_BY, r_intervalmetby },
    {   R_INTERVAL_OVERLAPPED_BY, r_intervaloverlappedby },
    {   R_INTERVAL_OVERLAPS, r_intervaloverlaps },
    {   R_INTERVAL_STARTED_BY, r_intervalstartedby },
    {   R_INTERVAL_STARTS, r_intervalstarts },
    {   R_IN_REPLY_TO, r_in_reply_to },
    {   R_ISSUES, r_issues },
    {   R_ITEM, r_item },
    {   R_ITSRULES, r_its_rules },
    {   R_JSLICENCE, r_jslicence },
    {   R_KIN, r_kin },
    {   R_KINETIC_STYLESHEET, r_kinetic_stylesheet },
    {   R_LAST, r_last },
    {   R_LATEST_VERSION, r_latest_version },
    {   R_LICENCE, r_licence },
    {   R_LIGHTBOX, r_lightbox },
    {   R_LIGHTVIDEO, r_lightvideo },
    {   R_LOGO, r_logo },
    {   R_LONGDESC, r_longdesc },
    {   R_LRDD, r_lrdd },
    {   R_MADE, r_made },
    {   R_MANIFEST, r_manifest },
    {   R_MAP, r_map },
    {   R_MASKICON, r_maskicon },
    {   R_ME, r_me },
    {   R_MEMBER, r_member },
    {   R_MEMENTO, r_memento },
    {   R_MET, r_met },
    {   R_META, r_meta },
    {   R_MICROPUB, r_micropub },
    {   R_MICROSUMMARY, r_microsummary },
    {   R_MONITOR, r_monitor },
    {   R_MONITOR_GROUP, r_monitor_group },
    {   R_MUSE, r_muse },
    {   R_M_PAGESCROLL2ID, r_m_pagescroll2id },
    {   R_NAVIGATE, r_navigate },
    {   R_NEIGHBOUR, r_neighbour },
    {   R_NEXT, r_next },
    {   R_NEXT_ARCHIVE, r_next_archive },
    {   R_NOFOLLOW, r_nofollow },
    {   R_NOOPENER, r_noopener },
    {   R_NOREFERRER, r_noreferrer },
    {   R_OPENID2_LOCAL_ID, r_openid2_local_id },
    {   R_OPENID2_PROVIDER, r_openid2_provider },
    {   R_OPENID_DELEGATE, r_openid_delegate },
    {   R_OPENID_SERVER, r_openid_server },
    {   R_ORIGIN, r_origin2 },
    {   R_ORIGINAL, r_original },
    {   R_P3PV1, r_p3pv1 },
    {   R_PARENT, r_parent },
    {   R_PAVATAR, r_pavatar },
    {   R_PAYMENT, r_payment },
    {   R_PERMALINK, r_permalink },
    {   R_PGPKEY, r_pgpkey },
    {   R_PINGBACK, r_pingback },
    {   R_POINTER, r_pointer },
    {   R_POPOVER, r_popover },
    {   R_PRECONNECT, r_preconnect },
    {   R_PREDECESSOR_VERSION, r_predecessor_version },
    {   R_PREFETCH, r_prefetch },
    {   R_PRELOAD, r_preload },
    {   R_PRERENDER, r_prerender },
    {   R_PREV, r_prev },
    {   R_PREVIEW, r_preview },
    {   R_PREVIOUS, r_prev },
    {   R_PREV_ARCHIVE, r_prev_archive },
    {   R_PRIVACY, r_privacy },
    {   R_PRIVACY_POLICY, r_privacy_policy },
    {   R_PROFILE, r_profile },
    {   R_PRONUNCIATION, r_pronunciation },
    {   R_PUBLICKEY, r_publickey },
    {   R_PUBLISHER, r_publisher },
    {   R_RADIOEPG, r_radioepg },
    {   R_REFERRAL, r_referral },
    {   R_RELATED, r_related },
    {   R_RENDITION, r_rendition },
    {   R_REPLIES, r_replies },
    {   R_REPLY_TO, r_reply_to },
    {   R_RESOURCE, r_resource },
    {   R_RESPOND_PROXY, r_respond_proxy },
    {   R_RESPOND_REDIRECT, r_respond_redirect },
    {   R_RESTCONF, r_restconf },
    {   R_ROOT, r_root },
    {   R_SCHEMA_DC, r_schema_dc },
    {   R_SCHEMA_DCTERMS, r_schema_dcterms },
    {   R_SEARCH, r_search },
    {   R_SECTION, r_section },
    {   R_SELF, r_self },
    {   R_SERVICE, r_service },
    {   R_SERVICE_DESC, r_service_desc },
    {   R_SERVICE_DOC, r_service_doc },
    {   R_SERVICE_META, r_service_meta },
    {   R_SHORTLINK, r_shortlink },
    {   R_SIBLING, r_sibling },
    {   R_SIDEBAR, r_sidebar },
    {   R_SITEMAP, r_sitemap },
    {   R_SOURCE, r_source },
    {   R_SPONSOR, r_sponsor },
    {   R_SPOUSE, r_spouse },
    {   R_START, r_start },
    {   R_STATUS, r_status },
    {   R_STYLESHEET, r_stylesheet },
    {   R_STYLESHEET_LESS, r_stylesheetless },
    {   R_SUBRESOURCE, r_subresource },
    {   R_SUBSECTION, r_subsection },
    {   R_SUCCESSOR_VERSION, r_successor_version },
    {   R_SUNSET, r_sunset },
    {   R_SUPERCEDES, r_supercedes },
    {   R_SWEETHEART, r_sweetheart },
    {   R_SWORD, r_sword },
    {   R_SYNDICATION, r_syndication },
    {   R_TAG, r_tag },
    {   R_TERMS_OF_SERVICE, r_terms_of_service },
    {   R_TIMEGATE, r_timegate },
    {   R_TIMEMAP, r_timemap },
    {   R_TIMESHEET, r_timesheet },
    {   R_TOC, r_toc },
    {   R_TOKEN_ENDPOINT, r_token_endpoint },
    {   R_TOOLTIP, r_tooltip },
    {   R_TOP, r_top },
    {   R_TRACKBACK, r_trackback },
    {   R_TRADEMARK, r_trademark },
    {   R_TRANSFORMATION, r_transformation },
    {   R_TRANSLATION, r_translation },
    {   R_TYPE, r_type },
    {   R_UNENDORSED, r_unendorsed },
    {   R_UP, r_up },
    {   R_URC, r_urc },
    {   R_USER, r_user },
    {   R_VCALENDAR_CHILD, r_vcalendar_child },
    {   R_VCALENDAR_PARENT, r_vcalendar_parent },
    {   R_VCALENDAR_SIBLING, r_vcalendar_sibling },
    {   R_VCS_GIT, r_vcs_git },
    {   R_VCS_SVN, r_vcs_svn },
    {   R_VERSION_HISTORY, r_version_history },
    {   R_VIA, r_via },
    {   R_WEBMENTION, r_webmention },
    {   R_WIDGET, r_widget },
    {   R_WLWMANIFEST, r_wlwmanifest },
    {   R_WORDPRESS_API, r_w_api_org },
    {   R_WORKING_COPY, r_working_copy },
    {   R_WORKING_COPY_OF, r_working_copy_of },
    {   R_YANDEX_TABLEAU_WIDGET, r_yandex_tableau_widget },
    {   R_CC_PERMITS, r_cc_permits },
    {   R_CC_REQUIRES, r_cc_requires },
    {   R_CC_PROHIBITS, r_cc_prohibits },
    {   R_CC_JURISDICTION, r_cc_jurisdiction },
    {   R_CC_LEGALCODE, r_cc_legalcode },
    {   R_CC_DEPRECATEDON, r_cc_deprecatedon },
    {   R_CC_LICENCE, r_cc_licence },
    {   R_CC_MOREPERMISSIONS, r_cc_morepermissions },
//    {   R_CC_ATTRIBUTIONNAME, r_cc_attributionname },
    {   R_CC_ATTRIBUTIONURL, r_cc_attributionurl },
    {   R_CC_USEGUIDELINES, r_cc_useguidelines } };

#define CSTR_p_addr "p-addr"
#define CSTR_p_organisation_name "p-organisation-name"
#define CSTR_p_organisation_unit "p-organisation-unit"
#define CSTR_p_organiser "p-organiser"

void prop::init ()
{   symbol::init (property_symbol_table, sizeof (property_symbol_table) / sizeof (struct symbol_entry < e_property >)); }

bool prop::parse (const ::std::string& x, e_property& res, ::std::string& diagnosis)
{   if (x.length () < min_prop_length) return false;
    ::std::string lc (::boost::algorithm::to_lower_copy (x));
    if (symbol::find (lc, res)) return true;
    if (context.tell (e_warning))
    {   if (lc == CSTR_p_addr) diagnosis = "addr abbreviated correctly";
        else if (lc == CSTR_p_organisation_name) diagnosis = "organisation spelt correctly";
        else if (lc == CSTR_p_organisation_unit) diagnosis = "organisation spelt correctly";
        else if (lc == CSTR_p_organiser) diagnosis = "organiser spelt correctly"; }
    return false; }
