/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "type_master.h"

template < e_type TYPE, typename base_type > class two_value : public type_base < TYPE >
{   bool true_ = false;
    static const char* v1_;
    static const char* v2_;
public:
    static void init (const char* sz1, const char* sz2)
    {   v1_ = sz1; v2_ = sz2; }
    ::std::string get_value () const
    {   if (! type_base < TYPE > :: unknown ()) if (true_) return v1_; else return v2_; return ::std::string (); }
    void set_value (const ::std::string& s);
    void swap (two_value& t) noexcept { ::std::swap (true_, t.true_); type_base < TYPE >::swap (t); }
    ::std::string diagnose () const; };

#define DECLARE_TWO_TYPE(TT, ENUM, V1, V2) \
typedef enum  { V1, V2 } ENUM; \
template < > struct type_master < TT > : public two_value < TT, ENUM > { }; \
template < > const char* two_value < TT, ENUM > :: v1_; \
template < > const char* two_value < TT, ENUM > :: v2_;

DECLARE_TWO_TYPE (t_capture, ev_capture, cv_user, cv_environment)
DECLARE_TWO_TYPE (t_cors, ev_cors, cc_anonymous, cc_credentials)
DECLARE_TWO_TYPE (t_truefalse, e_bool, b_true, b_false)
DECLARE_TWO_TYPE (t_wrap, e_wrap, w_soft, w_hard)
DECLARE_TWO_TYPE (t_yesno, e_yesno, y_yes, y_no)

template < e_type TYPE, typename base_type > void two_value < TYPE, base_type > :: set_value (const ::std::string& s)
{   ::std::string t (::boost::algorithm::to_lower_copy (trim_the_lot_off (s)));
    type_base < TYPE > :: status (s_good);
    if (t == v1_) true_ = true;
    else if (t == v2_) true_ = false;
    else type_base < TYPE > :: status (s_invalid); }

template < e_type TYPE, typename base_type > ::std::string two_value < TYPE, base_type > :: diagnose ()  const
{   if (! type_base < TYPE > :: invalid ()) return ::std::string ();
    if (! context.tell (e_error)) return ::std::string ();
    ::std::string s ("should be either ");
    s += v1_;
    s += " or ";
    s += v2_;
    return s; }
