/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "type_master.h"

template < e_type TYPE, typename base_type > class four_value : public type_base < TYPE >
{   base_type value_;
    static const char* v1_;
    static const char* v2_;
    static const char* v3_;
    static const char* v4_;
public:
    static void init (const char* sz1, const char* sz2, const char* sz3, const char* sz4)
    {   v1_ = sz1; v2_ = sz2; v3_ = sz3; v4_ = sz4; }
    ::std::string get_value () const;
    void set_value (const ::std::string& s);
    void swap (four_value& t) noexcept { ::std::swap (value_, t.value_); type_base < TYPE >::swap (t); }
    ::std::string diagnose () const; };

#define DECLARE_FOUR_TYPE(TT, ENUM, V1, V2, V3, V4) \
typedef enum  { V1, V2, V3, V4 } ENUM; \
template < > struct type_master < TT > : public four_value < TT, ENUM > { }; \
template < > const char* four_value < TT, ENUM > :: v1_; \
template < > const char* four_value < TT, ENUM > :: v2_; \
template < > const char* four_value < TT, ENUM > :: v3_; \
template < > const char* four_value < TT, ENUM > :: v4_;

DECLARE_FOUR_TYPE (t_autocapitalise, e_autocapitalise, ac_sentences, ac_words, ac_characters, ac_none)
DECLARE_FOUR_TYPE (t_rsvp, e_rsvp, rs_yes, rs_no, rs_maybe, rs_interested)
DECLARE_FOUR_TYPE (t_scope, e_scope, sc_row, sc_col, sc_rowgroup, sc_colgroup)
DECLARE_FOUR_TYPE (t_shape, e_shape, sh_circle, sh_default, sh_poly, sh_rect)

template < e_type TYPE, typename base_type > inline ::std::string four_value < TYPE, base_type > :: get_value () const
{   if (! type_base < TYPE > :: unknown ())
        if (value_ == static_cast <base_type> (0)) return v1_;
        else if (value_ == static_cast <base_type> (1)) return v2_;
        else if (value_ == static_cast <base_type> (2)) return v3_;
        else if (value_ == static_cast <base_type> (3)) return v4_;
    return ::std::string (); }

template < e_type TYPE, typename base_type > inline void four_value < TYPE, base_type > :: set_value (const ::std::string& s)
{   ::std::string t = (::boost::algorithm::to_lower_copy (trim_the_lot_off (s)));
    type_base < TYPE > :: status (s_good);
    if (t == v1_) value_ = static_cast <base_type> (0);
    else if (t == v2_) value_ = static_cast <base_type> (1);
    else if (t == v3_) value_ = static_cast <base_type> (2);
    else if (t == v4_) value_ = static_cast <base_type> (3);
    else type_base < TYPE > :: status (s_invalid); }

template < e_type TYPE, typename base_type > inline ::std::string four_value < TYPE, base_type > :: diagnose () const
{   if (! type_base < TYPE > :: invalid ()) return ::std::string ();
    if (! context.tell (e_error)) return ::std::string ();
    ::std::string s ("should be one of ");
    s += v1_;
    s += ", ";
    s += v2_;
    s += ", ";
    s += v3_;
    s += ", or ";
    s += v4_;
    return s; }
