/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "type_base.h"
#include "context.h"


template < e_type TYPE > struct string_value : public type_base < TYPE >
{   ::std::string value_;
    void swap (string_value < TYPE >& t) noexcept { value_.swap (t.value_); type_base < TYPE >::swap (t); }
    ::std::string get_value () const { return value_; }
    void set_value (const ::std::string& s)
    {   value_ = s;
        if (s.empty ()) type_base < TYPE > :: status (s_empty);
        else type_base < TYPE > :: status (s_good); }
    void reset () { value_.clear (); type_base < TYPE > :: reset (); } };

template < e_type TYPE, typename NUMERIC_TYPE > struct numeric_value : public type_base < TYPE >
{   NUMERIC_TYPE value_;
    void swap (numeric_value& t) noexcept { ::std::swap (value_, t.value_); type_base < TYPE >::swap (t); }
    void get_number (NUMERIC_TYPE& i) const { i = value_; }
    void set_number (const NUMERIC_TYPE& i) { value_ =  i; type_base < TYPE > :: status (s_good); }
    ::std::string get_value () const { return ::boost::lexical_cast < ::std::string > (value_); }
    void set_value (const ::std::string& s)
    {   bool b;
        value_ = lexical < NUMERIC_TYPE > :: cast2 (trim_the_lot_off (s), b);
        if (b) type_base < TYPE > :: status (s_good);
        else type_base < TYPE > :: status (s_invalid); }
    ::std::string diagnose () const
    {   if (! type_base < TYPE > :: invalid ()) return ::std::string ();
        if (! context.tell (e_error)) return ::std::string ();
        return "Value must be an integer"; } };
