/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "type_master.h"
#include "myhtml/api.h"

template < e_type TYPE > struct type_relational : public string_value < TYPE >
{   static bool is_relational () { return true; } };

template < > struct type_master < t_rel > : public type_relational < t_rel >
{   ::std::string diagnose () const
    {   if (! type_relational < t_rel > :: invalid ()) return ::std::string ();
        if (! context.tell (e_warning)) return ::std::string ();
        return "is an unrecognised rel / rev identifier (see http://microformats.org/wiki/existing-rel-values)."; } };

template < > struct type_master < t_rel_a > : public type_relational < t_rel_a >
{   void validate_element (const size_t e) const
    {   if ((e != MyHTML_TAG_A) && (e != MyHTML_TAG_AREA))
            string_value < t_rel_a > :: status (s_invalid); }
    ::std::string diagnose () const
    {   if (! type_relational < t_rel_a > :: invalid ()) return ::std::string ();
        if (! context.tell (e_error)) return ::std::string ();
        return "should only be used with A or AREA."; } };

template < > struct type_master < t_rel_avoid > : public type_relational < t_rel_avoid >
{   void set_value (const ::std::string& s)
    {   type_relational < t_rel_avoid > :: set_value (s);
        string_value < t_rel_avoid > :: status (s_invalid); }
    ::std::string diagnose () const
    {   if (! type_relational < t_rel_avoid > :: invalid ()) return ::std::string ();
        if (! context.tell (e_warning)) return ::std::string ();
        return "is not recommended (see http://microformats.org/wiki/existing-rel-values)."; } };

template < > struct type_master < t_rel_illegal > : public type_relational < t_rel_illegal >
{   void set_value (const ::std::string& s)
    {   type_relational < t_rel_illegal > :: set_value (s);
        string_value < t_rel_illegal > :: status (s_invalid); }
    ::std::string diagnose () const
    {   if (! type_relational < t_rel_illegal > :: invalid ()) return ::std::string ();
        if (! context.tell (e_warning)) return ::std::string ();
        return "has been rejected by the standards authorities. (see http://microformats.org/wiki/existing-rel-values)."; } };

template < > struct type_master < t_rel_link > : public type_relational < t_rel_link >
{   void validate_element (const size_t e) const
    {   if ((e != MyHTML_TAG_LINK))
            string_value < t_rel_link > :: status (s_invalid); }
    ::std::string diagnose () const
    {   if (! type_relational < t_rel_link > :: invalid ()) return ::std::string ();
        if (! context.tell (e_error)) return ::std::string ();
        return "should only be used with a LINK."; } };

template < > struct type_master < t_rel_obsolete > : public type_relational < t_rel_obsolete >
{   void set_value (const ::std::string& s)
    {   type_relational < t_rel_obsolete > :: set_value (s);
        string_value < t_rel_obsolete > :: status (s_invalid); } // in future, check against version of HTML rather than presume 5, etc..
    ::std::string diagnose () const
    {   if (! type_relational < t_rel_obsolete > :: invalid ()) return ::std::string ();
        if (! context.tell (e_warning)) return ::std::string ();
        return "is obsolete (see http://microformats.org/wiki/existing-rel-values)."; } };
