/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "url.h"
#include "context.h"
#include "url_protocol.h"
#include "url_sanitise.h"

void url::swap (url& u) noexcept
{   ::std::swap (valid_, u.valid_);
    ::std::swap (current_, u.current_);
    protocol_.swap (u.protocol_);
    params_.swap (u.params_); }

void url::parse (const ::std::string& url, const e_protocol current)
{   if (url.empty ())
        valid_ = false;
    else
    {   protocol pr;
        pr.set_component (es_original, url);
        if (pr.parse (decode (trim_the_lot_off (url)), current))
        {   if (has_component (es_query))
            {   parameters pa (pr.get_component (es_query));
                params_.swap (pa); } }
        protocol_.swap (pr);
        valid_ = protocol_.is_valid (); } }

vurl_t split_urls_by_space (const ::std::string& s)
{   vstr_t v (split_by_space (s));
    vurl_t res;
    for (auto z : v)
        res.push_back (url (z));
    return res; }
