/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once
#include "symbol.h"
#include "context.h"

typedef enum
{   v_unknown,
    h_adr, h_breadcrumb, h_card, h_cite, h_entry, h_event, h_feed, h_geo, h_item, h_listing, h_product, h_recipe, h_resume, h_review,
    h_aggregate, rel_acquaintance, rel_alternative, rel_appendix, rel_author, rel_bibliography, rel_bookmark, rel_canonical,
    rel_chapter, rel_child, rel_cite, rel_colleague, rel_code_licence, rel_content_licence, rel_contact, rel_contents,
    rel_copyright, rel_coresident, rel_coworker, rel_crush, rel_date, rel_directory, rel_discussion, rel_dnsprefetch,
    rel_enclosure, rel_external, rel_friend, rel_glossary, rel_group, rel_help, rel_home, rel_icon, rel_in_reply_to, rel_index, rel_issues, rel_its_rules,
    rel_kin, rel_licence, rel_map, rel_me, rel_member, rel_met, rel_micropub, rel_muse, rel_neighbour, rel_next, rel_nofollow,
    rel_noopener, rel_noreferrer, rel_parent, rel_payment, rel_pingback, rel_preconnect, rel_prefetch, rel_preload,
    rel_prerender, rel_prev, rel_preview, rel_pronunciation, rel_search, rel_section, rel_sibling, rel_sidebar, rel_spouse, rel_start, rel_stylesheet,
    rel_subsection, rel_supercedes, rel_sweetheart, rel_tag, rel_toc, rel_top, rel_transformation, rel_vcs_git, rel_vcs_svn, rel_webmention,

    rel_banner, rel_begin, rel_biblioentry, rel_citation, rel_definition, rel_disclaimer,
    rel_editor, rel_end, rel_navigate, rel_origin, rel_pointer, rel_trademark, rel_translation, rel_urc,

    rel_about, rel_archives, rel_blocked_by, rel_cite_as, rel_collection, rel_convertedfrom,
    rel_create_form, rel_current, rel_describedby, rel_describes, rel_duplicate, rel_edit, rel_edit_form,
    rel_edit_media, rel_first, rel_hosts, rel_hub, rel_intervalafter, rel_intervalbefore, rel_intervalcontains,
    rel_intervaldisjoint, rel_intervalduring, rel_intervalequals, rel_intervalfinishedby, rel_intervalfinishes,
    rel_intervalin, rel_intervalmeets, rel_intervalmetby, rel_intervaloverlappedby, rel_intervaloverlaps,
    rel_intervalstartedby, rel_intervalstarts, rel_item, rel_last, rel_latest_version, rel_lrdd, rel_memento,
    rel_monitor, rel_monitor_group, rel_next_archive, rel_original, rel_predecessor_version,
    rel_prev_archive, rel_privacy_policy, rel_profile, rel_related, rel_restconf, rel_replies, rel_self, rel_service,
    rel_service_desc, rel_service_doc, rel_service_meta, rel_status, rel_successor_version, rel_sunset,
    rel_terms_of_service, rel_timegate, rel_timemap, rel_type, rel_up, rel_version_history, rel_via, rel_working_copy,
    rel_working_copy_of,

    rel_amphtml, rel_apple_touch_icon, rel_apple_touch_icon_precomposed, rel_apple_touch_startup_image, rel_archived,
    rel_attachment, rel_authorisation_endpoint, rel_category, rel_code_repository, rel_component, rel_chrome_webstore_item,
    rel_content_repository, rel_dcterms_conformsto, rel_dcterms_contributor, rel_dcterms_creator, rel_dcterms_description,
    rel_dcterms_hasformat, rel_dcterms_haspart, rel_dcterms_hasversion, rel_dcterms_isformatof, rel_dcterms_ispartof,
    rel_dcterms_isreferencedby, rel_dcterms_isreplacedby, rel_dcterms_isrequiredby, rel_dcterms_isversionof, rel_dcterms_licence,
    rel_dcterms_mediator, rel_dcterms_publisher, rel_dcterms_references, rel_dcterms_relation, rel_dcterms_replaces,
    rel_dcterms_requires, rel_dcterms_rightsholder, rel_dcterms_source, rel_dcterms_subject, rel_disclosure,
    rel_edituri, rel_entry_content, rel_gbfs, rel_gtfs_static, rel_gtfs_realtime, rel_image_src, rel_import, rel_jslicence,
    rel_lightbox, rel_lightvideo, rel_manifest, rel_maskicon, rel_meta, rel_openid_delegate, rel_openid_server,
    rel_openid2_local_id, rel_openid2_provider, rel_p3pv1, rel_pgpkey, rel_publisher, rel_radioepg, rel_rendition,
    rel_root, rel_reply_to, rel_schema_dcterms, rel_shortlink, rel_sitemap, rel_subresource, rel_sword, rel_syndication,
    rel_timesheet, rel_token_endpoint, rel_widget, rel_wlwmanifest, rel_yandex_tableau_widget,
    rel_docs_oasis_open_org_ns_cmis_link_200908_acl,

    rel_accessibility, rel_longdesc, rel_m_pagescroll2id, rel_source, rel_vcalendar_parent, rel_vcalendar_child,
    rel_vcalendar_sibling, rel_w_api_org,

    rel_comment, rel_contribution, rel_endorsed, rel_fan, rel_feed, rel_footnote, rel_kinetic_stylesheet, rel_made,
    rel_microsummary, rel_permalink, rel_popover, rel_privacy, rel_publickey, rel_referral, rel_respond_proxy,
    rel_respond_redirect, rel_resource, rel_sponsor, rel_tooltip, rel_trackback, rel_unendorsed, rel_user,

    rel_schema_dc, rel_stylesheetless, rel_logo, rel_pavatar,

    rel_cc_permits, rel_cc_requires, rel_cc_prohibits, rel_cc_jurisdiction, rel_cc_legalcode, rel_cc_deprecatedon,
    rel_cc_licence, rel_cc_morepermissions, rel_cc_attributionname, rel_cc_attributionurl, rel_cc_useguidelines,

    v_error }
e_vocabulary;

constexpr e_vocabulary max_vocab = v_error;
constexpr e_vocabulary first_rel_vocab = rel_acquaintance;
constexpr size_t e_vocabulary_size = static_cast < size_t > (max_vocab) + 1;

// these MUST be in the same order as e_vocabulary. They're used in microformats.h.

#define MICROFORMATS \
    mf_unknown, \
    mf_adr, mf_breadcrumb, mf_card, mf_hcite, mf_entry, mf_event, mf_feed, mf_geo, mf_item, mf_listing, mf_product, mf_recipe, mf_resume, mf_review, \
    mf_aggregate, mf_acquaintance, mf_alternative, mf_appendix, mf_author, mf_bibliography, mf_bookmark, mf_canonical, \
    mf_chapter, mf_child, mf_relcite, mf_colleague, mf_code_licence, mf_content_licence, mf_contact, mf_contents, \
    mf_copyright, mf_coresident, mf_coworker, mf_crush, mf_date, mf_directory, mf_discussion, mf_dnsprefetch, \
    mf_enclosure, mf_external, mf_friend, mf_glossary, mf_group, mf_help, mf_home, mf_icon, mf_in_reply_to, mf_index, mf_issues, mf_its_rules, \
    mf_kin, mf_licence, mf_map, mf_me, mf_member, mf_met, mf_micropub, mf_muse, mf_neighbour, mf_next, mf_nofollow, \
    mf_noopener, mf_noreferrer, mf_parent, mf_payment, mf_pingback, mf_preconnect, mf_prefetch, mf_preload, \
    mf_prerender, mf_prev, mf_preview, mf_pronunciation, mf_search, mf_section, mf_sibling, mf_sidebar, mf_spouse, mf_start, mf_stylesheet, \
    mf_subsection, mf_supercedes, mf_sweetheart, mf_tag, mf_toc, mf_top, mf_transformation, mf_vcs_git, mf_vcs_svn, mf_webmention, \
    mf_banner, mf_begin, mf_biblioentry, mf_citation, mf_definition, mf_disclaimer, \
    mf_editor, mf_end, mf_navigate, mf_origin, mf_pointer, mf_trademark, mf_translation, mf_urc, \
    mf_about, mf_archives, mf_blocked_by, mf_cite_as, mf_collection, mf_convertedfrom, \
    mf_create_form, mf_current, mf_describedby, mf_describes, mf_duplicate, mf_edit, mf_edit_form, \
    mf_edit_media, mf_first, mf_hosts, mf_hub, mf_intervalafter, mf_intervalbefore, mf_intervalcontains, \
    mf_intervaldisjoint, mf_intervalduring, mf_intervalequals, mf_intervalfinishedby, mf_intervalfinishes, \
    mf_intervalin, mf_intervalmeets, mf_intervalmetby, mf_intervaloverlappedby, mf_intervaloverlaps, \
    mf_intervalstartedby, mf_intervalstarts, mf_relitem, mf_last, mf_latest_version, mf_lrdd, mf_memento, \
    mf_monitor, mf_monitor_group, mf_next_archive, mf_original, mf_predecessor_version, \
    mf_prev_archive, mf_privacy_policy, mf_profile, mf_related, mf_restconf, mf_replies, mf_self, mf_service, \
    mf_service_desc, mf_service_doc, mf_service_meta, mf_status, mf_successor_version, mf_sunset, \
    mf_terms_of_service, mf_timegate, mf_timemap, mf_type, mf_up, mf_version_history, mf_via, mf_working_copy, \
    mf_working_copy_of, \
    mf_amphtml, mf_apple_touch_icon, mf_apple_touch_icon_precomposed, mf_apple_touch_startup_image, mf_archived, \
    mf_attachment, mf_authorisation_endpoint, mf_category, mf_code_repository, mf_component, mf_chrome_webstore_item, \
    mf_content_repository, mf_dcterms_conformsto, mf_dcterms_contributor, mf_dcterms_creator, mf_dcterms_description, \
    mf_dcterms_hasformat, mf_dcterms_haspart, mf_dcterms_hasversion, mf_dcterms_isformatof, mf_dcterms_ispartof, \
    mf_dcterms_isreferencedby, mf_dcterms_isreplacedby, mf_dcterms_isrequiredby, mf_dcterms_isversionof, mf_dcterms_licence, \
    mf_dcterms_mediator, mf_dcterms_publisher, mf_dcterms_references, mf_dcterms_relation, mf_dcterms_replaces, \
    mf_dcterms_requires, mf_dcterms_rightsholder, mf_dcterms_source, mf_dcterms_subject, mf_disclosure, \
    mf_edituri, mf_entry_content, mf_gbfs, mf_gtfs_static, mf_gtfs_realtime, mf_image_src, mf_import, mf_jslicence, \
    mf_lightbox, mf_lightvideo, mf_manifest, mf_maskicon, mf_meta, mf_openid_delegate, mf_openid_server, \
    mf_openid2_local_id, mf_openid2_provider, mf_p3pv1, mf_pgpkey, mf_publisher, mf_radioepg, mf_rendition, \
    mf_root, mf_reply_to, mf_schema_dcterms, mf_shortlink, mf_sitemap, mf_subresource, mf_sword, mf_syndication, \
    mf_timesheet, mf_token_endpoint, mf_widget, mf_wlwmanifest, mf_yandex_tableau_widget, \
    mf_docs_oasis_open_org_ns_cmis_link_200908_acl, \
    mf_accessibility, mf_longdesc, mf_m_pagescroll2id, mf_source, mf_vcalendar_parent, mf_vcalendar_child, \
    mf_vcalendar_sibling, mf_w_api_org, \
    mf_comment, mf_contribution, mf_endorsed, mf_fan, mf_relfeed, mf_footnote, mf_kinetic_stylesheet, mf_made, \
    mf_microsummary, mf_permalink, mf_popover, mf_privacy, mf_publickey, mf_referral, mf_respond_proxy, \
    mf_respond_redirect, mf_resource, mf_sponsor, mf_tooltip, mf_trackback, mf_unendorsed, mf_user, \
    mf_schema_dc, mf_stylesheetless, mf_logo, mf_pavatar, \
    mf_cc_permits, mf_cc_requires, mf_cc_prohibits, mf_cc_jurisdiction, mf_cc_legalcode, mf_cc_deprecatedon, \
    mf_cc_licence, mf_cc_morepermissions, /* mf_cc_attributionname, */ mf_cc_attributionurl, mf_cc_useguidelines, \
    mf_error

#define MICROFORMAT_PTRS \
    unknown_ptr, \
    adr_ptr, breadcrumb_ptr, card_ptr, hcite_ptr, entry_ptr, event_ptr, feed_ptr, geo_ptr, item_ptr, listing_ptr, product_ptr, recipe_ptr, resume_ptr, review_ptr, \
    aggregate_ptr, acquaintance_ptr, alternative_ptr, appendix_ptr, author_ptr, bibliography_ptr, bookmark_ptr, canonical_ptr, \
    chapter_ptr, child_ptr, relcite_ptr, colleague_ptr, code_licence_ptr, content_licence_ptr, contact_ptr, contents_ptr, \
    copyright_ptr, coresident_ptr, coworker_ptr, crush_ptr, date_ptr, directory_ptr, discussion_ptr, dnsprefetch_ptr, \
    enclosure_ptr, external_ptr, friend_ptr, glossary_ptr, group_ptr, help_ptr, home_ptr, icon_ptr, in_reply_to_ptr, index_ptr, issues_ptr, its_rules_ptr, \
    kin_ptr, licence_ptr, map_ptr, me_ptr, member_ptr, met_ptr, micropub_ptr, muse_ptr, neighbour_ptr, next_ptr, nofollow_ptr, \
    noopener_ptr, noreferrer_ptr, parent_ptr, payment_ptr, pingback_ptr, preconnect_ptr, prefetch_ptr, preload_ptr, \
    prerender_ptr, prev_ptr, preview_ptr, pronunciation_ptr, search_ptr, section_ptr, sibling_ptr, sidebar_ptr, spouse_ptr, start_ptr, stylesheet_ptr, \
    subsection_ptr, supercedes_ptr, sweetheart_ptr, tag_ptr, toc_ptr, top_ptr, transformation_ptr, vcs_git_ptr, vcs_svn_ptr, webmention_ptr, \
    banner_ptr, begin_ptr, biblioentry_ptr, citation_ptr, definition_ptr, disclaimer_ptr, \
    editor_ptr, end_ptr, navigate_ptr, origin_ptr, pointer_ptr, trademark_ptr, translation_ptr, urc_ptr, \
    about_ptr, archives_ptr, blocked_by_ptr, cite_as_ptr, collection_ptr, convertedfrom_ptr, \
    create_form_ptr, current_ptr, describedby_ptr, describes_ptr, duplicate_ptr, edit_ptr, edit_form_ptr, \
    edit_media_ptr, first_ptr, hosts_ptr, hub_ptr, intervalafter_ptr, intervalbefore_ptr, intervalcontains_ptr, \
    intervaldisjoint_ptr, intervalduring_ptr, intervalequals_ptr, intervalfinishedby_ptr, intervalfinishes_ptr, \
    intervalin_ptr, intervalmeets_ptr, intervalmetby_ptr, intervaloverlappedby_ptr, intervaloverlaps_ptr, \
    intervalstartedby_ptr, intervalstarts_ptr, relitem_ptr, last_ptr, latest_version_ptr, lrdd_ptr, memento_ptr, \
    monitor_ptr, monitor_group_ptr, next_archive_ptr, original_ptr, predecessor_version_ptr, \
    prev_archive_ptr, privacy_policy_ptr, profile_ptr, related_ptr, restconf_ptr, replies_ptr, self_ptr, service_ptr, \
    service_desc_ptr, service_doc_ptr, service_meta_ptr, status_ptr, successor_version_ptr, sunset_ptr, \
    terms_of_service_ptr, timegate_ptr, timemap_ptr, type_ptr, up_ptr, version_history_ptr, via_ptr, working_copy_ptr, \
    working_copy_of_ptr, \
    amphtml_ptr, apple_touch_icon_ptr, apple_touch_icon_precomposed_ptr, apple_touch_startup_image_ptr, archived_ptr, \
    attachment_ptr, authorisation_endpoint_ptr, category_ptr, code_repository_ptr, component_ptr, chrome_webstore_item_ptr, \
    content_repository_ptr, dcterms_conformsto_ptr, dcterms_contributor_ptr, dcterms_creator_ptr, dcterms_description_ptr, \
    dcterms_hasformat_ptr, dcterms_haspart_ptr, dcterms_hasversion_ptr, dcterms_isformatof_ptr, dcterms_ispartof_ptr, \
    dcterms_isreferencedby_ptr, dcterms_isreplacedby_ptr, dcterms_isrequiredby_ptr, dcterms_isversionof_ptr, dcterms_licence_ptr, \
    dcterms_mediator_ptr, dcterms_publisher_ptr, dcterms_references_ptr, dcterms_relation_ptr, dcterms_replaces_ptr, \
    dcterms_requires_ptr, dcterms_rightsholder_ptr, dcterms_source_ptr, dcterms_subject_ptr, disclosure_ptr, \
    edituri_ptr, entry_content_ptr, gbfs_ptr, gtfs_static_ptr, gtfs_realtime_ptr, image_src_ptr, import_ptr, jslicence_ptr, \
    lightbox_ptr, lightvideo_ptr, manifest_ptr, maskicon_ptr, meta_ptr, openid_delegate_ptr, openid_server_ptr, \
    openid2_local_id_ptr, openid2_provider_ptr, p3pv1_ptr, pgpkey_ptr, publisher_ptr, radioepg_ptr, rendition_ptr, \
    root_ptr, reply_to_ptr, schema_dcterms_ptr, shortlink_ptr, sitemap_ptr, subresource_ptr, sword_ptr, syndication_ptr, \
    timesheet_ptr, token_endpoint_ptr, widget_ptr, wlwmanifest_ptr, yandex_tableau_widget_ptr, \
    docs_oasis_open_org_ns_cmis_link_200908_acl_ptr, \
    accessibility_ptr, longdesc_ptr, m_pagescroll2id_ptr, source_ptr, vcalendar_parent_ptr, vcalendar_child_ptr, \
    vcalendar_sibling_ptr, w_api_org_ptr, \
    comment_ptr, contribution_ptr, endorsed_ptr, fan_ptr, relfeed_ptr, footnote_ptr, kinetic_stylesheet_ptr, made_ptr, \
    microsummary_ptr, permalink_ptr, popover_ptr, privacy_ptr, publickey_ptr, referral_ptr, respond_proxy_ptr, \
    respond_redirect_ptr, resource_ptr, sponsor_ptr, tooltip_ptr, trackback_ptr, unendorsed_ptr, user_ptr, \
    schema_dc_ptr, stylesheetless_ptr, logo_ptr, pavatar_ptr, \
    cc_permits_ptr, cc_requires_ptr, cc_prohibits_ptr, cc_jurisdiction_ptr, cc_legalcode_ptr, cc_deprecatedon_ptr, \
    cc_licence_ptr, cc_morepermissions_ptr, /* cc_attributionname_ptr, */ cc_attributionurl_ptr, cc_useguidelines_ptr, \
    mf_error


class vocab : public symbol < e_vocabulary >
{   ::std::string diagnosis_;
public:
    vocab () = default;
    vocab (const vocab& s) = default;
    vocab (vocab&&) = default;
    explicit vocab (const ::std::string& x) { set (parse (x, diagnosis_)); }
    vocab& operator = (const vocab&) = default;
    vocab& operator = (vocab&&) = default;
    static e_vocabulary parse (const ::std::string& x, ::std::string& diagnosis);
    static void init ();
    void swap (vocab& v) noexcept
    {   diagnosis_.swap (v.diagnosis_);
        symbol < e_vocabulary > :: swap (v); }
    bool unknown () const
    {   return (symbol < e_vocabulary > :: unknown ()) || (symbol < e_vocabulary > :: get () == v_unknown); }
    bool error () const
    {   return (! unknown () && (symbol < e_vocabulary > :: get () == v_error)); }
    bool is_rel () const
    {   return (! unknown () && ! error () && (symbol < e_vocabulary > :: get () >= first_rel_vocab)); }
    ::std::string diagnosis () const { return diagnosis_; }
    bool whoopsie () const { return ! diagnosis_.empty (); } };

bool verify_rel (const ::std::string& s, ::std::string& diagnosis);
