/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "context.h"
#include "attr.h"
#include "quote.h"
#include "type.h"

struct symbol_entry < e_attribute > attribute_symbol_table [] =
{   { { HTML_4_0 }, { HTML_UNDEF }, "abbr", a_abbr },
    { { XHTML_1_1, 0, HE_RDF_1_0 | HE_SVG_1_2 | HE_SVG_X2 }, { HTML_UNDEF }, "about", a_about },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "above", a_above },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "accent-height", a_accentheight },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "accentunder", a_accentunder },
    { { HTML_2_0 }, { HTML_UNDEF }, "accept", a_accept },
    { { HTML_5_0 }, { HTML_UNDEF }, "accept-charset", a_acceptcharset },
    { { HTML_4_0 }, { HTML_UNDEF }, "accesskey", a_accesskey },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "accumulate", a_accumulate },
    { { HTML_PLUS }, { HTML_UNDEF }, "action", a_action },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "actiontype", a_actiontype },
    { { XHTML_2_0 }, { XHTML_2_0 }, "activate", a_activate },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "actuate", a_actuate },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "additive", a_additive },
    { { HTML_1_0, HV_DEPRECATED4 }, { HTML_UNDEF }, "align", a_align },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "alignment-baseline", a_alignmentbaseline },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "alignmentscope", a_alignmentscope },
    { { HTML_3_2 }, { HTML_UNDEF }, "alink", a_alink },
    { { HTML_JUL20, 0, HE_EXPERIMENTAL }, { HTML_UNDEF }, "allow", a_allow },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "allow-zoom-and-pan", a_allow_zoom_pan },
    { { HTML_5_1 }, { HTML_UNDEF }, "allowfullscreen", a_allowfullscreen },
    { { HTML_5_2 }, { HTML_UNDEF }, "allowpaymentrequest", a_allowpaymentrequest },
    { { HTML_5_3 }, { HTML_UNDEF }, "allowusermedia", a_allowusermedia },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "alphabetic", a_alphabetic },
    { { HTML_1_0 }, { HTML_UNDEF }, "alt", a_alt },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "altimg", a_altimg },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "alttext", a_alttext },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "amplitude", a_amplitude },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "arabic-form", a_arabicform },
    { { HTML_4_0 }, { HTML_UNDEF }, "archive", a_archive },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-activedescendant", a_ariaactivedescendant },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-atomic", a_ariaatomic },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-autocomplete", a_ariaautocomplete },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-busy", a_ariabusy },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-checked", a_ariachecked },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-controls", a_ariacontrols },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-describedby", a_ariadescribedby },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-disabled", a_ariadisabled },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-dropeffect", a_ariadropeffect },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-expanded", a_ariaexpanded },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-flowto", a_ariaflowto },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-grabbed", a_ariagrabbed },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-haspopup", a_ariahaspopup },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-hidden", a_ariahidden },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-invalid", a_ariainvalid },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-label", a_arialabel },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-labelledby", a_arialabelledby },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-level", a_arialevel },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-live", a_arialive },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-multiline", a_ariamultiline },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-multiselectable", a_ariamultiselectable },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-orientation", a_ariaorientation },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-owns", a_ariaowns },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-posinset", a_ariaposinset },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-pressed", a_ariapressed },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-readonly", a_ariareadonly },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-relevant", a_ariarelevant },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-required", a_ariarequired },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-selected", a_ariaselected },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-setsize", a_ariasetsize },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-valuemax", a_ariavaluemax },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-valuemin", a_ariavaluemin },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-valuenow", a_ariavaluenow },
    { { HTML_4_01, HV_ARIA, HE_SVG_2_0 }, { HTML_UNDEF }, "aria-valuetext", a_ariavaluetext },
    { { HTML_5_0, 0, HE_MOZILLA }, { HTML_UNDEF }, "as", a_as },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "ascent", a_ascent },
    { { HTML_5_0 }, { HTML_UNDEF }, "async", a_async },
    { { HTML_PLUS }, { HTML_PLUS }, "at", a_at },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "attributename", a_attributename },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "attributetype", a_attributetype },
    { { HTML_5_3 }, { HTML_UNDEF }, "autocapitalize", a_autocapitalise },
    { { HTML_5_0 }, { HTML_UNDEF }, "autocomplete", a_autocomplete },
    { { HTML_5_0, 0, HE_SAFARI }, { HTML_UNDEF }, "autocorrect", a_autocorrect },
    { { HTML_5_0 }, { HTML_UNDEF }, "autofocus", a_autofocus },
    { { HTML_5_0, 0, HE_EXPERIMENTAL }, { HTML_UNDEF }, "autopictureinpicture", a_autopictureinpicture },
    { { HTML_5_0 }, { HTML_UNDEF }, "autoplay", a_autoplay },
    { { HTML_2_0, HV_RFC_1942 }, { HTML_3_0 }, "axes", a_axes },
    { { HTML_2_0, HV_RFC_1942 }, { HTML_UNDEF }, "axis", a_axis },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "azimuth", a_azimuth },
    { { HTML_2_0 }, { HTML_UNDEF }, "background", a_background },
    { { HTML_2_0, 0, HE_IE }, { HTML_UNDEF }, "balance", a_balance },
    { { XHTML_1_0, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "bandwidth", a_bandwidth },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "base", a_base },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "base-frequency", a_basefrequency },
    { { HTML_4_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "basefrequency", a_basefrequency },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "baseline", a_baseline },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "baseline-shift", a_baselineshift },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "baseprofile", a_baseprofile },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "bbox", a_bbox },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "begin", a_begin },
    { { HTML_3_2 }, { HTML_UNDEF }, "behavior", a_behaviour },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "below", a_below },
    { { HTML_3_2, HV_DEPRECATED4 }, { HTML_UNDEF }, "bgcolor", a_bgcolour },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "bias", a_bias },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "border", a_border },
    { { HTML_3_2, HV_DEPRECATED4, HE_CHROME }, { HTML_4_01 }, "bottommargin", a_bottommargin },
    { { HTML_3_0 }, { HTML_3_0 }, "box", a_box },
    { { XHTML_2_0 }, { XHTML_2_0 }, "bubbles", a_bubbles },
    { { HTML_5_0, 0, HE_MOZILLA | HE_OPERA }, { HTML_UNDEF }, "buffered", a_buffered },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "by", a_by },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "calcmode", a_calcmode },
    { { XHTML_2_0 }, { XHTML_2_0 }, "cancelable", a_cancelable },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "cap-height", a_capheight },
    { { HTML_UNDEF }, { HTML_UNDEF }, "capture", a_capture },
    { { HTML_5_2, HV_W3 }, { HTML_UNDEF }, "cell", a_cell },
    { { HTML_2_0, HV_RFC_1942 }, { HTML_UNDEF }, "cellpadding", a_cellpadding },
    { { HTML_2_0, HV_RFC_1942 }, { HTML_UNDEF }, "cellspacing", a_cellspacing },
    { { HTML_5_0 }, { HTML_UNDEF }, "challenge", a_challenge },
    { { HTML_2_0 }, { HTML_UNDEF }, "char", a_char },
    { { HTML_2_0 }, { HTML_UNDEF }, "charoff", a_charoff },
    { { HTML_2_0, HV_RFC_2070 }, { HTML_UNDEF }, "charset", a_charset },
    { { HTML_PLUS }, { HTML_UNDEF }, "checked", a_checked },
    { { HTML_4_0 }, { HTML_UNDEF }, "cite", a_cite },
    { { HTML_2_0, HV_RFC_2070 | HV_RFC_1942 }, { HTML_UNDEF }, "class", a_class },
    { { HTML_4_0 }, { HTML_UNDEF }, "classid", a_classid },
    { { HTML_2_0, HV_RFC_1942 }, { HTML_UNDEF }, "clear", a_clear },
    { { HTML_2_0, HV_NOT4 | HV_NOTX1, HE_NETSCAPE | HE_SVG_1x2 }, { HTML_UNDEF }, "clip", a_clip },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "clip-path", a_clip_path },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "clip-rule", a_clip_rule },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "clippathunits", a_clippathunits },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "close", a_close },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "closure", a_closure },
    { { HTML_3_2 }, { HTML_UNDEF }, "code", a_code },
    { { HTML_3_2 }, { HTML_UNDEF }, "codebase", a_codebase },
    { { HTML_4_0 }, { HTML_UNDEF }, "codetype", a_codetype },
    { { HTML_3_0 }, { HTML_3_0 }, "coldef", a_coldef },
    { { HTML_3_2 }, { HTML_UNDEF }, "color", a_colour },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "color-interpolation", a_colour_interpolation },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "color-interpolation-filters", a_colour_interpolation_filters },
    { { XHTML_2_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "color-profile", a_colour_profile },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "color-rendering", a_colour_rendering },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "cols", a_cols },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "colspan", a_colspan },
    { { HTML_3_0 }, { HTML_3_0 }, "colspec", a_colspec },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "columnalign", a_columnalign },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "columnlines", a_columnlines },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "columnspacing", a_columnspacing },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "columnspan", a_columnspan },
    { { HTML_PLUS }, { HTML_UNDEF }, "compact", a_compact },
    { { HTML_2_0 }, { HTML_UNDEF }, "content", a_content },
    { { HTML_5_0 }, { HTML_UNDEF }, "contenteditable", a_contenteditable },
    { { XHTML_2_0 }, { XHTML_2_0 }, "contentlength", a_contentlength },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "contentscripttype", a_contentscripttype },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "contentstyletype", a_contentstyletype },
    { { HTML_5_1 }, { HTML_UNDEF }, "contextmenu", a_contextmenu },
    { { HTML_3_0 }, { HTML_3_0 }, "continue", a_continue },
    { { HTML_5_0 }, { HTML_UNDEF }, "controls", a_controls },
    { { HTML_5_0, 0, HE_EXPERIMENTAL }, { HTML_UNDEF }, "controlslist", a_controlslist },
    { { HTML_2_0, HV_RFC_1980 }, { HTML_UNDEF }, "coords", a_coords },
    { { XHTML_1_0, 0, HE_SVG_2_0 }, { HTML_UNDEF }, "crossorigin", a_crossorigin },
    { { HTML_JUL20, 0, HE_EXPERIMENTAL }, { HTML_UNDEF }, "csp", a_csp },
    { { HTML_5_0, 0, HE_BESPOKE }, { HTML_UNDEF }, "currenttime", a_currenttime },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "cursor", a_cursor },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "cx", a_cx },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "cy", a_cy },
    { { HTML_4_0, 0, HE_SVG_1 }, { HTML_UNDEF }, "d", a_d },
    { { HTML_4_0 }, { HTML_UNDEF }, "data", a_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "datafld", a_datafld },
    { { HTML_4_0 }, { HTML_UNDEF }, "dataformatas", a_dataformatas },
    { { HTML_4_0 }, { HTML_UNDEF }, "datasrc", a_datasrc },
    { { XHTML_1_1, 0, HE_RDF_1_0 | HE_SVG_1_2 | HE_SVG_X2 }, { HTML_UNDEF }, "datatype", a_datatype },
    { { HTML_5_0 }, { HTML_UNDEF }, "data-", a_datawild },
    { { HTML_4_0 }, { HTML_UNDEF }, "datetime", a_datetime },
    { { HTML_4_0 }, { HTML_UNDEF }, "declare", a_declare },
    { { HTML_5_3 }, { HTML_UNDEF }, "decoding", a_decoding },
    { { HTML_5_0 }, { HTML_UNDEF }, "default", a_default },
    { { XHTML_2_0, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "defaultaction", a_defaultaction },
    { { HTML_4_0 }, { HTML_UNDEF }, "defer", a_defer },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "definition", a_definition },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "depth", a_depth },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "descent", a_descent },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "diffuse-constant", a_diffuseconstant },
    { { HTML_4_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "diffuseconstant", a_diffuseconstant },
    { { HTML_3_0 }, { HTML_3_0 }, "dingbat", a_dingbat },
    { { HTML_2_0, HV_RFC_2070 | HV_RFC_1942 }, { HTML_UNDEF }, "dir", a_dir },
    { { HTML_2_0, HV_NOTX1, HE_IE | HE_SVG_1x2 }, { HTML_UNDEF }, "direction", a_direction },
    { { HTML_5_0 }, { HTML_UNDEF }, "dirname", a_dirname },
    { { HTML_PLUS }, { HTML_UNDEF }, "disabled", a_disabled },
    { { HTML_5_0, 0, HE_EXPERIMENTAL }, { HTML_UNDEF }, "disablepictureinpicture", a_disablepictureinpicture },
    { { HTML_5_3 }, { HTML_UNDEF }, "disableremoteplayback", a_disableremoteplayback },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "display", a_display },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "displaystyle", a_displaystyle },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "divisor", a_divisor },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "dominant-baseline", a_dominantbaseline },
    { { HTML_5_0 }, { HTML_UNDEF }, "download", a_download },
    { { HTML_3_0 }, { HTML_3_0 }, "dp", a_dp },
    { { HTML_5_0 }, { HTML_UNDEF }, "draggable", a_draggable },
    { { HTML_5_0, 0, HE_SVG_2_0 }, { HTML_5_1 }, "dropzone", a_dropzone },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "dur", a_dur },
    { { HTML_5_0, 0, HE_BESPOKE }, { HTML_UNDEF }, "duration", a_duration },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "dx", a_dx },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "dy", a_dy },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "edge", a_edge },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "edgemode", a_edgemode },
    { { XHTML_2_0 }, { XHTML_2_0 }, "edit", a_edit },
    { { XHTML_2_0, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "editable", a_editable },
    { { HTML_PLUS }, { HTML_PLUS }, "effect", a_effect },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "elevation", a_elevation },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "encoding", a_encoding },
    { { HTML_2_0 }, { HTML_UNDEF }, "enctype", a_enctype },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "enable-background", a_enablebackground },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "end", a_end },
    { { HTML_JUL20 }, { HTML_UNDEF }, "enterkeyhint", a_enterkeyhint },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "equalcolumns", a_equalcolumns },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "equalrows", a_equalrows },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "error", a_error },
    { { HTML_4_0 }, { HTML_UNDEF }, "event", a_event },
    { { XHTML_2_0 }, { XHTML_2_0 }, "eventtarget", a_eventtarget },
//    { { XHTML_1_0, 0, HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "ev:event", a_evevent },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "exponent", a_exponent },
    { { HTML_JUL20, 0, HE_EXPERIMENTAL }, { HTML_UNDEF }, "exportparts", a_exportparts },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "externalresourcesrequired", a_externalresourcesrequired },
    { { HTML_4_0 }, { HTML_UNDEF }, "face", a_face },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "fence", a_fence },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "fill", a_fill },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "fill-opacity", a_fill_opacity },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "fill-rule", a_fill_rule },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "filter", a_filter },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "filter-res", a_filterres },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "filterres", a_filterres },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "filter-units", a_filterunits },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "filterunits", a_filterunits },
    { { HTML_4_0, HV_DEPRECATED45, HE_SVG_1_0 }, { HTML_UNDEF }, "fit-bbox", a_fitbbox },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "fit-box-to-viewport", a_fitboxtoviewport },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "flatness", a_flatness },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "flood-color", a_flood_colour },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "flood-opacity", a_flood_opacity },
    { { XHTML_1_1, 0, HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "focusable", a_focusable },
    { { XHTML_1_0, 0, HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "focushighlight", a_focushighlight },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "font", a_font },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "font-family", a_font_family },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "font-size", a_font_size },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "font-size-adjust", a_font_size_adjust },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "font-stretch", a_font_stretch },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "font-style", a_font_style },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "font-variant", a_font_variant },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "font-weight", a_font_weight },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "fontfamily", a_fontfamily },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "fontsize", a_fontsize },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "fontstyle", a_fontstyle },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "fontweight", a_fontweight },
    { { HTML_4_0 }, { HTML_UNDEF }, "for", a_for },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "form", a_form },
    { { HTML_5_0 }, { HTML_UNDEF }, "formaction", a_formaction },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "format", a_format },
    { { HTML_5_0 }, { HTML_UNDEF }, "formenctype", a_formenctype },
    { { HTML_5_0 }, { HTML_UNDEF }, "formmethod", a_formmethod },
    { { HTML_5_0 }, { HTML_UNDEF }, "formnovalidate", a_formnovalidate },
    { { HTML_PLUS }, { HTML_PLUS }, "forms", a_forms },
    { { HTML_5_0 }, { HTML_UNDEF }, "formtarget", a_formtarget },
    { { XHTML_2_0, 0, HE_SVG_2_0 }, { HTML_UNDEF }, "fr", a_fr },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "frame", a_frame },
    { { HTML_4_0 }, { HTML_UNDEF }, "frameborder", a_frameborder },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "framespacing", a_framespacing },
    { { HTML_3_0 }, { HTML_UNDEF }, "from", a_from },
    { { XHTML_2_0 }, { XHTML_2_0 }, "full", a_full },
    { { XHTML_2_0 }, { XHTML_2_0 }, "function", a_function },
    { { HTML_4_0, 0, HE_SVG_1 }, { HTML_UNDEF }, "fx", a_fx },
    { { HTML_4_0, 0, HE_SVG_1 }, { HTML_UNDEF }, "fy", a_fy },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "g1", a_g1 },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "g2", a_g2 },
    { { HTML_5_0 }, { HTML_UNDEF }, "generator-unable-to-provide-required-alt", a_generator_unable },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "glyph-orientation-horizontal", a_glyphorientation_horizontal },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "glyph-orientation-vertical", a_glyph_orientation_vertical },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "glyph-name", a_glyphname },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "glyphref", a_glyphref },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "gradient-transform", a_gradienttransform },
    { { HTML_4_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "gradienttransform", a_gradienttransform },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "gradient-units", a_gradient_units },
    { { HTML_4_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "gradientunits", a_gradientunits },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "groupalign", a_groupalign },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_4_01 }, "gutter", a_gutter },
    { { HTML_4_0, 0, HE_SVG_1_2 | HE_SVG_X_MASK }, { HTML_UNDEF }, "handler", a_handler },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "hanging", a_hanging },
    { { HTML_4_0 }, { HTML_UNDEF }, "headers", a_headers },
    { { HTML_3_0 }, { HTML_UNDEF }, "height", a_height },
    { { HTML_PLUS }, { HTML_UNDEF }, "hidden", a_hidden },
    { { HTML_5_0 }, { HTML_UNDEF }, "high", a_high },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "horiz-adv-x", a_horizadvx },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "horiz-origin-x", a_horizoriginx },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "horiz-origin-y", a_horizoriginy },
    { { HTML_TAGS }, { HTML_UNDEF }, "href", a_href },
    { { HTML_4_0 }, { HTML_UNDEF }, "hreflang", a_hreflang },
    { { XHTML_2_0 }, { XHTML_2_0 }, "hrefmedia", a_hrefmedia },
    { { XHTML_2_0 }, { XHTML_2_0 }, "hreftype", a_hreftype },
    { { HTML_3_2 }, { HTML_UNDEF }, "hspace", a_hspace },
    { { HTML_UNDEF }, { HTML_UNDEF }, "html", a_html },
    { { HTML_2_0 }, { HTML_UNDEF }, "http-equiv", a_httpequiv },
    { { HTML_5_1 }, { HTML_5_1 }, "icon", a_icon },
    { { HTML_PLUS, HV_RFC_2070 | HV_RFC_1942 }, { HTML_UNDEF }, "id", a_id },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "ideographic", a_ideographic },
    { { HTML_PLUS }, { HTML_PLUS }, "idref", a_idref },
    { { XHTML_2_0 }, { XHTML_2_0 }, "if", a_if },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "image-rendering", a_imagerendering },
    { { HTML_3_0 }, { HTML_3_0 }, "imagemap", a_imagemap },
    { { HTML_JUL20 }, { HTML_UNDEF }, "imagesizes", a_imagesizes },
    { { HTML_JUL20 }, { HTML_UNDEF }, "imagesrcset", a_imagesrcset },
    { { XHTML_2_0 }, { XHTML_2_0 }, "implements", a_implements },
    { { HTML_JUL20 }, { HTML_UNDEF }, "importance", a_importance },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "in", a_in },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "in2", a_in2 },
    { { HTML_5_0, 0, HE_CHROME | HE_SAFARI | HE_OPERA }, { HTML_UNDEF }, "incremental", a_incremental },
    { { HTML_3_0 }, { HTML_3_0 }, "indent", a_indent },
    { { HTML_PLUS }, { HTML_PLUS }, "index", a_index },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "initialvisibility", a_initialvisibility },
    { { XHTML_1_1, 0, HE_RDF_1_0 }, { HTML_UNDEF }, "inlist", a_inlist },
    { { HTML_5_0 }, { HTML_UNDEF }, "inputmode", a_inputmode },
    { { HTML_5_3 }, { HTML_UNDEF }, "integrity", a_integrity },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "intercept", a_intercept },
    { { HTML_4_01, 0, HE_CHROME }, { HTML_UNDEF }, "intrinsicsize", a_intrinsicsize },
    { { HTML_5_3 }, { HTML_UNDEF }, "is", a_is },
    { { HTML_PLUS }, { HTML_UNDEF }, "ismap", a_ismap },
    { { HTML_4_01, 0, HE_MICRODATA }, { HTML_UNDEF }, "itemid", a_itemid },
    { { HTML_4_01, 0, HE_MICRODATA }, { HTML_UNDEF }, "itemprop", a_itemprop },
    { { HTML_4_01, 0, HE_MICRODATA }, { HTML_UNDEF }, "itemref", a_itemref },
    { { HTML_4_01, 0, HE_MICRODATA }, { HTML_UNDEF }, "itemscope", a_itemscope },
    { { HTML_4_01, 0, HE_MICRODATA }, { HTML_UNDEF }, "itemtype", a_itemtype },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "k", a_k },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "k1", a_k1 },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "k2", a_k2 },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "k3", a_k3 },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "k4", a_k4 },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "kernelmatrix", a_kernelmatrix },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "kernelunitlength", a_kernelunitlength },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "kerning", a_kerning },
    { { XHTML_2_0 }, { XHTML_2_0 }, "key", a_key },
    { { HTML_5_1 }, { HTML_UNDEF }, "keyparams", a_keyparams },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "keysplines", a_keysplines },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "keytimes", a_keytimes },
    { { HTML_5_1 }, { HTML_UNDEF }, "keytype", a_keytype },
    { { HTML_5_0 }, { HTML_UNDEF }, "kind", a_kind },
    { { HTML_3_2 }, { HTML_UNDEF }, "label", a_label },
    { { HTML_3_0 }, { HTML_3_0 }, "labels", a_labels },
    { { HTML_PLUS, HV_RFC_2070 | HV_RFC_1942 }, { HTML_UNDEF }, "lang", a_lang },
    { { HTML_4_0 }, { HTML_UNDEF }, "language", a_language },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "largeop", a_largeop },
    { { XHTML_2_0 }, { XHTML_2_0 }, "layout", a_layout },
    { { HTML_3_0 }, { HTML_3_0 }, "ldelim", a_ldelim },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "left", a_left },
    { { HTML_3_2, HV_DEPRECATED4, HE_CHROME }, { HTML_4_01 }, "leftmargin", a_leftmargin },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "lengthadjust", a_lengthadjust },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "letter-spacing", a_letter_spacing },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "light-color", a_lightcolour },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "lighting-color", a_lighting_colour },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "limitingconeangle", a_limitingconeangle },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "linethickness", a_linethickness },
    { { HTML_3_2 }, { HTML_UNDEF }, "link", a_link },
    { { HTML_5_0 }, { HTML_UNDEF }, "list", a_list },
    { { HTML_JUL20, HV_WHATWG }, { HTML_UNDEF }, "loading", a_loading },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "local", a_local },
    { { HTML_4_0 }, { HTML_UNDEF }, "longdesc", a_longdesc },
    { { HTML_2_0 }, { HTML_UNDEF }, "loop", a_loop },
    { { HTML_5_0 }, { HTML_UNDEF }, "low", a_low },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "lquote", a_lquote },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "lspace", a_lspace },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "macros", a_macros },
    { { HTML_5_0 }, { HTML_UNDEF }, "manifest", a_manifest },
    { { HTML_4_0 }, { HTML_UNDEF }, "marginheight", a_marginheight },
    { { HTML_4_0 }, { HTML_UNDEF }, "marginwidth", a_marginwidth },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "marker", a_marker },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "marker-end", a_marker_end },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "marker-mid", a_marker_mid },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "marker-start", a_marker_start },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "marker-height", a_markerheight },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "markerheight", a_markerheight },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "marker-units", a_markerunits },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "markerunits", a_markerunits },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "marker-width", a_markerwidth },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "markerwidth", a_markerwidth },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "mask", a_mask },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "maskcontentunits", a_maskcontentunits },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "mask-units", a_mask_units },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "maskunits", a_maskunits },
    { { HTML_3_0 }, { HTML_UNDEF }, "math", a_math },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "mathematical", a_mathematical },
    { { HTML_PLUS, HV_NOT234 }, { HTML_UNDEF }, "max", a_max },
    { { HTML_2_0 }, { HTML_UNDEF }, "maxlength", a_maxlength },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "maxsize", a_maxsize },
    { { HTML_3_0 }, { HTML_3_0 }, "md", a_md },
    { { HTML_4_0 }, { HTML_UNDEF }, "media", a_media },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "mediacharacterencoding", a_mediacharacterencoding },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "mediacontentencodings", a_mediacontentencodings },
    { { HTML_5_0 }, { HTML_UNDEF }, "mediagroup", a_mediagroup },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "mediasize", a_mediasize },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "mediatime", a_mediatime },
    { { HTML_5_0 }, { HTML_UNDEF }, "menu", a_menu },
    { { HTML_PLUS }, { HTML_UNDEF }, "method", a_method },
    { { HTML_1_0 }, { HTML_UNDEF }, "methods", a_methods },
    { { HTML_PLUS, HV_NOT2 }, { HTML_UNDEF }, "min", a_min },
    { { HTML_5_0 }, { HTML_UNDEF }, "minlength", a_minlength },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "minsize", a_minsize },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "mode", a_mode },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "movablelimits", a_movablelimits },
    { { HTML_5_0, 0, HE_MOZILLA }, { HTML_UNDEF }, "mozactionhint", a_mozactionhint },
    { { HTML_5_0, 0, HE_MOZILLA }, { HTML_UNDEF }, "mozbrowser", a_mozbrowser },
    { { HTML_2_0 }, { HTML_UNDEF }, "multiple", a_multiple },
    { { HTML_5_0 }, { HTML_UNDEF }, "muted", a_muted },
    { { HTML_TAGS, HV_DEPRECATED23 }, { HTML_3_0 }, "n", a_n },
    { { HTML_TAGS, HV_DEPRECATED30 }, { HTML_UNDEF }, "name", a_name },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "nargs", a_nargs },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-down", a_navdown },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-down-left", a_navdownleft },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-down-right", a_navdownright },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-left", a_navleft },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-next", a_navnext },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-prev", a_navprev },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-right", a_navright },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-up", a_navup },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-up-left", a_navupleft },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "nav-up-right", a_navupright },
    { { XHTML_2_0 }, { XHTML_2_0 }, "nextfocus", a_nextfocus },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "nodeid", a_nodeid },
    { { HTML_3_0 }, { HTML_3_0 }, "noflow", a_noflow },
    { { HTML_2_0, HV_RFC_1980 }, { HTML_UNDEF }, "nohref", a_nohref },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "nominal-length", a_nominallength },
    { { HTML_5_0, HV_WHATWG }, { HTML_UNDEF }, "nomodule", a_nomodule },
    { { HTML_4_0 }, { HTML_UNDEF }, "noresize", a_noresize },
    { { HTML_3_2 }, { HTML_UNDEF }, "noshade", a_noshade },
    { { HTML_3_0 }, { HTML_3_0 }, "notation", a_notation },
    { { HTML_5_0 }, { HTML_UNDEF }, "novalidate", a_novalidate },
    { { HTML_2_0, HV_RFC_1942 }, { HTML_UNDEF }, "nowrap", a_nowrap },
    { { HTML_5_1 }, { HTML_UNDEF }, "nonce", a_numberonce }, // A nonce is a paedophile. Why is the word used in HTML?
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "num-octaves", a_numoctaves },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "numoctaves", a_numoctaves },
    { { HTML_4_0 }, { HTML_UNDEF }, "object", a_object },
    { { XHTML_2_0, 0, HE_SVG_1_2 | HE_SVG_X_MASK }, { XHTML_2_0 }, "observer", a_observer },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "occurrence", a_occurrence },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "offset", a_offset },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onabort", a_onabort },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onactivate", a_onactivate },
    { { HTML_5_0 }, { HTML_UNDEF }, "onafterprint", a_onafterprint },
    { { HTML_5_2 }, { HTML_UNDEF }, "onauxclick", a_onauxclick },
    { { HTML_5_0 }, { HTML_UNDEF }, "onbeforeprint", a_onbeforeprint },
    { { HTML_5_0 }, { HTML_UNDEF }, "onbeforeunload", a_onbeforeunload },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onbegin", a_onbegin },
    { { HTML_4_0 }, { HTML_UNDEF }, "onblur", a_onblur },
    { { HTML_5_0 }, { HTML_UNDEF }, "oncancel", a_oncancel },
    { { HTML_5_0 }, { HTML_UNDEF }, "oncanplay", a_oncanplay },
    { { HTML_5_0 }, { HTML_UNDEF }, "oncanplaythrough", a_oncanplaythrough },
    { { HTML_4_0 }, { HTML_UNDEF }, "onchange", a_onchange },
    { { HTML_4_0 }, { HTML_UNDEF }, "onclick", a_onclick },
    { { HTML_5_1 }, { HTML_UNDEF }, "onclose", a_onclose },
    { { HTML_5_1 }, { HTML_UNDEF }, "oncontextmenu", a_oncontextmenu },
    { { HTML_5_1 }, { HTML_UNDEF }, "oncopy", a_oncopy },
    { { HTML_5_0 }, { HTML_UNDEF }, "oncuechange", a_oncuechange },
    { { HTML_5_1 }, { HTML_UNDEF }, "oncut", a_oncut },
    { { HTML_4_0 }, { HTML_UNDEF }, "ondblclick", a_ondblclick },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondrag", a_ondrag },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondragend", a_ondragend },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondragenter", a_ondragenter },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondragexit", a_ondragexit },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondragleave", a_ondragleave },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondragover", a_ondragover },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondragstart", a_ondragstart },
    { { HTML_5_1 }, { HTML_UNDEF }, "ondrop", a_ondrop },
    { { HTML_5_0 }, { HTML_UNDEF }, "ondurationchange", a_ondurationchange },
    { { HTML_5_0 }, { HTML_UNDEF }, "onemptied", a_onemptied },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onend", a_onend },
    { { HTML_5_0 }, { HTML_UNDEF }, "onended", a_onended },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onerror", a_onerror },
    { { HTML_4_0 }, { HTML_UNDEF }, "onfocus", a_onfocus },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onfocusin", a_onfocusin },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onfocusout", a_onfocusout },
    { { HTML_JUL20 }, { HTML_UNDEF }, "onformdata", a_onformdata },
    { { HTML_5_0 }, { HTML_UNDEF }, "onhashchange", a_onhashchange },
    { { HTML_5_0 }, { HTML_UNDEF }, "oninput", a_oninput },
    { { HTML_5_0 }, { HTML_UNDEF }, "oninvalid", a_oninvalid },
    { { HTML_4_0 }, { HTML_UNDEF }, "onkeydown", a_onkeydown },
    { { HTML_4_0 }, { HTML_UNDEF }, "onkeypress", a_onkeypress },
    { { HTML_4_0 }, { HTML_UNDEF }, "onkeyup", a_onkeyup },
    { { HTML_5_1 }, { HTML_UNDEF }, "onlanguagechange", a_onlanguagechange },
    { { HTML_4_0 }, { HTML_UNDEF }, "onload", a_onload },
    { { HTML_5_0 }, { HTML_UNDEF }, "onloadeddata", a_onloadeddata },
    { { HTML_5_0 }, { HTML_UNDEF }, "onloadedmetadata", a_onloadedmetadata },
    { { HTML_5_3 }, { HTML_UNDEF }, "onloadend", a_onloadend },
    { { HTML_5_0 }, { HTML_UNDEF }, "onloadstart", a_onloadstart },
    { { HTML_5_0 }, { HTML_UNDEF }, "onmessage", a_onmessage },
    { { HTML_JUL20 }, { HTML_UNDEF }, "onmessageerror", a_onmessageerror },
    { { HTML_4_0 }, { HTML_UNDEF }, "onmousedown", a_onmousedown },
    { { HTML_5_0 }, { HTML_UNDEF }, "onmouseenter", a_onmouseenter },
    { { HTML_5_0 }, { HTML_UNDEF }, "onmouseleave", a_onmouseleave },
    { { HTML_4_0 }, { HTML_UNDEF }, "onmousemove", a_onmousemove },
    { { HTML_4_0 }, { HTML_UNDEF }, "onmouseout", a_onmouseout },
    { { HTML_4_0 }, { HTML_UNDEF }, "onmouseover", a_onmouseover },
    { { HTML_4_0 }, { HTML_UNDEF }, "onmouseup", a_onmouseup },
    { { HTML_4_0 }, { HTML_5_0 }, "onmousewheel", a_onmousewheel },
    { { HTML_5_0 }, { HTML_UNDEF }, "onoffline", a_onoffline },
    { { HTML_5_0 }, { HTML_UNDEF }, "ononline", a_ononline },
    { { HTML_5_0 }, { HTML_UNDEF }, "onpagehide", a_onpagehide },
    { { HTML_5_0 }, { HTML_UNDEF }, "onpageshow", a_onpageshow },
    { { HTML_5_1 }, { HTML_UNDEF }, "onpaste", a_onpaste },
    { { HTML_5_0 }, { HTML_UNDEF }, "onpause", a_onpause },
    { { HTML_5_0 }, { HTML_UNDEF }, "onplay", a_onplay },
    { { HTML_5_0 }, { HTML_UNDEF }, "onplaying", a_onplaying },
    { { HTML_5_0 }, { HTML_UNDEF }, "onpopstate", a_onpopstate },
    { { HTML_5_0 }, { HTML_UNDEF }, "onprogress", a_onprogress },
    { { HTML_5_0 }, { HTML_UNDEF }, "onratechange", a_onratechange },
    { { HTML_5_1 }, { HTML_UNDEF }, "onrejectionhandled", a_onrejectionhandled },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onrepeat", a_onrepeat },
    { { HTML_4_0 }, { HTML_UNDEF }, "onreset", a_onreset },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onresize", a_onresize },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onscroll", a_onscroll },
    { { HTML_JUL20 }, { HTML_UNDEF }, "onsecuritypolicyviolation", a_onsecuritypolicyviolation },
    { { HTML_5_0 }, { HTML_UNDEF }, "onseeked", a_onseeked },
    { { HTML_5_0 }, { HTML_UNDEF }, "onseeking", a_onseeking },
    { { HTML_4_0 }, { HTML_UNDEF }, "onselect", a_onselect },
    { { HTML_5_0 }, { HTML_UNDEF }, "onshow", a_onshow },
    { { HTML_JUL20 }, { HTML_UNDEF }, "onslotchange", a_onslotchange },
    { { HTML_5_0 }, { HTML_UNDEF }, "onstalled", a_onstalled },
    { { HTML_5_0 }, { HTML_UNDEF }, "onstorage", a_onstorage },
    { { HTML_4_0 }, { HTML_UNDEF }, "onsubmit", a_onsubmit },
    { { HTML_5_0 }, { HTML_UNDEF }, "onsuspend", a_onsuspend },
    { { HTML_5_0 }, { HTML_UNDEF }, "ontimeupdate", a_ontimeupdate },
    { { HTML_5_0 }, { HTML_UNDEF }, "ontoggle", a_ontoggle },
    { { HTML_5_1 }, { HTML_UNDEF }, "onunhandledrejection", a_onunhandledrejection },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onunload", a_onunload },
    { { HTML_5_0 }, { HTML_UNDEF }, "onvolumechange", a_onvolumechange },
    { { HTML_5_0 }, { HTML_UNDEF }, "onwaiting", a_onwaiting },
    { { HTML_5_1 }, { HTML_UNDEF }, "onwheel", a_onwheel },
    { { XHTML_1_0 }, { HTML_UNDEF }, "onzoom", a_onzoom },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "opacity", a_opacity },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "open", a_open },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "operator", a_operator },
    { { HTML_5_0 }, { HTML_UNDEF }, "optimum", a_optimum },
    { { XHTML_1_0 }, { HTML_UNDEF }, "order", a_order },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "orient", a_orient },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "orientation", a_orientation },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "origin", a_origin },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "other", a_other },
    { { XHTML_1_0, 0, HE_MATH_1 | HE_SVG_1x2 }, { HTML_UNDEF }, "overflow", a_overflow },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "overlay", a_overlay },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "overline-position", a_overlineposition },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "overline-thickness", a_overlinethickness },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "pagex", a_pagex },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "pagey", a_pagey },
    { { XHTML_2_0, 0, HE_SVG_2_0 }, { HTML_UNDEF }, "paint-order", a_paint_order },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "panose-1", a_panose1 },
    { { HTML_JUL20, 0, HE_EXPERIMENTAL }, { HTML_UNDEF }, "part", a_part },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "path", a_path },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "pathlength", a_pathlength },
    { { HTML_5_0 }, { HTML_UNDEF }, "pattern", a_pattern },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "patterncontentunits", a_patterncontentunits },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "pattern-transform", a_patterntransform },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "patterntransform", a_patterntransform },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "pattern-units", a_pattern_units },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "patternunits", a_patternunits },
    { { XHTML_2_0 }, { XHTML_2_0 }, "phase", a_phase },
    { { HTML_5_3 }, { HTML_UNDEF }, "ping", a_ping },
    { { HTML_5_0 }, { HTML_UNDEF }, "placeholder", a_placeholder },
    { { HTML_PLUS, HV_NOT2 }, { HTML_3_0 }, "plain", a_plain },
    { { XHTML_1_1, 0, HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "playbackorder", a_playbackorder },
    { { HTML_JUL20 }, { HTML_UNDEF }, "playsinline", a_playsinline },
    { { XHTML_2_0, 0, HE_SVG_2_0 }, { HTML_UNDEF }, "pointer-events", a_pointerevents },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "points", a_points },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "points-at-x", a_pointsatx },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "pointsatx", a_pointsatx },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "points-at-y", a_pointsaty },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "pointsaty", a_pointsaty },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "points-at-z", a_pointsatz },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "pointsatz", a_pointsatz },
    { { HTML_5_0 }, { HTML_UNDEF }, "poster", a_poster },
    { { HTML_5_0, 0, HE_MOZILLA }, { HTML_UNDEF }, "prefetch", a_prefetch },
    { { XHTML_1_1, 0, HE_RDF_1_0 }, { HTML_UNDEF }, "prefix", a_prefix },
    { { HTML_4_0 }, { HTML_UNDEF }, "preload", a_preload },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "preservealpha", a_preservealpha },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "preserve-aspect-ratio", a_preserveaspectratio },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "preserveaspectratio", a_preserveaspectratio },
    { { XHTML_2_0 }, { XHTML_2_0 }, "prevfocus", a_prevfocus },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "primitiveunits", a_primitiveunits },
    { { HTML_PLUS }, { HTML_PLUS }, "print", a_print },
    { { HTML_4_0 }, { XHTML_2_0 }, "profile", a_profile },
    { { HTML_3_0 }, { XHTML_2_0 }, "prompt", a_prompt },
    { { XHTML_2_0 }, { XHTML_2_0 }, "propagate", a_propagate },
    { { XHTML_1_1, 0, HE_RDF_1_0 | HE_SVG_1_2 | HE_SVG_X2 }, { HTML_UNDEF }, "property", a_property },
    { { HTML_1_0 }, { HTML_UNDEF }, "public", a_public },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "r", a_r },
    { { HTML_5_1 }, { HTML_5_1 }, "radiogroup", a_radiogroup },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "radius", a_radius },
    { { HTML_3_0 }, { HTML_3_0 }, "rdelim", a_rdelim },
    { { HTML_4_0 }, { HTML_UNDEF }, "readonly", a_readonly },
    { { HTML_5_2 }, { HTML_UNDEF }, "referrerpolicy", a_referrerpolicy },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "ref-x", a_refx },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "refx", a_refx },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "ref-y", a_refy },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "refy", a_refy },
    { { HTML_1_0 }, { HTML_UNDEF }, "rel", a_rel },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "rendering-intent", a_renderingintent },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "repeatcount", a_repeatcount },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "repeatdur", a_repeatdur },
    { { HTML_5_0 }, { HTML_UNDEF }, "required", a_required },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "requiredextensions", a_requiredextensions },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "requiredfeatures", a_requiredfeatures },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "requiredfonts", a_requiredfonts },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "requiredformats", a_requiredformats },
    { { XHTML_1_1, 0, HE_RDF_1_0 | HE_SVG_1_2 | HE_SVG_X2 }, { HTML_UNDEF }, "resource", a_resource },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "restart", a_restart },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "result", a_result },
    { { HTML_5_0, 0, HE_SAFARI }, { HTML_UNDEF }, "results", a_results },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "result-scale", a_resultscale },
    { { HTML_1_0 }, { HTML_UNDEF }, "rev", a_rev },
    { { HTML_5_0 }, { HTML_UNDEF }, "reversed", a_reversed },
    { { HTML_3_2, HV_DEPRECATED4, HE_CHROME }, { HTML_4_01 }, "rightmargin", a_rightmargin },
    { { HTML_PLUS, HV_NOT234 }, { HTML_UNDEF }, "role", a_role },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "rotate", a_rotate },
    { { HTML_5_2, HV_W3 }, { HTML_UNDEF }, "row", a_row },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "rowalign", a_rowalign },
    { { HTML_5_2 }, { HTML_UNDEF }, "rowgroup", a_rowgroup },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "rowlines", a_rowlines },
    { { HTML_PLUS }, { HTML_UNDEF }, "rows", a_rows },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "rowspacing", a_rowspacing },
    { { HTML_PLUS, HV_RFC_1942 }, { HTML_UNDEF }, "rowspan", a_rowspan },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "rquote", a_rquote },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "rspace", a_rspace },
    { { HTML_2_0, HV_RFC_1942 }, { XHTML_2_0 }, "rules", a_rules },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "rx", a_rx },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "ry", a_ry },
    { { HTML_5_0 }, { HTML_UNDEF }, "sandbox", a_sandbox },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "scale", a_scale },
    { { HTML_4_0 }, { HTML_UNDEF }, "scheme", a_scheme },
    { { HTML_2_0, HV_NOT32 }, { HTML_UNDEF }, "scope", a_scope },
    { { HTML_4_0, 0, HE_CHROME }, { HTML_UNDEF }, "scoped", a_scoped },
    { { HTML_3_0 }, { HTML_3_0 }, "script", a_script },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "scriptlevel", a_scriptlevel },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "scriptminsize", a_scriptminsize },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "scriptsizemultiplier", a_scriptsizemultiplier },
    { { HTML_2_0, 0, HE_IE }, { HTML_UNDEF }, "scrollamount", a_scrollamount },
    { { HTML_2_0, 0, HE_IE }, { HTML_UNDEF }, "scrolldelay", a_scrolldelay },
    { { HTML_4_0 }, { HTML_UNDEF }, "scrolling", a_scrolling },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "seed", a_seed },
    { { HTML_PLUS }, { HTML_PLUS }, "seethru", a_seethru },
    { { HTML_3_2 }, { HTML_UNDEF }, "select", a_select },
    { { HTML_PLUS }, { HTML_UNDEF }, "selected", a_selected },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "selection", a_selection },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "separator", a_separator },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "separators", a_separators },
    { { HTML_3_0 }, { HTML_3_0 }, "seqnum", a_seqnum },
    { { HTML_PLUS }, { HTML_PLUS }, "several", a_several },
    { { HTML_PLUS }, { HTML_UNDEF }, "shape", a_shape },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "shape-rendering", a_shaperendering },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "show", a_show },
    { { XHTML_2_0, 0,  HE_SVG_2_0 }, { HTML_UNDEF }, "side", a_side },
    { { HTML_PLUS }, { HTML_UNDEF }, "size", a_size },
    { { HTML_5_0 }, { HTML_UNDEF }, "sizes", a_sizes },
    { { HTML_3_0 }, { HTML_3_0 }, "skip", a_skip },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "slope", a_slope },
    { { HTML_JUL20 }, { HTML_UNDEF }, "slot", a_slot },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "snapshottime", a_snapshottime },
    { { HTML_5_0 }, { HTML_UNDEF }, "sortable", a_sortable },
    { { HTML_5_0 }, { HTML_UNDEF }, "sorted", a_sorted },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "spacing", a_spacing },
    { { HTML_2_0, HV_NOT3 | HV_RFC_1942 }, { HTML_UNDEF }, "span", a_span },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "specular-constant", a_specularconstant },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "specularconstant", a_specularconstant },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "specular-exponent", a_specularexponent },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "specularexponent", a_specularexponent },
    { { HTML_5_0 }, { HTML_UNDEF }, "spellcheck", a_spellcheck },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "spread-method", a_spreadmethod },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "spreadmethod", a_spreadmethod },
    { { HTML_1_0 }, { HTML_UNDEF }, "src", a_src },
    { { HTML_5_0 }, { HTML_UNDEF }, "srcdoc", a_srcdoc },
    { { HTML_5_0 }, { HTML_UNDEF }, "srclang", a_srclang },
    { { HTML_5_1 }, { HTML_UNDEF }, "srcset", a_srcset },
    { { XHTML_2_0 }, { XHTML_2_0 }, "srctype", a_srctype },
    { { HTML_4_0 }, { HTML_UNDEF }, "standby", a_standby },
    { { HTML_3_2 }, { HTML_UNDEF }, "start", a_start },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "start-offset", a_start_offset },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "startoffset", a_startoffset },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "std-deviation", a_std_deviation },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "stddeviation", a_stddeviation },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "stemh", a_stemh },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "stemv", a_stemv },
    { { HTML_5_0 }, { HTML_UNDEF }, "step", a_step },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "stitchtiles", a_stitchtiles },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stop-color", a_stop_colour },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stop-opacity", a_stop_opacity },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "stretchy", a_stretchy },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "strikethrough-position", a_strikethroughposition },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "strikethrough-thickness", a_strikethroughthickness },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "string", a_string },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke", a_stroke },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke-dasharray", a_stroke_dasharray },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke-dashoffset", a_stroke_dashoffset },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke-linecap", a_stroke_linecap },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke-linejoin", a_stroke_linejoin },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke-miterlimit", a_stroke_miterlimit },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke-opacity", a_stroke_opacity },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "stroke-width", a_stroke_width },
    { { HTML_PLUS }, { HTML_UNDEF }, "style", a_style },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "subscriptshift", a_subscriptshift },
    { { HTML_4_0 }, { HTML_UNDEF }, "summary", a_summary },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "superscriptshift", a_superscriptshift },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "surface-scale", a_surfacescale },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "surfacescale", a_surfacescale },
    { { HTML_1_0 }, { HTML_UNDEF }, "svg", a_svg },
    { { HTML_3_0 }, { HTML_3_0 }, "sym", a_sym },
    { { XHTML_1_0, 0, HE_MATH_1 }, { HTML_UNDEF }, "symmetric", a_symmetric },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "syncbehavior", a_syncbehaviour },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "syncbehaviordefault", a_syncbehaviourdefault },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "syncmaster", a_syncmaster },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "synctolerance", a_synctolerance },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "synctolerancedefault", a_synctolerancedefault },
    { { HTML_1_0 }, { HTML_UNDEF }, "system", a_system },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "systemlanguage", a_systemlanguage },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "system-required", a_systemrequired },
    { { HTML_4_0 }, { HTML_UNDEF }, "tabindex", a_tabindex },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "table-values", a_tablevalues },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "tablevalues", a_tablevalues },
    { { HTML_PLUS }, { HTML_PLUS }, "tag", a_tag },
    { { HTML_4_0 }, { HTML_UNDEF }, "target", a_target },
    { { XHTML_2_0 }, { XHTML_2_0 }, "targetid", a_targetid },
    { { XHTML_2_0 }, { XHTML_2_0 }, "targetrole", a_targetrole },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "targetx", a_targetx },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "targety", a_targety },
    { { HTML_3_2 }, { HTML_UNDEF }, "text", a_text },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "text-anchor", a_textanchor },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "text-decoration", a_textdecoration },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "text-rendering", a_textrendering },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "textlength", a_textlength },
    { { XHTML_1_1, 0, HE_SVG_1_2 | HE_SVG_2_0 }, { HTML_UNDEF }, "timelinebegin", a_timelinebegin },
    { { HTML_1_0 }, { HTML_UNDEF }, "title", a_title },
    { { HTML_3_0 }, { HTML_UNDEF }, "to", a_to },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "top", a_top },
    { { HTML_3_2, HV_DEPRECATED4, HE_CHROME }, { HTML_4_01 }, "topmargin", a_topmargin },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "transform", a_transform },
    { { XHTML_1_0, 0, HE_SVG }, { HTML_UNDEF }, "transform", a_svg_transform, ns_svg },
    { { XHTML_1_1, 0, HE_SVG_1_2 }, { HTML_UNDEF }, "transformbehavior", a_transformbehaviour },
    { { HTML_5_0 }, { HTML_UNDEF }, "translate", a_translate },
    { { XHTML_2_0 }, { XHTML_2_0 }, "translate", a_itstranslate, ns_its },
    { { HTML_2_0, 0, HE_IE }, { HTML_UNDEF }, "truespeed", a_truespeed },
    { { HTML_TAGS }, { HTML_UNDEF }, "type", a_type },
    { { HTML_5_0 }, { HTML_UNDEF }, "typemustmatch", a_typemustmatch },
    { { XHTML_1_1, 0, HE_RDF_1_0 | HE_SVG_1_2 | HE_SVG_X2 }, { HTML_UNDEF }, "typeof", a_typeof },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "u1", a_u1 },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "u2", a_u2 },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "underline-position", a_underlineposition },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "underline-thickness", a_underlinethickness },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "unicode", a_unicode },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "unicode-bidi", a_unicodebidi },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "unicode-range", a_unicoderange },
    { { HTML_3_0 }, { HTML_3_0 }, "units", a_units },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "units-per-em", a_unitsperem },
    { { HTML_3_0 }, { HTML_3_0 }, "until", a_until },
    { { HTML_1_0 }, { HTML_UNDEF }, "urn", a_urn },
    { { HTML_2_0, HV_RFC_1980 }, { HTML_UNDEF }, "usemap", a_usemap },
    { { HTML_2_0 }, { HTML_UNDEF }, "valign", a_valign },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "v-alphabetic", a_valphabetic },
    { { HTML_PLUS }, { HTML_UNDEF }, "value", a_value },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "values", a_values },
    { { HTML_4_0 }, { HTML_UNDEF }, "valuetype", a_valuetype },
    { { XHTML_2_0, 0, HE_SVG_2_0 }, { HTML_UNDEF }, "vector-effect", a_vector_effect },
    { { HTML_UNDEF, HV_NOT2 }, { HTML_UNDEF }, "version", a_version },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "vert-adv-y", a_vertadvy },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "vert-origin-x", a_vertoriginx },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "vert-origin-y", a_vertoriginy },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "v-hanging", a_vhanging },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "v-ideographic", a_videographic },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "viewbox", a_viewbox },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "viewtarget", a_viewtarget },
    { { HTML_2_0, HV_NOTX1, HE_NETSCAPE | HE_SVG_1x2 }, { HTML_UNDEF }, "visibility", a_visibility },
    { { HTML_3_2 }, { HTML_UNDEF }, "vlink", a_vlink },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "v-mathematical", a_vmathematical },
    { { XHTML_1_1, 0, HE_RDF_1_0 }, { HTML_UNDEF }, "vocab", a_vocab },
    { { HTML_2_0 }, { HTML_UNDEF }, "volume", a_volume },
    { { HTML_3_2 }, { HTML_UNDEF }, "vspace", a_vspace },
    { { HTML_5_0, 0, HE_BESPOKE }, { HTML_UNDEF }, "webkitdirectory", a_webkitdirectory },
    { { XHTML_2_0 }, { XHTML_2_0 }, "while", a_while },
    { { HTML_1_0 }, { HTML_UNDEF }, "width", a_width },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "word-spacing", a_word_spacing },
    { { HTML_PLUS }, { HTML_UNDEF }, "wrap", a_wrap },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "writing-mode", a_writingmode },
    { { HTML_3_0, HV_NOT32, HE_SVG }, { HTML_UNDEF }, "x", a_x },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "x1", a_x1 },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "x2", a_x2 },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "x-channel-selector", a_xchannelselector },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "xchannelselector", a_xchannelselector },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "actuate", a_xlinkactuate, ns_xlink },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "arcrole", a_xlinkarcrole, ns_xlink },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "x-height", a_xheight },
    { { XHTML_1_0, 0, HE_SVG_1_1 }, { HTML_UNDEF }, "href", a_xlinkhref, ns_xlink },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "role", a_xlinkrole, ns_xlink },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "show", a_xlinkshow, ns_xlink },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "title", a_xlinktitle, ns_xlink },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_1_2 }, { HTML_UNDEF }, "type", a_xlinktype, ns_xlink },
    { { XHTML_1_0 }, { HTML_UNDEF }, "base", a_xmlbase, ns_xhtml },
    { { XHTML_2_0 }, { XHTML_2_0 }, "id", a_xmlid, ns_xhtml },
    { { XHTML_1_0 }, { HTML_UNDEF }, "lang", a_xmllang, ns_xhtml },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "link", a_xmllink, ns_xhtml },
    { { HTML_4_0 }, { HTML_UNDEF }, "xmlns", a_xmlns },
    { { XHTML_1_0 }, { HTML_UNDEF }, "space", a_xmlspace, ns_xhtml },
    { { XHTML_2_0 }, { XHTML_2_0 }, "schemalocation", a_xsischemaloc, ns_xsi },
    { { HTML_3_0, HV_NOT32 , HE_SVG }, { HTML_UNDEF }, "y", a_y },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "y1", a_y1 },
    { { HTML_4_0, 0, HE_SVG }, { HTML_UNDEF }, "y2", a_y2 },
    { { HTML_4_0, 0, HE_SVG_1_0 }, { HTML_UNDEF }, "y-channel-selector", a_ychannelselector },
    { { XHTML_1_0, 0, HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "ychannelselector", a_ychannelselector },
    { { HTML_4_0, 0, HE_SVG_1_0 | HE_SVG_1_1 | HE_SVG_2_0 }, { HTML_UNDEF }, "z", a_z },
    { { HTML_2_0, 0, HE_NETSCAPE }, { HTML_3_2 }, "zindex", a_zindex },
    { { XHTML_1_0, 0, HE_SVG_1x2 }, { HTML_UNDEF }, "zoomandpan", a_zoomandpan } };

void attr::init (nitpick& nits)
{   symbol::init (nits, attribute_symbol_table, sizeof (attribute_symbol_table) / sizeof (symbol_entry < e_attribute >), true); }

e_attribute attr::parse (nitpick& nits, const html_version& v, const ::std::string& x)
{   ::std::string lc (x);
    e_namespace n (examine_namespace (nits, v, lc));
    if (n >= first_runtime_namespace)
    {   type_master < t_xmlns > newspace;
        html_version vv (v);
        nitpick knot;
        newspace.set_value (knot, vv, lc);
        if (! newspace.good ()) nits.pick (nit_xmlns_namespace, es_info, ec_namespace, "namespace ", lc, " declared");
        else nits.pick (nit_xmlns_namespace, es_error, ec_namespace, "namespace ", quote (lc), " has already been declared");
        return a_xmlns; }
    if (lc.empty ()) return a_unknown;
    if (((v == xhtml_1_0) || (v == xhtml_1_1)) && (x.find_first_of (UPPERCASE) != ::std::string::npos))
        nits.pick (nit_xhtml_attribute_lc, ed_x1, "4.2. Element and attribute names must be in lower case", es_warning, ec_element, "attribute names must be lower cased in ", v.report ());
    symbol < e_attribute > a (lc, n);
    if (! a.unknown ())
        if (! does_apply (v, a.first (), a.last ()))
            nits.pick (nit_attribute_unrecognised_here, es_warning, ec_attribute, quote (x), " is not valid in ", v.report ());
        else return a.get ();
    else check_spelling (nits, v, lc);
    return a_unknown; }
