/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "schema_structure.h"
#include "schema_property.h"
#include "context.h"

struct microdata_structure
{   schema_version from_;
    schema_version to_;
    e_schema record_ = sch_context;
    e_schema_property property_ = sp_context; };

microdata_structure schema_structure [] =
{
    { { 6, 0 }, { 0, 0 }, sch_3dmodel, sp_isresizable },

    { { 5, 0 }, { 0, 0 }, sch_accommodation, sp_accommodationcategory },
    { { 6, 0 }, { 0, 0 }, sch_accommodation, sp_accommodationfloorplan },
    { { 3, 1 }, { 0, 0 }, sch_accommodation, sp_amenityfeature },
    { { 5, 0 }, { 0, 0 }, sch_accommodation, sp_floorlevel },
    { { 3, 1 }, { 0, 0 }, sch_accommodation, sp_floorsize },
    { { 5, 0 }, { 0, 0 }, sch_accommodation, sp_leaselength },
    { { 5, 0 }, { 0, 0 }, sch_accommodation, sp_numberofbathroomstotal },
    { { 7, 0 }, { 0, 0 }, sch_accommodation, sp_numberofbedrooms },
    { { 5, 0 }, { 0, 0 }, sch_accommodation, sp_numberoffullbathrooms },
    { { 6, 0 }, { 0, 0 }, sch_accommodation, sp_numberofpartialbathrooms },
    { { 3, 1 }, { 0, 0 }, sch_accommodation, sp_numberofrooms },
    { { 3, 1 }, { 0, 0 }, sch_accommodation, sp_permittedusage },
    { { 3, 1 }, { 0, 0 }, sch_accommodation, sp_petsallowed },
    { { 7, 0 }, { 0, 0 }, sch_accommodation, sp_tourbookingpage },
    { { 6, 0 }, { 0, 0 }, sch_accommodation, sp_yearbuilt },

    { { 2, 0 }, { 0, 0 }, sch_action, sp_actionstatus },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_agent },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_endtime },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_error },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_instrument },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_location },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_object },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_participant },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_result },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_starttime },
    { { 2, 0 }, { 0, 0 }, sch_action, sp_target },

    { { 3, 5 }, { 0, 0 }, sch_actionaccessspecification, sp_availabilityends },
    { { 3, 5 }, { 0, 0 }, sch_actionaccessspecification, sp_availabilitystarts },
    { { 3, 5 }, { 0, 0 }, sch_actionaccessspecification, sp_category },
    { { 3, 5 }, { 0, 0 }, sch_actionaccessspecification, sp_eligibleregion },
    { { 3, 5 }, { 0, 0 }, sch_actionaccessspecification, sp_expectsacceptanceof },
    { { 3, 9 }, { 0, 0 }, sch_actionaccessspecification, sp_ineligibleregion },
    { { 3, 5 }, { 0, 0 }, sch_actionaccessspecification, sp_requiressubscription },

    { { 2, 0 }, { 0, 0 }, sch_aggregateoffer, sp_highprice },
    { { 2, 0 }, { 0, 0 }, sch_aggregateoffer, sp_lowprice },
    { { 2, 0 }, { 0, 0 }, sch_aggregateoffer, sp_offercount },
    { { 2, 0 }, { 0, 0 }, sch_aggregateoffer, sp_offers },

    { { 2, 0 }, { 0, 0 }, sch_aggregaterating, sp_itemreviewed },
    { { 2, 0 }, { 0, 0 }, sch_aggregaterating, sp_ratingcount },
    { { 2, 0 }, { 0, 0 }, sch_aggregaterating, sp_reviewcount },

    { { 2, 0 }, { 0, 0 }, sch_airline, sp_boardingpolicy },
    { { 2, 0 }, { 0, 0 }, sch_airline, sp_iatacode },

    { { 2, 0 }, { 0, 0 }, sch_airport, sp_iatacode },
    { { 2, 0 }, { 0, 0 }, sch_airport, sp_ocaocode },

    { { 2, 0 }, { 0, 0 }, sch_alignmentobject, sp_alignmenttype },
    { { 2, 0 }, { 0, 0 }, sch_alignmentobject, sp_educationalframework },
    { { 2, 0 }, { 0, 0 }, sch_alignmentobject, sp_targetdescription },
    { { 2, 0 }, { 0, 0 }, sch_alignmentobject, sp_targetname },
    { { 2, 0 }, { 0, 0 }, sch_alignmentobject, sp_targeturl },

    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_allocateaction, sp_purpose },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_associatedpathophysiology },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_bodylocation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_connectedto },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_diagram },
    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_anatomicalstructure, sp_function },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_partofsystem },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_relatedcondition },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_relatedtherapy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalstructure, sp_substructure },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalsystem, sp_associatedpathophysiology },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalsystem, sp_comprisedof },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalsystem, sp_relatedcondition },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalsystem, sp_relatedstructure },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_anatomicalsystem, sp_relatedtherapy },

    { { 3, 1 }, { 0, 0 }, sch_apartment, sp_numberofrooms },
    { { 3, 1 }, { 0, 0 }, sch_apartment, sp_occupancy },

    { { 6, 0 }, { 0, 0 }, sch_apartmentcomplex, sp_numberofaccommodationunits },
    { { 6, 0 }, { 0, 0 }, sch_apartmentcomplex, sp_numberofavailableaccommodationunits },
    { { 7, 0 }, { 0, 0 }, sch_apartmentcomplex, sp_numberofbedrooms },
    { { 7, 0 }, { 0, 0 }, sch_apartmentcomplex, sp_petsallowed },
    { { 7, 0 }, { 0, 0 }, sch_apartmentcomplex, sp_tourbookingpage },

    { { 2, 0 }, { 0, 0 }, sch_apireference, sp_assemblyversion },
    { { 2, 0 }, { 0, 0 }, sch_apireference, sp_executablelibraryname },
    { { 2, 0 }, { 0, 0 }, sch_apireference, sp_programmingmodel },
    { { 2, 0 }, { 0, 0 }, sch_apireference, sp_targetplatform },

    { { 3, 5 }, { 0, 0 }, sch_archivecomponent, sp_holdingarchive },
    { { 3, 5 }, { 0, 0 }, sch_archivecomponent, sp_itemlocation },

    { { 3, 5 }, { 0, 0 }, sch_archiveorganisation, sp_archiveheld },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_artery, sp_arterialbranch },
    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_artery, sp_source },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_artery, sp_supplyto },

    { { 2, 0 }, { 0, 0 }, sch_article, sp_articlebody },
    { { 2, 0 }, { 0, 0 }, sch_article, sp_articlesection },
    { { 3, 5 }, { 0, 0 }, sch_article, sp_backstory },
    { { 2, 0 }, { 0, 0 }, sch_article, sp_pageend },
    { { 2, 0 }, { 0, 0 }, sch_article, sp_pagestart },
    { { 2, 0 }, { 0, 0 }, sch_article, sp_pagination },
    { { 3, 5 }, { 0, 0 }, sch_article, sp_speakable },
    { { 2, 0 }, { 0, 0 }, sch_article, sp_wordcount },

    { { 2, 0 }, { 0, 0 }, sch_askaction, sp_question },

    { { 2, 0 }, { 0, 0 }, sch_audience, sp_audiencetype },
    { { 2, 0 }, { 0, 0 }, sch_audience, sp_geographicarea },

    { { 3, 5 }, { 0, 0 }, sch_audiobook, sp_duration },
    { { 3, 5 }, { 0, 0 }, sch_audiobook, sp_readby },

    { { 3, 5 }, { 0, 0 }, sch_audioobject, sp_caption },
    { { 2, 0 }, { 0, 0 }, sch_audioobject, sp_transcript },

    { { 2, 0 }, { 0, 0 }, sch_authoriseaction, sp_recipient },

    { { 3, 5 }, { 0, 0 }, sch_bankaccount, sp_accountminimuminflow },
    { { 3, 5 }, { 0, 0 }, sch_bankaccount, sp_accountoverdraftlimit },
    { { 3, 5 }, { 0, 0 }, sch_bankaccount, sp_backaccounttype },

    { { 3, 1 }, { 0, 0 }, sch_beddetails, sp_numberofbeds },
    { { 3, 1 }, { 0, 0 }, sch_beddetails, sp_typeofbed },

    { { 3, 5 }, { 0, 0 }, sch_bedtype, sp_bed },
    { { 3, 5 }, { 0, 0 }, sch_bedtype, sp_typeofbed },

    { { 2, 0 }, { 0, 0 }, sch_blog, sp_blogpost },
    { { 3, 5 }, { 0, 0 }, sch_blog, sp_issn },

    { { 9, 0 }, { 0, 0 }, sch_boattrip, sp_arrivalboatterminal },
    { { 9, 0 }, { 0, 0 }, sch_boattrip, sp_departureboatterminal },

    { { 3, 5 }, { 0, 0 }, sch_book, sp_abridged },
    { { 2, 0 }, { 0, 0 }, sch_book, sp_bookedition },
    { { 2, 0 }, { 0, 0 }, sch_book, sp_bookformat },
    { { 2, 0 }, { 0, 0 }, sch_book, sp_illustrator },
    { { 2, 0 }, { 0, 0 }, sch_book, sp_isbn },
    { { 2, 0 }, { 0, 0 }, sch_book, sp_numberofpages },

    { { 2, 0 }, { 0, 0 }, sch_borrowaction, sp_lender },

    { { 2, 0 }, { 0, 0 }, sch_brand, sp_aggregaterating },

    { { 2, 0 }, { 0, 0 }, sch_brand, sp_logo },
    { { 2, 0 }, { 0, 0 }, sch_brand, sp_review },
    { { 3, 5 }, { 0, 0 }, sch_brand, sp_slogan },

    { { 2, 0 }, { 0, 0 }, sch_broadcastchannel, sp_broadcastchannelid },
    { { 3, 5 }, { 0, 0 }, sch_broadcastchannel, sp_broadcastfrequency },
    { { 2, 0 }, { 0, 0 }, sch_broadcastchannel, sp_broadcastservicetier },
    { { 3, 2 }, { 0, 0 }, sch_broadcastchannel, sp_genre },
    { { 2, 0 }, { 0, 0 }, sch_broadcastchannel, sp_inbroadcastlineup },
    { { 2, 0 }, { 0, 0 }, sch_broadcastchannel, sp_providesbroadcastservice },

    { { 2, 2 }, { 0, 0 }, sch_broadcastevent, sp_broadcastofevent },
    { { 2, 0 }, { 0, 0 }, sch_broadcastevent, sp_islivebroadcast },
    { { 4, 0 }, { 0, 0 }, sch_broadcastevent, sp_subtitlelanguage },
    { { 2, 1, SV_NOT_30 }, { 0, 0 }, sch_broadcastevent, sp_videoformat },

    { { 3, 5 }, { 0, 0 }, sch_broadcastfrequencyspecification, sp_broadcastfrequencyvalue },
    { { 3, 5 }, { 0, 0 }, sch_broadcastfrequencyspecification, sp_broadcastsignalmodulation },
    { { 3, 5 }, { 0, 0 }, sch_broadcastfrequencyspecification, sp_broadcastsubchannel },

    { { 2, 0 }, { 0, 0 }, sch_broadcastservice, sp_broadcastaffiliateof },
    { { 2, 0 }, { 0, 0 }, sch_broadcastservice, sp_broadcastdisplayname },
    { { 2, 0 }, { 0, 0 }, sch_broadcastservice, sp_broadcasttimezone },
    { { 2, 0 }, { 0, 0 }, sch_broadcastservice, sp_broadcaster },
    { { 5, 0 }, { 0, 0 }, sch_broadcastservice, sp_callsign },
    { { 3, 5 }, { 0, 0 }, sch_broadcastservice, sp_hasbroadcastchannel },
    { { 4, 0 }, { 0, 0 }, sch_broadcastservice, sp_inlanguage },
    { { 2, 0 }, { 0, 0 }, sch_broadcastservice, sp_parentservice },
    { { 2, 1, SV_NOT_30 }, { 0, 0 }, sch_broadcastservice, sp_videoformat },

    { { 3, 5 }, { 0, 0 }, sch_busorcoach, sp_acrisscode },
    { { 3, 5 }, { 0, 0 }, sch_busorcoach, sp_roofload },

    { { 2, 0 }, { 0, 0 }, sch_bustrip, sp_arrivalbusstop },
    { { 2, 0 }, { 3, 3 }, sch_bustrip, sp_arrivaltime },
    { { 2, 0 }, { 0, 0 }, sch_bustrip, sp_busname },
    { { 2, 0 }, { 0, 0 }, sch_bustrip, sp_busnumber },
    { { 2, 0 }, { 0, 0 }, sch_bustrip, sp_departurebusstop },
    { { 2, 0 }, { 3, 3 }, sch_bustrip, sp_departuretime },
    { { 2, 0 }, { 3, 3 }, sch_bustrip, sp_provider },

    { { 2, 0 }, { 0, 0 }, sch_businessaudience, sp_numberofemployees },
    { { 2, 0 }, { 0, 0 }, sch_businessaudience, sp_yearlyrevenue },
    { { 2, 0 }, { 0, 0 }, sch_businessaudience, sp_yearsinoperation },

    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdcollectiondate },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdfacilitycounty },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdfacilityid },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumbeds },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumbedsocc },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumc19died },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumc19hopats },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumc19hosppats },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumc19mechventpats },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumc19ofmechventpats },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumc19overflowpats },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumicubeds },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumicubedsocc },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumtotbeds },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumvent },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_cvdnumventuse },
    { { 7, 3 }, { 0, 0 }, sch_cdcpmdrecord, sp_dateposted },

    { { 3, 5 }, { 0, 0 }, sch_car, sp_acrisscode },
    { { 3, 5 }, { 0, 0 }, sch_car, sp_roofload },

    { { 3, 5 }, { 0, 0 }, sch_categorycode, sp_codevalue },
    { { 3, 5 }, { 0, 0 }, sch_categorycode, sp_incodeset },

    { { 3, 5 }, { 0, 0 }, sch_categorycodeset, sp_hascategorycode },

    { { 3, 5 }, { 0, 0 }, sch_chapter, sp_pageend },
    { { 3, 5 }, { 0, 0 }, sch_chapter, sp_pagestart },
    { { 3, 5 }, { 0, 0 }, sch_chapter, sp_pagination },

    { { 2, 0 }, { 0, 0 }, sch_chooseaction, sp_actionoption },

    { { 2, 0 }, { 0, 0 }, sch_civicstructure, sp_openinghours },

    { { 3, 5 }, { 0, 0 }, sch_claim, sp_appearance },
    { { 3, 5 }, { 0, 0 }, sch_claim, sp_firstappearance },

    { { 3, 2 }, { 0, 0 }, sch_claimreview, sp_claimreviewed },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_class, sp_supersededby },

    { { 2, 0 }, { 0, 0 }, sch_clip, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_clip, sp_clipnumber },
    { { 2, 0 }, { 0, 0 }, sch_clip, sp_director },
    { { 3, 5 }, { 0, 0 }, sch_clip, sp_endoffset },
    { { 2, 0 }, { 0, 0 }, sch_clip, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_clip, sp_partofepisode },
    { { 2, 0 }, { 0, 0 }, sch_clip, sp_partofseason },
    { { 2, 0 }, { 0, 0 }, sch_clip, sp_partofseries },
    { { 3, 5 }, { 0, 0 }, sch_clip, sp_startoffset },

    { { 3, 5 }, { 0, 0 }, sch_collection, sp_collectionsize },

    { { 3, 5 }, { 0, 0 }, sch_comicissue, sp_artist },
    { { 3, 5 }, { 0, 0 }, sch_comicissue, sp_colourist },
    { { 3, 5 }, { 0, 0 }, sch_comicissue, sp_inker },
    { { 3, 5 }, { 0, 0 }, sch_comicissue, sp_letterer },
    { { 3, 5 }, { 0, 0 }, sch_comicissue, sp_penciler },
    { { 3, 5 }, { 0, 0 }, sch_comicissue, sp_variantcover },

    { { 3, 5 }, { 0, 0 }, sch_comicstory, sp_artist },
    { { 3, 5 }, { 0, 0 }, sch_comicstory, sp_colourist },
    { { 3, 5 }, { 0, 0 }, sch_comicstory, sp_inker },
    { { 3, 5 }, { 0, 0 }, sch_comicstory, sp_letterer },
    { { 3, 5 }, { 0, 0 }, sch_comicstory, sp_penciler },

    { { 2, 0 }, { 0, 0 }, sch_comment, sp_downvotecount },
    { { 2, 0 }, { 0, 0 }, sch_comment, sp_parentitem },
    { { 2, 0 }, { 0, 0 }, sch_comment, sp_upvotecount },

    { { 2, 0 }, { 0, 0 }, sch_commentaction, sp_resultcomment },

    { { 2, 0 }, { 0, 0 }, sch_communicateaction, sp_about },
    { { 2, 0 }, { 0, 0 }, sch_communicateaction, sp_inlanguage },
    { { 2, 0 }, { 0, 0 }, sch_communicateaction, sp_recipient },

    { { 3, 0 }, { 0, 0 }, sch_compoundpricespecification, sp_pricecomponent },

    { { 3, 5 }, { 0, 0 }, sch_consumeaction, sp_actionaccessibilityrequirement },
    { { 2, 0 }, { 0, 0 }, sch_consumeaction, sp_expectsacceptanceof },

    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_areaserved },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_availablelanguage },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_contactoption },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_contacttype },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_email },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_faxnumber },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_hoursavailable },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_productsupported },
    { { 2, 0 }, { 0, 0 }, sch_contactpoint, sp_telephone },

    { { 2, 0 }, { 0, 0 }, sch_cookaction, sp_foodestablishment },
    { { 2, 0 }, { 0, 0 }, sch_cookaction, sp_foodevent },
    { { 2, 0 }, { 0, 0 }, sch_cookaction, sp_recipe },

    { { 2, 0 }, { 0, 0 }, sch_corporation, sp_tickersymbol },

    { { 3, 4 }, { 0, 0 }, sch_course, sp_coursecode },
    { { 3, 4 }, { 0, 0 }, sch_course, sp_coursepresequisites },
    { { 3, 5 }, { 0, 0 }, sch_course, sp_educationcredentialawarded },
    { { 3, 4 }, { 0, 0 }, sch_course, sp_hascourseinstance },
    { { 6, 0 }, { 0, 0 }, sch_course, sp_numberofcredits },
    { { 3, 9 }, { 0, 0 }, sch_course, sp_occupationalcredentialawarded },

    { { 3, 4 }, { 0, 0 }, sch_courseinstance, sp_coursemode },
    { { 3, 6 }, { 0, 0 }, sch_courseinstance, sp_courseworkload },
    { { 3, 4 }, { 0, 0 }, sch_courseinstance, sp_instructor },

    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_about },
    { { 4, 0 }, { 0, 0 }, sch_creativework, sp_abstract },
    { { 3, 0 }, { 0, 0 }, sch_creativework, sp_accessmode },
    { { 3, 0 }, { 0, 0 }, sch_creativework, sp_accessmodesufficient },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_accessibilityapi },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_accessibilitycontrol },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_accessibilityfeature },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_accessibilityhazard },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_accessibilitysummary },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_accountableperson },
    { { 7, 0 }, { 0, 0 }, sch_creativework, sp_acquirelicensepage },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_aggregaterating },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_alternativeheadline },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_assess },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_associatedmedia },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_audience },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_audio },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_author },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_award },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_character },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_citation },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_comment },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_commentcount },
    { { 3, 8 }, { 0, 0 }, sch_creativework, sp_conditionsofaccess },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_contentlocation },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_contentrating },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_contentreferencetime },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_contributor },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_copyrightholder },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_copyrightyear },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_correction },
    { { 3, 8 }, { 0, 0 }, sch_creativework, sp_creativeworkstatus },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_creator },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_datecreated },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_datemodified },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_datepublished },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_discussionurl },
    { { 8, 0 }, { 0, 0 }, sch_creativework, sp_editeidr },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_editor },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_educationalalignment },
    { { 8, 0 }, { 0, 0 }, sch_creativework, sp_educationallevel },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_educationaluse },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_encoding },
    { { 3, 4 }, { 0, 0 }, sch_creativework, sp_encodingformat },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_exampleofwork },
    { { 3, 3 }, { 0, 0 }, sch_creativework, sp_expires },
    { { 2, 2 }, { 3, 3 }, sch_creativework, sp_fileformat },
    { { 3, 1 }, { 0, 0 }, sch_creativework, sp_funder },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_genre },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_haspart },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_headline },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_inlanguage },
    { { 2, 1 }, { 0, 0 }, sch_creativework, sp_interactionstatistic },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_interactivitytype },
    { { 3, 1 }, { 0, 0 }, sch_creativework, sp_isaccessibleforfree },
    { { 3, 0 }, { 0, 0 }, sch_creativework, sp_isbasedon },
    { { 2, 0 }, { 2, 1 }, sch_creativework, sp_isbasedonurl },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_isfamilyfriendly },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_ispartof },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_keywords },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_learningresourcetype },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_license },
    { { 2, 2 }, { 0, 0 }, sch_creativework, sp_locationcreated },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_mainentity },
    { { 6, 0 }, { 0, 0 }, sch_creativework, sp_maintainer },
    { { 3, 2 }, { 0, 0 }, sch_creativework, sp_material },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_materialextent },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_mentions },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_offers },
    { { 9, 0 }, { 0, 0 }, sch_creativework, sp_pattern },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_position },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_producer },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_provider },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_publication },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_publisher },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_publisherimprint },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_publishingprinciples },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_recordedat },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_releasedevent },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_review },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_schemaversion },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_sddatepublished },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_sdlicense },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_sdpublisher },
    { { 9, 0 }, { 0, 0 }, sch_creativework, sp_size },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_sourceorganisation },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_spatial },
    { { 3, 1 }, { 0, 0 }, sch_creativework, sp_spatialcoverage },
    { { 3, 1 }, { 0, 0 }, sch_creativework, sp_sponsor },
    { { 8, 0 }, { 0, 0 }, sch_creativework, sp_teaches },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_temporal },
    { { 3, 1 }, { 0, 0 }, sch_creativework, sp_temporalcoverage },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_text },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_thumbnailurl },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_timerequired },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_translationofwork },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_translator },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_typicalagerange },
    { { 7, 0 }, { 0, 0 }, sch_creativework, sp_usageinfo },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_version },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_video },
    { { 2, 0 }, { 0, 0 }, sch_creativework, sp_workexample },
    { { 3, 5 }, { 0, 0 }, sch_creativework, sp_worktranslation },

    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_enddate },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_episode },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_numberofepisodes },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_partofseries },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_seasonnumber },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_startdate },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sp_trailer },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sp_enddate },
    { { 3, 3 }, { 0, 0 }, sch_creativeworkseries, sp_issn },
    { { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sp_startdate },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_ddxelement, sp_diagnosis },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_ddxelement, sp_distinguishingsign },

    { { 2, 0 }, { 0, 0 }, sch_datacatalogue, sp_dataset },
    { { 3, 5 }, { 0, 0 }, sch_datacatalogue, sp_measurementtechnique },

    { { 3, 5 }, { 0, 0 }, sch_datadownload, sp_measurementtechnique },

    { { 2, 2 }, { 0, 0 }, sch_datafeed, sp_datafeedelement },

    { { 2, 2 }, { 0, 0 }, sch_datafeeditem, sp_datecreated },
    { { 3, 0 }, { 0, 0 }, sch_datafeeditem, sp_datedeleted },
    { { 2, 2 }, { 0, 0 }, sch_datafeeditem, sp_datemodified },
    { { 2, 2 }, { 0, 0 }, sch_datafeeditem, sp_item },

    { { 2, 0 }, { 3, 0 }, sch_dataset, sp_datasettimeinterval },
    { { 2, 0 }, { 0, 0 }, sch_dataset, sp_distribution },
    { { 2, 0 }, { 0, 0 }, sch_dataset, sp_includeddatacatalog },
    { { 2, 0 }, { 3, 0 }, sch_dataset, sp_spatial },
    { { 3, 3 }, { 0, 0 }, sch_dataset, sp_issn },
    { { 3, 5 }, { 0, 0 }, sch_dataset, sp_measurementtechnique },
    { { 3, 5 }, { 0, 0 }, sch_dataset, sp_variablemeasured },
    { { 3, 5 }, { 0, 0 }, sch_dataset, sp_variablesmeasured },

    { { 2, 0 }, { 0, 0 }, sch_datedmoneyspecification, sp_amount },
    { { 2, 0 }, { 0, 0 }, sch_datedmoneyspecification, sp_currency },
    { { 2, 0 }, { 0, 0 }, sch_datedmoneyspecification, sp_enddate },
    { { 2, 0 }, { 0, 0 }, sch_datedmoneyspecification, sp_startdate },

    { { 8, 0 }, { 0, 0 }, sch_definedregion, sp_addresscountry },
    { { 8, 0 }, { 0, 0 }, sch_definedregion, sp_addressregion },
    { { 8, 0 }, { 0, 0 }, sch_definedregion, sp_postalcode },
    { { 8, 0 }, { 0, 0 }, sch_definedregion, sp_postalcodeprefix },
    { { 8, 0 }, { 0, 0 }, sch_definedregion, sp_postalcoderange },

    { { 3, 5 }, { 0, 0 }, sch_definedterm, sp_indefinedtermset },
    { { 3, 5 }, { 0, 0 }, sch_definedterm, sp_termcode },

    { { 3, 5 }, { 0, 0 }, sch_definedtermset, sp_hasdefinedterm },

    { { 2, 0 }, { 0, 0 }, sch_deliverychargespecification, sp_appliestodeliverymethod },
    { { 2, 2 }, { 0, 0 }, sch_deliverychargespecification, sp_areaserved },
    { { 2, 0 }, { 0, 0 }, sch_deliverychargespecification, sp_eligibleregion },
    { { 2, 0 }, { 0, 0 }, sch_deliverychargespecification, sp_ineligibleregion },

    { { 2, 0 }, { 0, 0 }, sch_deliveryevent, sp_accesscode },
    { { 2, 0 }, { 0, 0 }, sch_deliveryevent, sp_availablefrom },
    { { 2, 0 }, { 0, 0 }, sch_deliveryevent, sp_availablethrough },
    { { 2, 0 }, { 0, 0 }, sch_deliveryevent, sp_hasdeliverymethod },

    { { 8, 0 }, { 0, 0 }, sch_deliverytimesettings, sp_deliverytime },
    { { 9, 0 }, { 0, 0 }, sch_deliverytimesettings, sp_isunlabelledfallback },
    { { 8, 0 }, { 0, 0 }, sch_deliverytimesettings, sp_shippingdestination },
    { { 8, 0 }, { 0, 0 }, sch_deliverytimesettings, sp_transittimelabel },

    { { 2, 0 }, { 0, 0 }, sch_demand, sp_acceptedpaymentmethod },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_advancebookingrequirement },
    { { 3, 0 }, { 0, 0 }, sch_demand, sp_areaserved },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_availability },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_availabilityends },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_availabilitystarts },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_availableatorfrom },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_availabedeliverymethod },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_businessfunction },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_deliveryleadtime },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_eligibilecustomertype },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_eligibleduration },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_eligiblequantity },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_eligibleregion },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_eligibletransactionvolume },
    { { 3, 8 }, { 0, 0 }, sch_demand, sp_gtin },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_gtin12 },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_gtin13 },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_gtin14 },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_gtin8 },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_includesobject },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_ineligibleregion },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_inventorylevel },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_itemcondition },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_itemoffered },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_mpn },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_pricespecification },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_seller },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_serialnumber },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_sku },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_validfrom },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_validthrough },
    { { 2, 0 }, { 0, 0 }, sch_demand, sp_warranty },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_diagnosticlab, sp_availabletest },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_diet, sp_dietfeatures },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_diet, sp_endorsers },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_diet, sp_exportconsiderations },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_diet, sp_overview },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_diet, sp_physiologicalbenefits },
    { { 2, 0 }, { 2, 1 }, sch_diet, sp_proprietaryname },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_diet, sp_risks },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_activeingredient },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_background },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_dosageform },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_isproprietary },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_legalstatus },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_manufacturer },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_maximumintake },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_mechanismofaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_nonpropriatryname },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_recommendedintake },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_safetyconsideration },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_dietarysupplement, sp_targetpopulation },

    { { 3, 0 }, { 0, 0 }, sch_digitaldocument, sp_hasdigitaldocumentpermission },
    { { 3, 0 }, { 0, 0 }, sch_digitaldocumentpermission, sp_grantee },
    { { 3, 0 }, { 0, 0 }, sch_digitaldocumentpermission, sp_permissiontype },

    { { 2, 0 }, { 0, 0 }, sch_donateaction, sp_recipient },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_doseschedule, sp_doseunit },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_doseschedule, sp_dosevalue },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_doseschedule, sp_frequency },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_doseschedule, sp_targetpopulation },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_activeingredient },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_administrationroute },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_alcoholwarning },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_availablestrength },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_breastfeedingwarning },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_clinicalpharamcology },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_cost },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_dosageform },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_doseschedule },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_drugclass },
    { { 3, 5 }, { 0, 0 }, sch_drug, sp_drugunit },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_foodwarning },
    { { 3, 5 }, { 0, 0 }, sch_drug, sp_includedinhealthinsuranceplan },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_interactingdrug },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_isavailablegenerally },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_isproprietary },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_labeldetails },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_legalstatus },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_manufacturer },
    { { 3, 5 }, { 0, 0 }, sch_drug, sp_maximumintake },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_mechanismofaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_nonproprietaryname },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_overdosage },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_pregnancycategory },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_pregnancywarning },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_prescribinginfo },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_prescriptionstatus },
    { { 3, 5 }, { 0, 0 }, sch_drug, sp_proprietaryname },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_relateddrug },
    { { 3, 5 }, { 0, 0 }, sch_drug, sp_rxcui },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drug, sp_warning },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugclass, sp_drug },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugcost, sp_availablelocation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugcost, sp_costcategory },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugcost, sp_costcurrency },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugcost, sp_costorigin },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugcost, sp_costperunit },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugcost, sp_drugunit },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_druglegalstatus, sp_applicablelocation },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugstrength, sp_activeingredient },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugstrength, sp_availablein },
    { { 3, 5 }, { 0, 0 }, sch_drugstrength, sp_maximumintake },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugstrength, sp_strengthunit },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_drugstrength, sp_strengthvalue },

    { { 8, 0 }, { 0, 0 }, sch_educationevent, sp_assess },
    { { 8, 0 }, { 0, 0 }, sch_educationevent, sp_educationallevel },
    { { 8, 0 }, { 0, 0 }, sch_educationevent, sp_teaches },

    { { 2, 0 }, { 0, 0 }, sch_educationalaudience, sp_educationalrole },

    { { 3, 5 }, { 0, 0 }, sch_educationaloccupationalcredential, sp_competencyrequired },
    { { 3, 5 }, { 0, 0 }, sch_educationaloccupationalcredential, sp_credentialcategory },
    { { 3, 5 }, { 0, 0 }, sch_educationaloccupationalcredential, sp_educationallevel },
    { { 3, 5 }, { 0, 0 }, sch_educationaloccupationalcredential, sp_recognisedby },
    { { 3, 5 }, { 0, 0 }, sch_educationaloccupationalcredential, sp_validfor },
    { { 3, 5 }, { 0, 0 }, sch_educationaloccupationalcredential, sp_validin },

    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_applicationdeadline },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_applicationstartdate },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_dayofweek },
    { { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_educationalcredentialawarded },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_educationalprogrammode },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_enddate },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_financialaideligible },
    { { 10, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_hascourse },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_maximumenrollment },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_numberofcredits },
    { { 7, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_occupationalcategory },
    { { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_occupationalcredentialawarded },
    { { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_offers },
    { { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_programprequisites },
    { { 7, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_programtype },
    { { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_provider },
    { { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_salaryuponcompletion },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_startdate },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_termduration },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_termsperyear },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_timeofday },
    { { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_timetocomplete },
    { { 7, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_trainingsalary },
    { { 6, 0 }, { 0, 0 }, sch_educationaloccupationalprogramme, sp_typicalcreditsperterm },

    { { 2, 0 }, { 0, 0 }, sch_educationalorganisation, sp_alumni },

    { { 2, 0 }, { 0, 0 }, sch_employeerole, sp_basesalary },
    { { 2, 0 }, { 0, 0 }, sch_employeerole, sp_salarycurrency },

    { { 2, 0 }, { 0, 0 }, sch_endorseaction, sp_endorsee },

    { { 10, 0 }, { 0, 0 }, sch_energyconsumptiondetails, sp_energyefficiencyscalemax },
    { { 10, 0 }, { 0, 0 }, sch_energyconsumptiondetails, sp_energyefficiencyscalemin },
    { { 10, 0 }, { 0, 0 }, sch_energyconsumptiondetails, sp_hasenergyefficiencycategory },

    { { 3, 5 }, { 0, 0 }, sch_enginespecification, sp_enginedisplacement },
    { { 3, 5 }, { 0, 0 }, sch_enginespecification, sp_enginepower },
    { { 3, 5 }, { 0, 0 }, sch_enginespecification, sp_enginetype },
    { { 2, 0 }, { 0, 0 }, sch_enginespecification, sp_fueltype },
    { { 3, 5 }, { 0, 0 }, sch_enginespecification, sp_torque },

    { { 2, 0 }, { 0, 0 }, sch_entrypoint, sp_actionapplication },
    { { 2, 2 }, { 0, 0 }, sch_entrypoint, sp_actionplatform },
    { { 2, 0 }, { 0, 0 }, sch_entrypoint, sp_contenttype },
    { { 2, 0 }, { 0, 0 }, sch_entrypoint, sp_encodingtype },
    { { 2, 0 }, { 0, 0 }, sch_entrypoint, sp_httpmethod },
    { { 2, 0 }, { 0, 0 }, sch_entrypoint, sp_urltemplate },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_enumeration, sp_suspersededby },

    { { 2, 0 }, { 0, 0 }, sch_episode, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_episode, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_episode, sp_episodenumber },
    { { 2, 0 }, { 0, 0 }, sch_episode, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_episode, sp_partofseason },
    { { 2, 0 }, { 0, 0 }, sch_episode, sp_partofseries },
    { { 2, 0 }, { 0, 0 }, sch_episode, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_episode, sp_trailer },

    { { 3, 1 }, { 0, 0 }, sch_event, sp_about },
    { { 3, 0 }, { 0, 0 }, sch_event, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_aggregaterating },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_attendee },
    { { 3, 1 }, { 0, 0 }, sch_event, sp_audience },
    { { 3, 0 }, { 0, 0 }, sch_event, sp_composer },
    { { 3, 0 }, { 0, 0 }, sch_event, sp_contributor },
    { { 3, 0 }, { 0, 0 }, sch_event, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_doortime },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_duration },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_enddate },
    { { 7, 0 }, { 0, 0 }, sch_event, sp_eventattendancemode },
    { { 6, 0 }, { 0, 0 }, sch_event, sp_eventschedule },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_eventstatus },
    { { 3, 1 }, { 0, 0 }, sch_event, sp_funder },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_inlanguage },
    { { 3, 1 }, { 0, 0 }, sch_event, sp_isaccessibleforfree },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_location },
    { { 3, 1 }, { 0, 0 }, sch_event, sp_maximumattendeecapacity },
    { { 7, 0 }, { 0, 0 }, sch_event, sp_maximumphysicalattendeecapacity },
    { { 7, 0 }, { 0, 0 }, sch_event, sp_maximumvirtualattendeecapacity },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_offers },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_organiser },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_performer },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_previousstartdate },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_recordedin },
    { { 3, 1 }, { 0, 0 }, sch_event, sp_remainingattendeecapacity },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_review },
    { { 3, 0 }, { 0, 0 }, sch_event, sp_sponsor },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_startdate },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_subevent },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_superevent },
    { { 3, 0 }, { 0, 0 }, sch_event, sp_translator },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_typicalagerange },
    { { 3, 0 }, { 0, 0 }, sch_event, sp_workfeatured },
    { { 2, 0 }, { 0, 0 }, sch_event, sp_workperformed },

    { { 3, 5 }, { 0, 0 }, sch_exchangeratespecification, sp_currency },
    { { 3, 5 }, { 0, 0 }, sch_exchangeratespecification, sp_currentexchangerate },
    { { 3, 5 }, { 0, 0 }, sch_exchangeratespecification, sp_exchangeratespread },

    { { 3, 5 }, { 0, 0 }, sch_exerciseaction, sp_diet },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_distance },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_exercisecourse },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseaction, sp_exerciseplan },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseaction, sp_exerciserelateddiet },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseaction, sp_exercisetype },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_fromlocation },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_opponent },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_sportsactivitylocation },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_sportsevent },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_sportsteam },
    { { 2, 0 }, { 0, 0 }, sch_exerciseaction, sp_tolocation },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_activityduration },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_activityfrequency },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_additionalvariable },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_exercisetype },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_intensity },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_repetitions },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_restperiods },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_exerciseplan, sp_workload },

    { { 3, 0 }, { 0, 0 }, sch_financialproduct, sp_annualpercentagerate },
    { { 3, 0 }, { 0, 0 }, sch_financialproduct, sp_feesandcommissionsspecification },
    { { 3, 0 }, { 0, 0 }, sch_financialproduct, sp_interestrate },
    { { 3, 0 }, { 0, 0 }, sch_financialservice, sp_feesandcommissionsspecification },

    { { 2, 0 }, { 0, 0 }, sch_flight, sp_aircraft },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_arrivalairport },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_arrivalgate },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_arrivalterminal },
    { { 2, 0 }, { 3, 3 }, sch_flight, sp_arrivaltime },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_boardingpolicy },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_departureairport },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_departuregate },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_departureterminal },
    { { 2, 0 }, { 3, 3 }, sch_flight, sp_departuretime },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_estimatedflightduration },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_flightdistance },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_flightnumber },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_mealservice },
    { { 2, 0 }, { 3, 3 }, sch_flight, sp_provider },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_seller },
    { { 2, 0 }, { 0, 0 }, sch_flight, sp_webcheckintime },

    { { 2, 0 }, { 0, 0 }, sch_flightreservation, sp_boardinggroup },
    { { 2, 0 }, { 0, 0 }, sch_flightreservation, sp_passengerprioritystatus },
    { { 2, 0 }, { 0, 0 }, sch_flightreservation, sp_passengersequencenumber },
    { { 2, 0 }, { 0, 0 }, sch_flightreservation, sp_securityscreening },

    { { 7, 0 }, { 0, 0 }, sch_floorplan, sp_amenityfeature },
    { { 7, 0 }, { 0, 0 }, sch_floorplan, sp_floorsize },
    { { 6, 0 }, { 0, 0 }, sch_floorplan, sp_isplanforapartment },
    { { 10, 0 }, { 0, 0 }, sch_floorplan, sp_layoutimage },
    { { 6, 0 }, { 0, 0 }, sch_floorplan, sp_numberofaccommodationunits },
    { { 6, 0 }, { 0, 0 }, sch_floorplan, sp_numberofavailableaccommodationunits },
    { { 6, 0 }, { 0, 0 }, sch_floorplan, sp_numberofbathroomstotal },
    { { 7, 0 }, { 0, 0 }, sch_floorplan, sp_numberofbedrooms },
    { { 6, 0 }, { 0, 0 }, sch_floorplan, sp_numberoffullbathrooms },
    { { 6, 0 }, { 0, 0 }, sch_floorplan, sp_numberofpartialbathrooms },
    { { 6, 0 }, { 0, 0 }, sch_floorplan, sp_numberofrooms },
    { { 7, 0 }, { 0, 0 }, sch_floorplan, sp_petsallowed },

    { { 2, 0 }, { 0, 0 }, sch_followaction, sp_followee },

    { { 2, 0 }, { 0, 0 }, sch_foodestablishment, sp_acceptsreservations },
    { { 2, 0 }, { 3, 1 }, sch_foodestablishment, sp_menu },
    { { 3, 2 }, { 0, 0 }, sch_foodestablishment, sp_hasmenu },
    { { 2, 0 }, { 0, 0 }, sch_foodestablishment, sp_servescuisine },
    { { 3, 1 }, { 0, 0 }, sch_foodestablishment, sp_starrating },

    { { 2, 0 }, { 0, 0 }, sch_foodestablishmentreservation, sp_endtime },
    { { 2, 0 }, { 0, 0 }, sch_foodestablishmentreservation, sp_partysize },
    { { 2, 0 }, { 0, 0 }, sch_foodestablishmentreservation, sp_starttime },

    { { 2, 0 }, { 0, 0 }, sch_game, sp_characterattribute },
    { { 2, 0 }, { 0, 0 }, sch_game, sp_gameitem },
    { { 2, 0 }, { 0, 0 }, sch_game, sp_gamelocation },
    { { 2, 0 }, { 0, 0 }, sch_game, sp_numberofplayers },
    { { 2, 0 }, { 0, 0 }, sch_game, sp_quest },

    { { 2, 0 }, { 0, 0 }, sch_gameserver, sp_game },
    { { 2, 0 }, { 0, 0 }, sch_gameserver, sp_playersonline },
    { { 2, 0 }, { 0, 0 }, sch_gameserver, sp_serverstatus },

    { { 2, 2 }, { 0, 0 }, sch_geocircle, sp_geomidpoint },
    { { 2, 2 }, { 0, 0 }, sch_geocircle, sp_georadius },

    { { 3, 0 }, { 0, 0 }, sch_geocoordinates, sp_address },
    { { 2, 2 }, { 0, 0 }, sch_geocoordinates, sp_addresscountry },
    { { 2, 0 }, { 0, 0 }, sch_geocoordinates, sp_elevation },
    { { 2, 0 }, { 0, 0 }, sch_geocoordinates, sp_latitude },
    { { 2, 0 }, { 0, 0 }, sch_geocoordinates, sp_longitude },
    { { 2, 2 }, { 0, 0 }, sch_geocoordinates, sp_postalcode },

    { { 3, 0 }, { 0, 0 }, sch_geoshape, sp_address },
    { { 2, 2 }, { 0, 0 }, sch_geoshape, sp_addresscountry },
    { { 2, 0 }, { 0, 0 }, sch_geoshape, sp_box },
    { { 2, 0 }, { 0, 0 }, sch_geoshape, sp_circle },
    { { 2, 0 }, { 0, 0 }, sch_geoshape, sp_elevation },
    { { 2, 0 }, { 0, 0 }, sch_geoshape, sp_line },
    { { 2, 0 }, { 0, 0 }, sch_geoshape, sp_polygon },
    { { 2, 2 }, { 0, 0 }, sch_geoshape, sp_postalcode },

    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geocontains },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geocoveredby },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geocovers },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geocrosses },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geodisjoint },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geoequals },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geointersects },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geooverlaps },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geotouches },
    { { 3, 5 }, { 0, 0 }, sch_geospatialgeometry, sp_geowithin },

    { { 2, 0 }, { 0, 0 }, sch_giveaction, sp_recipient },

    { { 7, 4 }, { 0, 0 }, sch_governmentservice, sp_jurisdiction },
    { { 2, 0 }, { 0, 0 }, sch_governmentservice, sp_serviceoperator },

    { { 3, 5 }, { 0, 0 }, sch_grant, sp_fundeditem },
    { { 3, 5 }, { 0, 0 }, sch_grant, sp_sponsor },

    { { 5, 0 }, { 0, 0 }, sch_guide, sp_reviewaspect },

    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_benefitssummaryurl },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_contactpoint },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_healthplandrugoption },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_healthplandrugtier },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_healthplanid },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_healthplanmarketingurl },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_includeshealthplanformulary },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_includeshealthplannetwork },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthinsuranceplan, sp_useshealthplanidstandard },

    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplancostsharingspecification, sp_healthplancoinsuranceoption },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplancostsharingspecification, sp_healthplancoinsurancerate },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplancostsharingspecification, sp_healthplancopay },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplancostsharingspecification, sp_healthplancopayoption },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplancostsharingspecification, sp_healthplanpharmacycategory },

    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplanformulary, sp_healthplancostsharing },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplanformulary, sp_healthplandrugtier },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplanformulary, sp_offersprescriptionbymail },

    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplannetwork, sp_healthplancostsharing },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplannetwork, sp_healthplannetworkid },
    { { 3, 5 }, { 0, 0 }, sch_dystopianhealthplannetwork, sp_healthplannetworktier },

    { { 5, 0 }, { 0, 0 }, sch_healthtopiccontent, sp_hashealthaspect },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_hospital, sp_availableservice },
    { { 7, 3 }, { 0, 0 }, sch_hospital, sp_healthcarereportingdata },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_hospital, sp_medicalspeciality },

    { { 3, 1 }, { 0, 0 }, sch_hotelroom, sp_bed },
    { { 3, 1 }, { 0, 0 }, sch_hotelroom, sp_occupancy },

    { { 3, 1 }, { 0, 0 }, sch_house, sp_numberofrooms },

    { { 3, 3 }, { 0, 0 }, sch_howto, sp_estimatedcost },
    { { 3, 3 }, { 0, 0 }, sch_howto, sp_performtime },
    { { 3, 3 }, { 0, 0 }, sch_howto, sp_preptime },
    { { 3, 4 }, { 0, 0 }, sch_howto, sp_step },
    { { 3, 3 }, { 3, 3 }, sch_howto, sp_steps },
    { { 3, 3 }, { 0, 0 }, sch_howto, sp_supply },
    { { 3, 3 }, { 0, 0 }, sch_howto, sp_tool },
    { { 3, 3 }, { 0, 0 }, sch_howto, sp_totaltime },
    { { 3, 3 }, { 0, 0 }, sch_howto, sp_yield },

    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_aftermedia },
    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_beforemedia },
    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_duringmedia },
    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_performtime },
    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_preptime },
    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_supply },
    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_tool },
    { { 3, 3 }, { 0, 0 }, sch_howtodirection, sp_totaltime },

    { { 3, 3 }, { 0, 0 }, sch_howtoitem, sp_requiredquantity },

    { { 3, 3 }, { 3, 3 }, sch_howtosection, sp_steps },
    { { 3, 4 }, { 0, 0 }, sch_howtosection, sp_step },

    { { 3, 3 }, { 0, 0 }, sch_howtosupply, sp_estimatedcost },

    { { 2, 0 }, { 0, 0 }, sch_imageobject, sp_caption },
    { { 2, 0 }, { 0, 0 }, sch_imageobject, sp_exifdata },
    { { 2, 0 }, { 0, 0 }, sch_imageobject, sp_representativeofpage },
    { { 2, 0 }, { 0, 0 }, sch_imageobject, sp_thumbnail },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_imagingtest, sp_imagingtechnique },

    { { 2, 0 }, { 0, 0 }, sch_individualproduct, sp_serialnumber },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_infectiousdisease, sp_infectiousagent },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_infectiousdisease, sp_infectiousagentclass },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_infectiousdisease, sp_transmissionmethod },

    { { 2, 0 }, { 0, 0 }, sch_informaction, sp_event },

    { { 2, 0 }, { 0, 0 }, sch_insertaction, sp_tolocation },

    { { 2, 0 }, { 0, 0 }, sch_interactioncounter, sp_interactionservice },
    { { 2, 0 }, { 0, 0 }, sch_interactioncounter, sp_interactiontype },
    { { 2, 0 }, { 0, 0 }, sch_interactioncounter, sp_userinteractioncount },

    { { 3, 0 }, { 0, 0 }, sch_investmentordeposit, sp_amount },

    { { 2, 0 }, { 0, 0 }, sch_inviteaction, sp_event },

    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_accountid },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_billingperiod },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_broker },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_category },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_confirmationnumber },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_customer },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_minimumpaymentdue },
    { { 2, 0 }, { 2, 0 }, sch_invoice, sp_paymentdue },
    { { 2, 1 }, { 0, 0 }, sch_invoice, sp_paymentduedate },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_paymentmethod },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_paymentmethodid },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_paymentstatus },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_provider },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_referencesorder },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_scheduledpaymentdate },
    { { 2, 0 }, { 0, 0 }, sch_invoice, sp_totalpaymentdue },

    { { 2, 0 }, { 0, 0 }, sch_itemlist, sp_itemlistelement },
    { { 2, 0 }, { 0, 0 }, sch_itemlist, sp_itemlistorder },
    { { 2, 0 }, { 0, 0 }, sch_itemlist, sp_numberofitems },

    { { 3, 5 }, { 0, 0 }, sch_jobposting, sp_applicantlocationrequirements },
    { { 6, 0 }, { 0, 0 }, sch_jobposting, sp_applicantcontact },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_basesalary },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_dateposted },
    { { 3, 5 }, { 0, 0 }, sch_jobposting, sp_educationrequirements },
    { { 8, 0 }, { 0, 0 }, sch_jobposting, sp_eligibilitytoworkrequirement },
    { { 6, 0 }, { 0, 0 }, sch_jobposting, sp_employeroverview },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_employmenttype },
    { { 4, 0 }, { 0, 0 }, sch_jobposting, sp_employmentunit },
    { { 3, 6 }, { 0, 0 }, sch_jobposting, sp_estimatedsalary },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_expeiencerequirements },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_hiringorganization },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_incentivecompensation },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_industry },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_jobbenefits },
    { { 3, 8 }, { 0, 0 }, sch_jobposting, sp_jobimmediatestart },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_joblocation },
    { { 3, 5 }, { 0, 0 }, sch_jobposting, sp_joblocationtype },
    { { 3, 8 }, { 0, 0 }, sch_jobposting, sp_jobstartdate },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_occupationalcategory },
    { { 6, 0 }, { 0, 0 }, sch_jobposting, sp_physicalrequirement },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_qualifications },
    { { 3, 5 }, { 0, 0 }, sch_jobposting, sp_relevantoccupation },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_responsibilities },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_salarycurrency },
    { { 6, 0 }, { 0, 0 }, sch_jobposting, sp_securityclearancerequirement },
    { { 6, 0 }, { 0, 0 }, sch_jobposting, sp_sensoryclearancerequirement },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_skills },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_specialcommitments },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_title },
    { { 4, 0 }, { 0, 0 }, sch_jobposting, sp_totaljobopenings },
    { { 3, 0 }, { 0, 0 }, sch_jobposting, sp_validthrough },
    { { 2, 0 }, { 0, 0 }, sch_jobposting, sp_workhours },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_joint, sp_biomechanicalclass },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_joint, sp_funcionalclass },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_joint, sp_structuralclass },

    { { 9, 0 }, { 0, 0 }, sch_learningresource, sp_assesses },
    { { 9, 0 }, { 0, 0 }, sch_learningresource, sp_educationalalignment },
    { { 9, 0 }, { 0, 0 }, sch_learningresource, sp_educationallevel },
    { { 9, 0 }, { 0, 0 }, sch_learningresource, sp_educationaluse },
    { { 10, 0 }, { 0, 0 }, sch_learningresource, sp_learningresourcetype },
    { { 9, 0 }, { 0, 0 }, sch_learningresource, sp_teaches },

    { { 7, 4 }, { 0, 0 }, sch_legislation, sp_jurisdiction },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationapplies },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationchanges },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationconsolidates },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationdate },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationdateversion },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationidentifier },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationjurisdiction },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationlegalforce },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationpassedby },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationresponsible },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationtransposes },
    { { 3, 5 }, { 0, 0 }, sch_legislation, sp_legislationtype },
    { { 3, 5 }, { 0, 0 }, sch_legislationobject, sp_legislationlegalvalue },

    { { 3, 5 }, { 0, 0 }, sch_linkrole, sp_inlanguage },
    { { 3, 5 }, { 0, 0 }, sch_linkrole, sp_linkrelationship },

    { { 2, 0 }, { 0, 0 }, sch_listitem, sp_item },
    { { 2, 0 }, { 0, 0 }, sch_listitem, sp_nextitem },
    { { 2, 0 }, { 0, 0 }, sch_listitem, sp_position },
    { { 2, 0 }, { 0, 0 }, sch_listitem, sp_previousitem },

    { { 2, 1 }, { 0, 0 }, sch_liveblogposting, sp_coverageendtime },
    { { 2, 1 }, { 0, 0 }, sch_liveblogposting, sp_coveragestarttime },
    { { 2, 1 }, { 0, 0 }, sch_liveblogposting, sp_liveblogupdate },

    { { 3, 0 }, { 0, 0 }, sch_loanorcredit, sp_amount },
    { { 3, 5 }, { 0, 0 }, sch_loanorcredit, sp_currency },
    { { 3, 5 }, { 0, 0 }, sch_loanorcredit, sp_graceperiod },
    { { 3, 5 }, { 0, 0 }, sch_loanorcredit, sp_loanrepaymentform },
    { { 3, 0 }, { 0, 0 }, sch_loanorcredit, sp_loanterm },
    { { 3, 5 }, { 0, 0 }, sch_loanorcredit, sp_loantype },
    { { 3, 5 }, { 0, 0 }, sch_loanorcredit, sp_recourseloan },
    { { 3, 5 }, { 0, 0 }, sch_loanorcredit, sp_renegotiableloan },
    { { 3, 0 }, { 0, 0 }, sch_loanorcredit, sp_requiredcollateral },

    { { 2, 0 }, { 0, 0 }, sch_localbusiness, sp_currenciesaccepted },
    { { 2, 0 }, { 0, 0 }, sch_localbusiness, sp_openinghours },
    { { 2, 0 }, { 2, 0 }, sch_localbusiness, sp_parentorganisation },
    { { 2, 0 }, { 0, 0 }, sch_localbusiness, sp_paymentaccepted },
    { { 2, 0 }, { 0, 0 }, sch_localbusiness, sp_pricerange },

    { { 3, 1 }, { 0, 0 }, sch_locationfeaturespecification, sp_hoursavailable },
    { { 3, 1 }, { 0, 0 }, sch_locationfeaturespecification, sp_validfrom },
    { { 3, 1 }, { 0, 0 }, sch_locationfeaturespecification, sp_validthrough },

    { { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sp_amenityfeature },
    { { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sp_audience },
    { { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sp_availablelanguage },
    { { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sp_checkintime },
    { { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sp_checkouttime },
    { { 3, 6 }, { 0, 0 }, sch_lodgingbusiness, sp_numberofrooms },
    { { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sp_petsallowed },
    { { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sp_starrating },

    { { 2, 0 }, { 0, 0 }, sch_lodgingreservation, sp_checkintime },
    { { 2, 0 }, { 0, 0 }, sch_lodgingreservation, sp_checkouttime },
    { { 2, 0 }, { 0, 0 }, sch_lodgingreservation, sp_lodgingunitdescription },
    { { 2, 0 }, { 0, 0 }, sch_lodgingreservation, sp_lodgingunittype },
    { { 2, 0 }, { 0, 0 }, sch_lodgingreservation, sp_numadults },
    { { 2, 0 }, { 0, 0 }, sch_lodgingreservation, sp_numchildren },

    { { 2, 0 }, { 0, 0 }, sch_loseaction, sp_winner },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_lymphaticvessel, sp_originatesfrom },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_lymphaticvessel, sp_regiondrained },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_lymphaticvessel, sp_runsto },

    { { 2, 0 }, { 0, 0 }, sch_map, sp_maptype },

    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_associatedarticle },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_bitrate },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_contentsize },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_contenturl },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_duration, },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_embedurl },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_encodescreativework },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_encodingformat },
    { { 3, 5 }, { 0, 0 }, sch_mediaobject, sp_endtime },
    { { 2, 0 }, { 3, 2 }, sch_mediaobject, sp_expires },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_height },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_playertype },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_regionsallowed },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_requiressubscription },
    { { 3, 5 }, { 0, 0 }, sch_mediaobject, sp_starttime },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_uploaddate },
    { { 2, 0 }, { 0, 0 }, sch_mediaobject, sp_width },

    { { 7, 0 }, { 0, 0 }, sch_mediareview, sp_mediaauthenticitycategory },

    { { 3, 5 }, { 0, 0 }, sch_mediasubscription, sp_authenticator },
    { { 3, 5 }, { 0, 0 }, sch_mediasubscription, sp_expectsacceptanceof },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcause, sp_causeof },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalclinic, sp_availableservice },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalclinic, sp_medicalspeciality },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcode, sp_codevalue },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcode, sp_codingsystem },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_associatedanatomy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_cause },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_differentialdiagnosis },
    { { 3, 5 }, { 0, 0 }, sch_medicalcondition, sp_drug },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_epidemiology },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_expectedprognosis },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_naturalprogression },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_pathophysiology },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_possiblecomplication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_possibletreatment },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_primaryprevention },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_riskfactor },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_secondaryprevention },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_signorsymptom },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_stage },
    { { 3, 5 }, { 0, 0 }, sch_medicalcondition, sp_status },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_subtype },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalcondition, sp_typicaltest },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalconditionstage, sp_stageasnumber },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalconditionstage, sp_substagesuffix },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_adverseoutcome },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_contraindication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_indication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_postop },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_preop },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_procedure },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_purpose },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaldevice, sp_seriousadverseoutcome },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalentity, sp_code },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalentity, sp_guideline },
    { { 3, 5 }, { 0, 0 }, sch_medicalentity, sp_legalstatus },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalentity, sp_medicinesystem },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalentity, sp_recognisingauthority },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalentity, sp_relevantspeciality },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalentity, sp_study },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalguideline, sp_evidencelevel },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalguideline, sp_evidenceorigin },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalguideline, sp_guidelinedate },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalguideline, sp_guidelinesubject },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalguidelinerecommendation, sp_recommendationstrength },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalobservationalstudy, sp_studydesign },

    { { 3, 5 }, { 0, 0 }, sch_medicalorganisation, sp_dystopianhealthplannetworkid },
    { { 3, 5 }, { 0, 0 }, sch_medicalorganisation, sp_isacceptingnewpatients },
    { { 3, 5 }, { 0, 0 }, sch_medicalorganisation, sp_medicalspeciality },

    { { 3, 5 }, { 0, 0 }, sch_medicalprocedure, sp_bodylocation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalprocedure, sp_followup },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalprocedure, sp_howperformed },
    { { 3, 5 }, { 6, 0 }, sch_medicalprocedure, sp_indication },
    { { 3, 5 }, { 6, 0 }, sch_medicalprocedure, sp_outcome },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalprocedure, sp_preparation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalprocedure, sp_proceduretype },
    { { 3, 5 }, { 0, 0 }, sch_medicalprocedure, sp_status },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalriskestimator, sp_estimatesriskof },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalriskestimator, sp_includedriskfactor },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalriskfactor, sp_increasesriskof },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalriskscore, sp_algorithm },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalscholarlyarticle, sp_publicationtype },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalsign, sp_identifyingexam },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalsign, sp_identifyingtest },

    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_medicalsignorsymptom, sp_cause },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalsignorsymptom, sp_possibletreatment },

    { { 3, 5 }, { 0, 0 }, sch_medicalstudy, sp_healthcondition },
    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_medicalstudy, sp_outcome },
    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_medicalstudy, sp_population },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalstudy, sp_sponsor },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalstudy, sp_status },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalstudy, sp_studylocation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicalstudy, sp_studysubject },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltest, sp_affectedby },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltest, sp_normalrange },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltest, sp_signdetected },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltest, sp_usedtodiagnose },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltest, sp_usesdevice },

    { { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sp_adverseoutcome },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltherapy, sp_contraindication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltherapy, sp_duplicatetherapy },
    { { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sp_indication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltherapy, sp_seriousadverseoutcome },

    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_medicaltrial, sp_phase },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_medicaltrial, sp_trialdesign },

    { { 2, 0 }, { 2, 1 }, sch_medicalwebpage, sp_aspect },
    { { 9, 0 }, { 0, 0 }, sch_medicalwebpage, sp_medicalaudience },

    { { 3, 3 }, { 0, 0 }, sch_menu, sp_hasmenuitem },
    { { 3, 3 }, { 0, 0 }, sch_menu, sp_hasmenusection },

    { { 3, 5 }, { 0, 0 }, sch_menuitem, sp_menuaddon },
    { { 3, 3 }, { 0, 0 }, sch_menuitem, sp_nutrition },
    { { 3, 3 }, { 0, 0 }, sch_menuitem, sp_offers },
    { { 3, 3 }, { 0, 0 }, sch_menuitem, sp_suitablefordiet },

    { { 3, 3 }, { 0, 0 }, sch_menusection, sp_hasmenuitem },
    { { 3, 3 }, { 0, 0 }, sch_menusection, sp_hasmenusection },

    { { 6, 0 }, { 0, 0 }, sch_merchantreturnpolicy, sp_instorereturnsoffered },
    { { 6, 0 }, { 0, 0 }, sch_merchantreturnpolicy, sp_merchantreturndays },
    { { 6, 0 }, { 0, 0 }, sch_merchantreturnpolicy, sp_merchantreturnlink },
    { { 6, 0 }, { 0, 0 }, sch_merchantreturnpolicy, sp_refundtype },
    { { 6, 0 }, { 0, 0 }, sch_merchantreturnpolicy, sp_returnfees },
    { { 6, 0 }, { 0, 0 }, sch_merchantreturnpolicy, sp_returnpolicycategory },

    { { 2, 0 }, { 0, 0 }, sch_mobileapplication, sp_carrierrequirements },

    { { 3, 3 }, { 0, 0 }, sch_message, sp_bccrecipient },
    { { 3, 3 }, { 0, 0 }, sch_message, sp_ccrecipient },
    { { 3, 0 }, { 0, 0 }, sch_message, sp_dateread },
    { { 3, 0 }, { 0, 0 }, sch_message, sp_datereceived },
    { { 3, 0 }, { 0, 0 }, sch_message, sp_datesent },
    { { 3, 0 }, { 0, 0 }, sch_message, sp_messageattachment },
    { { 3, 0 }, { 0, 0 }, sch_message, sp_recipient },
    { { 3, 0 }, { 0, 0 }, sch_message, sp_sender },
    { { 3, 3 }, { 0, 0 }, sch_message, sp_torecipient },

    { { 3, 0 }, { 0, 0 }, sch_monetaryamount, sp_currency },
    { { 3, 0 }, { 0, 0 }, sch_monetaryamount, sp_maxvalue },
    { { 3, 0 }, { 0, 0 }, sch_monetaryamount, sp_minvalue },
    { { 3, 0 }, { 0, 0 }, sch_monetaryamount, sp_validfrom },
    { { 3, 0 }, { 0, 0 }, sch_monetaryamount, sp_validthrough },
    { { 3, 0 }, { 0, 0 }, sch_monetaryamount, sp_value },

    { { 3, 5 }, { 0, 0 }, sch_monetaryamountdistribution, sp_currency },

    { { 3, 5 }, { 0, 0 }, sch_monetarygrant, sp_amount },
    { { 3, 5 }, { 0, 0 }, sch_monetarygrant, sp_funder },

    { { 3, 5 }, { 0, 0 }, sch_moneytransfer, sp_amount },
    { { 3, 5 }, { 0, 0 }, sch_moneytransfer, sp_beneficiarybank },

    { { 3, 5 }, { 0, 0 }, sch_mortgageloan, sp_domiciledmortgage },
    { { 3, 5 }, { 0, 0 }, sch_mortgageloan, sp_loanmortgagamandateamount },

    { { 2, 0 }, { 0, 0 }, sch_moveaction, sp_fromlocation },
    { { 2, 0 }, { 0, 0 }, sch_moveaction, sp_tolocation },

    { { 2, 0 }, { 0, 0 }, sch_movie, sp_actor },
    { { 2, 2 }, { 0, 0 }, sch_movie, sp_countryoforigin },
    { { 2, 0 }, { 0, 0 }, sch_movie, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_movie, sp_duration },
    { { 2, 0 }, { 0, 0 }, sch_movie, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_movie, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_movie, sp_subtitlelanguage },
    { { 8, 0 }, { 0, 0 }, sch_movie, sp_titleeidr },
    { { 2, 0 }, { 0, 0 }, sch_movie, sp_trailer },

    { { 2, 0 }, { 0, 0 }, sch_movieseries, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_movieseries, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_movieseries, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_movieseries, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_movieseries, sp_trailer },

    { { 2, 0 }, { 0, 0 }, sch_movietheatre, sp_screencount },

    { { 3, 5 }, { 0, 0 }, sch_muscle, sp_action },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_muscle, sp_antagonist },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_muscle, sp_bloodsupply },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_muscle, sp_insertion },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_muscle, sp_muscleaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_muscle, sp_nerve, },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_muscle, sp_origin },

    { { 2, 0 }, { 0, 0 }, sch_musicalbum, sp_albumproductiontype },
    { { 2, 0 }, { 0, 0 }, sch_musicalbum, sp_albumrelease },
    { { 2, 0 }, { 0, 0 }, sch_musicalbum, sp_albumreleasetype },
    { { 2, 0 }, { 0, 0 }, sch_musicalbum, sp_byartist },

    { { 2, 0 }, { 0, 0 }, sch_musicgroup, sp_album },
    { { 2, 0 }, { 0, 0 }, sch_musicgroup, sp_genre },
    { { 2, 0 }, { 0, 0 }, sch_musicgroup, sp_track },

    { { 2, 0 }, { 0, 0 }, sch_musicplaylist, sp_numtracks },
    { { 2, 0 }, { 0, 0 }, sch_musicplaylist, sp_track },

    { { 2, 0 }, { 0, 0 }, sch_musicrecording, sp_byartist },
    { { 2, 0 }, { 0, 0 }, sch_musicrecording, sp_duration },
    { { 2, 0 }, { 0, 0 }, sch_musicrecording, sp_inalbum },
    { { 2, 0 }, { 0, 0 }, sch_musicrecording, sp_inplaylist },
    { { 2, 0 }, { 0, 0 }, sch_musicrecording, sp_isrccode },
    { { 2, 0 }, { 0, 0 }, sch_musicrecording, sp_recordingof },

    { { 2, 0 }, { 0, 0 }, sch_musicrelease, sp_cataloguenumber },
    { { 2, 0 }, { 0, 0 }, sch_musicrelease, sp_creditedto },
    { { 2, 0 }, { 0, 0 }, sch_musicrelease, sp_duration },
    { { 2, 0 }, { 0, 0 }, sch_musicrelease, sp_musicreleaseformat },
    { { 2, 0 }, { 0, 0 }, sch_musicrelease, sp_recordlabel },
    { { 2, 0 }, { 0, 0 }, sch_musicrelease, sp_releaseof },

    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_composer },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_firstperformance },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_includedcomposition },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_iswccode },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_lyricist },
    { { 2, 1 }, { 0, 0 }, sch_musiccomposition, sp_lyrics },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_musicarrangement },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_musiccompositionform },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_musicalkey },
    { { 2, 0 }, { 0, 0 }, sch_musiccomposition, sp_recordedas },

    { { 2, 0 }, { 0, 0 }, sch_nerve, sp_branch },
    { { 2, 0 }, { 0, 0 }, sch_nerve, sp_nervemotor },
    { { 2, 0 }, { 0, 0 }, sch_nerve, sp_sensoryunit },
    { { 2, 0 }, { 0, 0 }, sch_nerve, sp_sourcedfrom },

    { { 2, 0 }, { 0, 0 }, sch_newsarticle, sp_dateline },
    { { 2, 0 }, { 0, 0 }, sch_newsarticle, sp_printcolumn },
    { { 2, 0 }, { 0, 0 }, sch_newsarticle, sp_printedition },
    { { 2, 0 }, { 0, 0 }, sch_newsarticle, sp_printpage },
    { { 2, 0 }, { 0, 0 }, sch_newsarticle, sp_printsection },

    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_actionablefeedbackpolicy },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_correctionspolicy },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_diversitypolicy },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_diversitystaffingreport },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_ethicspolicy },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_masthead },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_missioncoverageprioritiespolicy },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_nobylinespolicy },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_ownershipfundinginfo },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_unnamedsourcespolicy },
    { { 3, 5 }, { 0, 0 }, sch_newsmediaorganisation, sp_verificationfactcheckingpolicy },

    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_calories },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_carbohydratecontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_cholesterolcontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_fatcontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_fibrecontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_proteincontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_saturatedfatcontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_servingsize },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_sodiumcontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_sugarcontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_transfatcontent },
    { { 2, 0 }, { 0, 0 }, sch_nutritioninformation, sp_unsaturatedfatcontent },

    { { 3, 9 }, { 0, 0 }, sch_observation, sp_marginoferror },
    { { 3, 9 }, { 0, 0 }, sch_observation, sp_measuredproperty },
    { { 3, 9 }, { 0, 0 }, sch_observation, sp_measuredvalue },
    { { 3, 9 }, { 0, 0 }, sch_observation, sp_observationdate },
    { { 3, 9 }, { 0, 0 }, sch_observation, sp_observednode },

    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_educationrequirements },
    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_estimatedsalary },
    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_experiencerequirements },
    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_occupationlocation },
    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_occupationalcategory },
    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_qualifications },
    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_responsibilities },
    { { 3, 5 }, { 0, 0 }, sch_occupation, sp_skills },

    { { 2, 0 }, { 0, 0 }, sch_offer, sp_acceptedpaymentmethod },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_addon },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_advancebookingrequirement },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_aggregaterating },
    { { 2, 2 }, { 0, 0 }, sch_offer, sp_areaserved },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_availability },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_availabilityends },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_availabilitystarts },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_availableatorfrom },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_availabledeliverymethod },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_businessfunction },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_category },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_deliveryleadtime },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_eligiblecustomertype },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_eligibleduration },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_eligiblequantity },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_eligibleregion },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_eligibletransactionvolume },
    { { 3, 8 }, { 0, 0 }, sch_offer, sp_gtin },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_gtin12 },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_gtin13 },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_gtin14 },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_gtin8 },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_includesobject },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_ineligibleregion },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_inventorylevel },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_itemcondition },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_itemoffered },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_mpn },
    { { 2, 2 }, { 0, 0 }, sch_offer, sp_offeredby },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_price },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_pricecurrency },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_pricespecification },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_pricevaliduntil },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_review },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_seller },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_serialnumber },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_sku },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_validfrom },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_validthrough },
    { { 2, 0 }, { 0, 0 }, sch_offer, sp_warranty },

    { { 8, 0 }, { 0, 0 }, sch_offershippingdetails, sp_deliverytime },
    { { 8, 0 }, { 0, 0 }, sch_offershippingdetails, sp_doesnotship },
    { { 7, 2 }, { 0, 0 }, sch_offershippingdetails, sp_shippingdestination },
    { { 8, 0 }, { 0, 0 }, sch_offershippingdetails, sp_shippinglabel },
    { { 8, 0 }, { 0, 0 }, sch_offershippingdetails, sp_shippingrate },
    { { 8, 0 }, { 0, 0 }, sch_offershippingdetails, sp_shippingsettingslink },
    { { 8, 0 }, { 0, 0 }, sch_offershippingdetails, sp_transittimelabel },

    { { 2, 0 }, { 0, 0 }, sch_openinghoursspecification, sp_closes },
    { { 2, 0 }, { 0, 0 }, sch_openinghoursspecification, sp_dayofweek },
    { { 2, 0 }, { 0, 0 }, sch_openinghoursspecification, sp_opens },
    { { 2, 0 }, { 0, 0 }, sch_openinghoursspecification, sp_validfrom },
    { { 2, 0 }, { 0, 0 }, sch_openinghoursspecification, sp_validthrough },

    { { 2, 0 }, { 0, 0 }, sch_order, sp_acceptedoffer },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_billingaddress },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_broker },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_confirmationnumber },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_customer },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_discount },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_discountcode },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_discountcurrency },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_isgift },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_orderdate },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_orderdelivery },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_ordernumber },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_orderstatus },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_ordereditem },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_partofinvoice },
    { { 2, 0 }, { 2, 0 }, sch_order, sp_paymentdue },
    { { 2, 1 }, { 0, 0 }, sch_order, sp_paymentduedate },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_paymentmethod },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_paymentmethodid },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_paymenturl },
    { { 2, 0 }, { 0, 0 }, sch_order, sp_seller },

    { { 2, 0 }, { 0, 0 }, sch_orderaction, sp_deliverymethod },

    { { 2, 0 }, { 0, 0 }, sch_orderitem, sp_orderdelivery },
    { { 2, 0 }, { 0, 0 }, sch_orderitem, sp_orderitemnumber },
    { { 2, 0 }, { 0, 0 }, sch_orderitem, sp_orderitemstatus  },
    { { 2, 0 }, { 0, 0 }, sch_orderitem, sp_orderquantity  },
    { { 2, 0 }, { 0, 0 }, sch_orderitem, sp_ordereditem  },

    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_actionablefeedbackpolicy },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_address },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_aggregaterating },
    { { 2, 2 }, { 0, 0 }, sch_organisation, sp_alumni },
    { { 3, 0 }, { 0, 0 }, sch_organisation, sp_areaserved },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_award },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_brand },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_contactpoint },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_correctionspolicy },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_department },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_dissolutiondate },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_diversitypolicy },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_diversitystaffingreport },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_duns },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_email },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_employee },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_ethicspolicy },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_event },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_faxnumber },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_founder },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_foundingdate },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_foundinglocation },
    { { 3, 1 }, { 0, 0 }, sch_organisation, sp_funder },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_globallocationnumber },
    { { 3, 9 }, { 0, 0 }, sch_organisation, sp_hascredential },
    { { 6, 0 }, { 0, 0 }, sch_organisation, sp_hasmerchantreturnpolicy },
    { { 2, 2 }, { 0, 0 }, sch_organisation, sp_hasoffercatalogue },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_haspos },
    { { 3, 8 }, { 5, 0 }, sch_organisation, sp_hasproductreturnpolicy },
    { { 6, 0 }, { 0, 0 }, sch_organisation, sp_interactionstatistic },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_isicv4 },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_knowsabout },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_knowslanguage },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_legalname },
    { { 3, 0 }, { 0, 0 }, sch_organisation, sp_leicode },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_location },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_logo },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_makesoffer },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_member },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_memberof },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_naics },
    { { 8, 0 }, { 0, 0 }, sch_organisation, sp_nonprofitstatus },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_numberofemployees },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_ownershipfundinginfo },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_owns },
    { { 2, 1 }, { 0, 0 }, sch_organisation, sp_parentorganisation },
    { { 3, 3 }, { 0, 0 }, sch_organisation, sp_publishingprinciples },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_review },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_seeks },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_slogan },
    { { 3, 0 }, { 0, 0 }, sch_organisation, sp_sponsor },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_suborganisation },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_taxid },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_telephone },
    { { 3, 5 }, { 0, 0 }, sch_organisation, sp_unnamedsourcespolicy },
    { { 2, 0 }, { 0, 0 }, sch_organisation, sp_vatid },

    { { 2, 0 }, { 0, 0 }, sch_organisationrole, sp_numberedposition },

    { { 2, 0 }, { 0, 0 }, sch_ownershipinfo, sp_acquiredfrom },
    { { 2, 0 }, { 0, 0 }, sch_ownershipinfo, sp_ownedfrom },
    { { 2, 0 }, { 0, 0 }, sch_ownershipinfo, sp_ownedthrough },
    { { 2, 0 }, { 0, 0 }, sch_ownershipinfo, sp_typeofgood },

    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_deliveryaddress },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_deliverystatus },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_expectedarrivalfrom },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_expectedarrivaluntil },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_hasdeliverymethod },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_itemshipped },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_originaddress },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_partoforder },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_provider },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_trackingnumber },
    { { 2, 0 }, { 0, 0 }, sch_parceldelivery, sp_trackingurl },

    { { 2, 0 }, { 0, 0 }, sch_parentaudience, sp_childminage },
    { { 2, 0 }, { 0, 0 }, sch_parentaudience, sp_childmaxage  },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_pathologytest, sp_tissuesample },

    { { 3, 5 }, { 0, 0 }, sch_patient, sp_diagnosis },
    { { 3, 5 }, { 0, 0 }, sch_patient, sp_drug },
    { { 3, 5 }, { 0, 0 }, sch_patient, sp_healthcondition },

    { { 2, 0, SV_NOT_3034 }, { 6, 0 }, sch_payaction, sp_purpose },
    { { 2, 0 }, { 0, 0 }, sch_payaction, sp_recipient },

    { { 3, 5 }, { 0, 0 }, sch_paymentcard, sp_cashback },
    { { 3, 5 }, { 0, 0 }, sch_paymentcard, sp_contactlesspayment },
    { { 3, 5 }, { 0, 0 }, sch_paymentcard, sp_floorlimit },
    { { 9, 0 }, { 0, 0 }, sch_paymentcard, sp_minimummonthlyrepaymentamount },

    { { 2, 0 }, { 0, 0 }, sch_paymentchargespecification, sp_appliestodeliverymethod },
    { { 2, 0 }, { 0, 0 }, sch_paymentchargespecification, sp_appliestopaymentmethod },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_peopleaudience, sp_healthcondition },
    { { 2, 0 }, { 0, 0 }, sch_peopleaudience, sp_requiredgender },
    { { 2, 0 }, { 0, 0 }, sch_peopleaudience, sp_requiredmaxage },
    { { 2, 0 }, { 0, 0 }, sch_peopleaudience, sp_requiredminage },
    { { 2, 0 }, { 0, 0 }, sch_peopleaudience, sp_suggestedgender },
    { { 2, 0 }, { 0, 0 }, sch_peopleaudience, sp_suggestedmaxage },
    { { 2, 0 }, { 0, 0 }, sch_peopleaudience, sp_suggestedminage },

    { { 2, 0 }, { 0, 0 }, sch_performaction, sp_entertainmentbusiness },

    { { 2, 0 }, { 0, 0 }, sch_performancerole, sp_charactername },

    { { 2, 0 }, { 3, 2 }, sch_periodical, sp_issn },

    { { 2, 0 }, { 0, 0 }, sch_permit, sp_issuedby },
    { { 2, 0 }, { 0, 0 }, sch_permit, sp_issuedthrough },
    { { 2, 0 }, { 0, 0 }, sch_permit, sp_permitaudience },
    { { 2, 0 }, { 0, 0 }, sch_permit, sp_validfor },
    { { 2, 0 }, { 0, 0 }, sch_permit, sp_validfrom },
    { { 2, 0 }, { 0, 0 }, sch_permit, sp_validin },
    { { 2, 0 }, { 0, 0 }, sch_permit, sp_validuntil },

    { { 2, 0 }, { 0, 0 }, sch_person, sp_additionalname },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_address },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_affiliation },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_alumniof },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_award },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_birthdate },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_birthplace },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_brand },
    { { 5, 0 }, { 0, 0 }, sch_person, sp_callsign },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_children },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_colleague },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_contactpoint },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_deathdate },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_deathplace },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_duns },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_email },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_familyname },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_faxnumber },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_follows },
    { { 3, 1 }, { 0, 0 }, sch_person, sp_funder },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_gender },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_givenname },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_globallocationnumber },
    { { 3, 9 }, { 0, 0 }, sch_person, sp_hascredential },
    { { 3, 5 }, { 0, 0 }, sch_person, sp_hasoccupation },
    { { 2, 2 }, { 0, 0 }, sch_person, sp_hasoffercatalogue },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_haspos },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_height },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_homelocation },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_honourificprefix },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_honourificsuffix },
    { { 6, 0 }, { 0, 0 }, sch_person, sp_interactionstatistic },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_isicv4 },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_jobtitle },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_knows },
    { { 3, 5 }, { 0, 0 }, sch_person, sp_knowsabout },
    { { 3, 5 }, { 0, 0 }, sch_person, sp_knowslanguage },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_makesoffer },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_memberof },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_naics },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_nationality },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_networth },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_owns },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_parent },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_performerin },
    { { 3, 3 }, { 0, 0 }, sch_person, sp_publishingprinciples },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_relatedto },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_seeks },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_sibling },
    { { 3, 0 }, { 0, 0 }, sch_person, sp_sponsor },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_spouse },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_taxid },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_telephone },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_vatid },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_weight },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_worklocation },
    { { 2, 0 }, { 0, 0 }, sch_person, sp_worksfor },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_physicalactivity, sp_associatedanatomy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_physicalactivity, sp_category },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_physicalactivity, sp_epidemiology },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_physicalactivity, sp_pathophysiology },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_physician, sp_availableservice },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_physician, sp_hospitalaffiliation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_physician, sp_medicalspeciality },

    { { 2, 0 }, { 0, 0 }, sch_place, sp_additionalproperty },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_address },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_aggregaterating },
    { { 3, 1 }, { 0, 0 }, sch_place, sp_amenityfeature },
    { { 2, 2 }, { 0, 0 }, sch_place, sp_branchcode },
    { { 2, 0 }, { 2, 1 }, sch_place, sp_containedin },
    { { 2, 2 }, { 0, 0 }, sch_place, sp_containedinplace },
    { { 3, 0 }, { 0, 0 }, sch_place, sp_containsplace },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_event },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_faxnumber },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_geo },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geocontains },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geocoveredby },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geocovers },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geocrosses },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geodisjoint },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geoequals },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geointersects },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geooverlaps },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geotouches },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_geowithin },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_globallocationnumber },
    { { 7, 0 }, { 0, 0 }, sch_place, sp_hasdrivethroughservice },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_hasmap },
    { { 3, 3 }, { 0, 0 }, sch_place, sp_isaccessibleforfree },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_isicv4 },
    { { 4, 0 }, { 0, 0 }, sch_place, sp_latitude },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_logo },
    { { 4, 0 }, { 0, 0 }, sch_place, sp_longitude },
    { { 3, 2 }, { 0, 0 }, sch_place, sp_maximumattendeecapacity },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_openinghoursspecification },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_photo },
    { { 3, 3 }, { 0, 0 }, sch_place, sp_publicaccess },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_review },
    { { 3, 5 }, { 0, 0 }, sch_place, sp_slogan },
    { { 3, 1 }, { 0, 0 }, sch_place, sp_smokingallowed },
    { { 3, 0 }, { 0, 0 }, sch_place, sp_specialopeninghoursspecification },
    { { 2, 0 }, { 0, 0 }, sch_place, sp_telephone },
    { { 7, 0 }, { 0, 0 }, sch_place, sp_tourbookingpage },

    { { 2, 0 }, { 0, 0 }, sch_planaction, sp_scheduledtime },

    { { 2, 0 }, { 0, 0 }, sch_playaction, sp_audience },
    { { 2, 0 }, { 0, 0 }, sch_playaction, sp_event },

    { { 4, 0 }, { 0, 0 }, sch_podcastseries, sp_webfeed },

    { { 2, 0 }, { 0, 0 }, sch_postaladdress, sp_addresscountry },
    { { 2, 0 }, { 0, 0 }, sch_postaladdress, sp_addresslocality },
    { { 2, 0 }, { 0, 0 }, sch_postaladdress, sp_addressregion },
    { { 2, 0 }, { 0, 0 }, sch_postaladdress, sp_postofficeboxnumber },
    { { 2, 0 }, { 0, 0 }, sch_postaladdress, sp_postalcode },
    { { 2, 0 }, { 0, 0 }, sch_postaladdress, sp_streetaddress },

    { { 8, 0 }, { 0, 0 }, sch_postalcoderangespecification, sp_postalcodebegin },
    { { 8, 0 }, { 0, 0 }, sch_postalcoderangespecification, sp_postalcodeend },

    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_eligiblequantity },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_eligibletransactionvolume },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_maxprice },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_minprice },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_price },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_pricecurrency },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_validfrom },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_validthrough },
    { { 2, 0 }, { 0, 0 }, sch_pricespecification, sp_valueaddedtaxincluded },

    { { 2, 0 }, { 0, 0 }, sch_product, sp_additionalproperty },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_aggregaterating },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_audience },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_award },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_brand },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_category },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_colour },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_depth },
    { { 3, 8 }, { 0, 0 }, sch_product, sp_gtin },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_gtin12 },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_gtin13 },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_gtin14 },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_gtin8 },
    { { 10, 0 }, { 0, 0 }, sch_product, sp_hasenergyconsumptiondetails },
    { { 6, 0 }, { 0, 0 }, sch_product, sp_hasmerchantreturnpolicy },
    { { 3, 8 }, { 5, 0 }, sch_product, sp_hasproductreturnpolicy },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_height },
    { { 9, 0 }, { 0, 0 }, sch_product, sp_inproductgroupwithid },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_isaccessoryorsparepartfor },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_isconsumablefor },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_isrelatedto },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_issimilarto },
    { { 9, 0 }, { 0, 0 }, sch_product, sp_isvariantof },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_itemcondition },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_logo },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_manufacturer },
    { { 3, 2 }, { 0, 0 }, sch_product, sp_material },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_model },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_mpn },
    { { 3, 5 }, { 0, 0 }, sch_product, sp_nsn },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_offers },
    { { 9, 0 }, { 0, 0 }, sch_product, sp_pattern },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_productid },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_productiondate },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_purchasedate },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_releasedate },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_review },
    { { 9, 0 }, { 0, 0 }, sch_product, sp_size },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_sku },
    { { 3, 5 }, { 0, 0 }, sch_product, sp_slogan },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_weight },
    { { 2, 0 }, { 0, 0 }, sch_product, sp_width },

    { { 9, 0 }, { 0, 0 }, sch_productcollection, sp_includesobject },

    { { 9, 0 }, { 0, 0 }, sch_productgroup, sp_hasvariant },
    { { 9, 0 }, { 0, 0 }, sch_productgroup, sp_productgroupid },
    { { 9, 0 }, { 0, 0 }, sch_productgroup, sp_variesby },

    { { 2, 0 }, { 0, 0 }, sch_productmodel, sp_isvariantof },
    { { 2, 0 }, { 0, 0 }, sch_productmodel, sp_predecessorof },
    { { 2, 0 }, { 0, 0 }, sch_productmodel, sp_successorof },

    { { 2, 0 }, { 0, 0 }, sch_programmemembership, sp_hostingorganisation },
    { { 2, 0 }, { 0, 0 }, sch_programmemembership, sp_member },
    { { 2, 0 }, { 0, 0 }, sch_programmemembership, sp_membershipnumber },
    { { 3, 5 }, { 0, 0 }, sch_programmemembership, sp_membershippointsearned },
    { { 2, 0 }, { 0, 0 }, sch_programmemembership, sp_programmename },

    { { 6, 0 }, { 0, 0 }, sch_pronounceabletext, sp_inlanguage },
    { { 6, 0 }, { 0, 0 }, sch_pronounceabletext, sp_phonetictext },
    { { 6, 0 }, { 0, 0 }, sch_pronounceabletext, sp_speechtotextmarkup },
    { { 6, 0 }, { 0, 0 }, sch_pronounceabletext, sp_textvalue },

    { { 2, 0 }, { 0, 0 }, sch_property, sp_domainincludes },
    { { 2, 0 }, { 0, 0 }, sch_property, sp_inverseof },
    { { 2, 0 }, { 0, 0 }, sch_property, sp_rangeincludes },
    { { 2, 0 }, { 0, 0 }, sch_property, sp_supersededby },

    { { 2, 0 }, { 0, 0 }, sch_propertyvalue, sp_maxvalue },
    { { 3, 5 }, { 0, 0 }, sch_propertyvalue, sp_measurementtechnique },
    { { 2, 0 }, { 0, 0 }, sch_propertyvalue, sp_minvalue },
    { { 2, 0 }, { 0, 0 }, sch_propertyvalue, sp_propertyid },
    { { 2, 0 }, { 0, 0 }, sch_propertyvalue, sp_unitcode },
    { { 2, 0 }, { 0, 0 }, sch_propertyvalue, sp_unittext },
    { { 2, 0 }, { 0, 0 }, sch_propertyvalue, sp_value },
    { { 2, 0 }, { 0, 0 }, sch_propertyvalue, sp_valuereference },

    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_defaultvalue },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_maxvalue },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_minvalue },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_multiplevalues },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_readonlyvalue },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_stepvalue },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_valuemaxlength },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_valueminlength },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_valuename },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_valuepattern },
    { { 2, 0 }, { 0, 0 }, sch_propertyvaluespecification, sp_valuerequired },

    { { 2, 0 }, { 8, 0 }, sch_publicationevent, sp_isaccessibleforfree },
    { { 3, 5 }, { 0, 0 }, sch_publicationevent, sp_publishedby },
    { { 2, 0 }, { 0, 0 }, sch_publicationevent, sp_publishedon },

    { { 2, 0 }, { 0, 0 }, sch_publicationissue, sp_issuenumber },
    { { 2, 0 }, { 0, 0 }, sch_publicationissue, sp_pageend },
    { { 2, 0 }, { 0, 0 }, sch_publicationissue, sp_pagestart },
    { { 2, 0 }, { 0, 0 }, sch_publicationissue, sp_pagination },

    { { 2, 0 }, { 0, 0 }, sch_publicationvolume, sp_pageend },
    { { 2, 0 }, { 0, 0 }, sch_publicationvolume, sp_pagestart },
    { { 2, 0 }, { 0, 0 }, sch_publicationvolume, sp_pagination },
    { { 2, 0 }, { 0, 0 }, sch_publicationvolume, sp_volumenumber },

    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_additionalproperty },
    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_equal },
    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_greater },
    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_greaterorequal },
    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_lesser },
    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_lesserorequal },
    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_nonequal },
    { { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sp_valuereference },

    { { 2, 0 }, { 0, 0 }, sch_quantitativevalue, sp_additionalproperty },
    { { 2, 0 }, { 0, 0 }, sch_quantitativevalue, sp_maxvalue },
    { { 2, 0 }, { 0, 0 }, sch_quantitativevalue, sp_minvalue },
    { { 2, 0 }, { 0, 0 }, sch_quantitativevalue, sp_unitcode },
    { { 2, 0 }, { 0, 0 }, sch_quantitativevalue, sp_unittext },
    { { 2, 0 }, { 0, 0 }, sch_quantitativevalue, sp_value },
    { { 2, 0 }, { 0, 0 }, sch_quantitativevalue, sp_valuereference },

    { { 3, 5 }, { 0, 0 }, sch_quantitativevaluedistribution, sp_duration },
    { { 3, 5 }, { 0, 0 }, sch_quantitativevaluedistribution, sp_median },
    { { 3, 5 }, { 0, 0 }, sch_quantitativevaluedistribution, sp_percentile10 },
    { { 3, 5 }, { 0, 0 }, sch_quantitativevaluedistribution, sp_percentile25 },
    { { 3, 5 }, { 0, 0 }, sch_quantitativevaluedistribution, sp_percentile75 },
    { { 3, 5 }, { 0, 0 }, sch_quantitativevaluedistribution, sp_percentile90 },

    { { 2, 0 }, { 0, 0 }, sch_question, sp_acceptedanswer },
    { { 2, 0 }, { 0, 0 }, sch_question, sp_answercount },
    { { 2, 0 }, { 0, 0 }, sch_question, sp_downvotecount },
    { { 10, 0 }, { 0, 0 }, sch_question, sp_eduquestiontype },
    { { 2, 0 }, { 0, 0 }, sch_question, sp_suggestedanswer },
    { { 2, 0 }, { 0, 0 }, sch_question, sp_upvotecount },

    { { 3, 5 }, { 0, 0 }, sch_quotation, sp_spokenbycharacter },

    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_containsseason },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_episode },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_numberofepisodes },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_numberofseasons },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_radioseries, sp_trailer },

    { { 3, 1 }, { 0, 0 }, sch_rating, sp_author },
    { { 2, 0 }, { 0, 0 }, sch_rating, sp_bestrating },
    { { 3, 9 }, { 0, 0 }, sch_rating, sp_ratingexplanation },
    { { 2, 0 }, { 0, 0 }, sch_rating, sp_ratingvalue },
    { { 3, 5 }, { 0, 0 }, sch_rating, sp_reviewaspect },
    { { 2, 0 }, { 0, 0 }, sch_rating, sp_worstrating },

    { { 5, 0 }, { 0, 0 }, sch_realestatelisting, sp_leaselength },
    { { 6, 0 }, { 0, 0 }, sch_realestatelisting, sp_dateposted },

    { { 2, 0 }, { 0, 0 }, sch_receiveaction, sp_deliverymethod },
    { { 2, 0 }, { 0, 0 }, sch_receiveaction, sp_sender },

    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_cooktime },
    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_cookingmethod },
    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_nutrition },
    { { 2, 0 }, { 3, 2 }, sch_recipe, sp_preptime },
    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_recipecategory },
    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_recipecuisine },
    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_recipeingredient },
    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_recipeinstructions },
    { { 2, 0 }, { 0, 0 }, sch_recipe, sp_recipeyield },
    { { 3, 0 }, { 0, 0 }, sch_recipe, sp_suitablefordiet },
    { { 2, 0 }, { 3, 2 }, sch_recipe, sp_totaltime },

    { { 2, 0 }, { 0, 0 }, sch_rentaction, sp_landlord },
    { { 2, 0 }, { 0, 0 }, sch_rentaction, sp_realestateagent },

    { { 2, 0 }, { 0, 0 }, sch_rentalcarreservation, sp_dropofflocation },
    { { 2, 0 }, { 0, 0 }, sch_rentalcarreservation, sp_dropofftime },
    { { 2, 0 }, { 0, 0 }, sch_rentalcarreservation, sp_pickuplocation },
    { { 2, 0 }, { 0, 0 }, sch_rentalcarreservation, sp_pickuptime },

    { { 3, 5 }, { 0, 0 }, sch_repaymentspecification, sp_downpayment },
    { { 3, 5 }, { 0, 0 }, sch_repaymentspecification, sp_earlyprepaymentpenalty },
    { { 3, 5 }, { 0, 0 }, sch_repaymentspecification, sp_loanpaymentamount },
    { { 3, 5 }, { 0, 0 }, sch_repaymentspecification, sp_loanpaymentfrequency },
    { { 3, 5 }, { 0, 0 }, sch_repaymentspecification, sp_numberofloanpayments },

    { { 2, 0 }, { 0, 0 }, sch_replaceaction, sp_replacee },
    { { 2, 0 }, { 0, 0 }, sch_replaceaction, sp_replacer },

    { { 2, 0 }, { 0, 0 }, sch_replyaction, sp_resultcomment },

    { { 2, 1 }, { 0, 0 }, sch_report, sp_reportnumber },

    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_bookingtime },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_broker },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_modifiedtime },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_pricecurrency },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_programmemembershipused },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_provider },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_reservationfor },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_reservationid },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_reservationstatus },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_reservedticket },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_totalprice },
    { { 2, 0 }, { 0, 0 }, sch_reservation, sp_undername },

    { { 2, 0 }, { 0, 0 }, sch_reservationpackage, sp_subreservation },

    { { 6, 0 }, { 0, 0 }, sch_residence, sp_accommodationfloorplan },

    { { 2, 0 }, { 0, 0 }, sch_returnaction, sp_recipient },

    { { 2, 0 }, { 0, 0 }, sch_review, sp_itemreviewed },
    { { 3, 5 }, { 0, 0 }, sch_review, sp_reviewaspect },
    { { 2, 0 }, { 0, 0 }, sch_review, sp_reviewbody },
    { { 2, 0 }, { 0, 0 }, sch_review, sp_reviewrating },

    { { 2, 0 }, { 0, 0 }, sch_reviewaction, sp_resultreview },

    { { 2, 0 }, { 0, 0 }, sch_role, sp_enddate },
    { { 2, 0 }, { 0, 0 }, sch_role, sp_rolename },
    { { 2, 0 }, { 0, 0 }, sch_role, sp_startdate },

    { { 2, 0 }, { 0, 0 }, sch_rsvpaction, sp_additionalnumberofguests },
    { { 2, 0 }, { 0, 0 }, sch_rsvpaction, sp_comment },
    { { 2, 0 }, { 0, 0 }, sch_rsvpaction, sp_rsvpresponse },

    { { 3, 5 }, { 0, 0 }, sch_schedule, sp_byday },
    { { 3, 5 }, { 0, 0 }, sch_schedule, sp_bymonth },
    { { 3, 5 }, { 0, 0 }, sch_schedule, sp_bymonthday },
    { { 9, 0 }, { 0, 0 }, sch_schedule, sp_bymonthweek },
    { { 6, 0 }, { 0, 0 }, sch_schedule, sp_duration },
    { { 7, 0 }, { 0, 0 }, sch_schedule, sp_enddate },
    { { 7, 4 }, { 0, 0 }, sch_schedule, sp_endtime },
    { { 3, 5 }, { 5, 0 }, sch_schedule, sp_eventschedule },
    { { 3, 5 }, { 0, 0 }, sch_schedule, sp_exceptdate },
    { { 3, 5 }, { 0, 0 }, sch_schedule, sp_repeatcount },
    { { 3, 5 }, { 0, 0 }, sch_schedule, sp_repeatfrequency },
    { { 6, 0 }, { 0, 0 }, sch_schedule, sp_scheduletimezone },
    { { 7, 0 }, { 0, 0 }, sch_schedule, sp_startdate },
    { { 7, 4 }, { 0, 0 }, sch_schedule, sp_starttime },

    { { 2, 0 }, { 0, 0 }, sch_screeningevent, sp_subtitlelanguage },
    { { 2, 0 }, { 0, 0 }, sch_screeningevent, sp_videoformat },
    { { 2, 0 }, { 0, 0 }, sch_screeningevent, sp_workpresented },

    { { 2, 0 }, { 0, 0 }, sch_searchaction, sp_query },

    { { 2, 0 }, { 0, 0 }, sch_seat, sp_seatnumber },
    { { 2, 0 }, { 0, 0 }, sch_seat, sp_seatrow },
    { { 2, 0 }, { 0, 0 }, sch_seat, sp_seatsection },
    { { 2, 0 }, { 0, 0 }, sch_seat, sp_seatingtype },

    { { 2, 0 }, { 0, 0 }, sch_sellaction, sp_buyer },

    { { 2, 0 }, { 0, 0 }, sch_sendaction, sp_deliverymethod },
    { { 2, 0 }, { 0, 0 }, sch_sendaction, sp_recipient },

    { { 2, 0 }, { 0, 0 }, sch_service, sp_aggregaterating },
    { { 2, 2 }, { 0, 0 }, sch_service, sp_areaserved },
    { { 3, 0 }, { 0, 0 }, sch_service, sp_audience },
    { { 2, 0 }, { 0, 0 }, sch_service, sp_availablechannel },
    { { 2, 2 }, { 0, 0 }, sch_service, sp_award },
    { { 3, 0 }, { 0, 0 }, sch_service, sp_brand },
    { { 3, 2 }, { 0, 0 }, sch_service, sp_broker },
    { { 2, 2 }, { 0, 0 }, sch_service, sp_category },
    { { 2, 2 }, { 0, 0 }, sch_service, sp_hasoffercatalogue },
    { { 2, 2 }, { 0, 0 }, sch_service, sp_hoursavailable },
    { { 3, 0 }, { 0, 0 }, sch_service, sp_isrelatedto },
    { { 3, 0 }, { 0, 0 }, sch_service, sp_issimilarto },
    { { 3, 0 }, { 0, 0 }, sch_service, sp_logo },
    { { 2, 2 }, { 0, 0 }, sch_service, sp_offers },
    { { 2, 0 }, { 0, 0 }, sch_service, sp_provider },
    { { 2, 2 }, { 0, 0 }, sch_service, sp_providermobility },
    { { 2, 0 }, { 0, 0 }, sch_service, sp_review },
    { { 2, 0 }, { 2, 1 }, sch_service, sp_servicearea },
    { { 2, 0 }, { 0, 0 }, sch_service, sp_serviceoutput },
    { { 2, 0 }, { 0, 0 }, sch_service, sp_servicetype },
    { { 3, 5 }, { 0, 0 }, sch_service, sp_slogan },
    { { 3, 5 }, { 0, 0 }, sch_service, sp_termsofservice },

    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_availablelanguage },
    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_processingtime },
    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_providesservice },
    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_servicelocation },
    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_servicephone },
    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_servicepostaladdress },
    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_servicesmsnumber },
    { { 2, 0 }, { 0, 0 }, sch_servicechannel, sp_serviceurl },

    { { 8, 0 }, { 0, 0 }, sch_shippingdeliverytime, sp_businessdays },
    { { 8, 0 }, { 0, 0 }, sch_shippingdeliverytime, sp_cutofftime },
    { { 8, 0 }, { 0, 0 }, sch_shippingdeliverytime, sp_handlingtime },
    { { 8, 0 }, { 0, 0 }, sch_shippingdeliverytime, sp_transittime },

    { { 8, 0 }, { 0, 0 }, sch_shippingratesettings, sp_doesnotship },
    { { 8, 0 }, { 0, 0 }, sch_shippingratesettings, sp_freeshippingthreshold },
    { { 8, 0 }, { 0, 0 }, sch_shippingratesettings, sp_isunlabelledfallback },
    { { 8, 0 }, { 0, 0 }, sch_shippingratesettings, sp_shippingdestination },
    { { 8, 0 }, { 0, 0 }, sch_shippingratesettings, sp_shippinglabel },
    { { 8, 0 }, { 0, 0 }, sch_shippingratesettings, sp_shippingrate },

    { { 3, 1 }, { 0, 0 }, sch_singlefamilyresidence, sp_numberofrooms },
    { { 3, 1 }, { 0, 0 }, sch_singlefamilyresidence, sp_occupancy },

    { { 2, 1 }, { 0, 0 }, sch_socialmediaposting, sp_sharedcontent },

    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_applicationcategory },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_applicationsubcategory },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_applicationsuite },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_availableondevice },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_countriesnotsupported },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_countriessupported },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_downloadurl },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_featurelist },
    { { 2, 0 }, { 2, 1 }, sch_softwareapplication, sp_fileformat },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_filesize },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_installurl },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_memoryrequirements },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_operatingsystem },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_permissions },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_processorrequirements },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_releasenotes },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_screenshot },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_softwareaddon },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_softwarehelp },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_softwarerequirements },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_softwareversion },
    { { 2, 0 }, { 0, 0 }, sch_softwareapplication, sp_storagerequirements },
    { { 2, 2 }, { 0, 0 }, sch_softwareapplication, sp_supportingdata },

    { { 2, 0 }, { 0, 0 }, sch_softwaresourcecode, sp_coderepository },
    { { 2, 0 }, { 0, 0 }, sch_softwaresourcecode, sp_codesampletype },
    { { 2, 0 }, { 0, 0 }, sch_softwaresourcecode, sp_programminglanguage },
    { { 2, 0 }, { 0, 0 }, sch_softwaresourcecode, sp_runtimeplatform },
    { { 2, 0 }, { 0, 0 }, sch_softwaresourcecode, sp_targetplatform },

    { { 2, 0 }, { 0, 0 }, sch_someproducts, sp_inventorylevel },

    { { 3, 5 }, { 0, 0 }, sch_speakablespecification, sp_cssselector },
    { { 3, 5 }, { 0, 0 }, sch_speakablespecification, sp_xpath },

    { { 7, 2 }, { 0, 0 }, sch_specialannouncement, sp_announcementlocation },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_category },
    { { 7, 1 }, { 0, 0 }, sch_specialannouncement, sp_dateposted },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_diseasepreventioninfo },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_diseasespreadstatistics },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_gettingtestedinfo },
    { { 7, 4 }, { 0, 0 }, sch_specialannouncement, sp_governmentbenefitsinfo },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_newupdatesandguidelines },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_publictransportclosuresinfo },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_quarantineguidelines },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_schoolclosuresinfo },
    { { 7, 0 }, { 0, 0 }, sch_specialannouncement, sp_travelbans },
    { { 7, 3 }, { 0, 0 }, sch_specialannouncement, sp_webfeed },

    { { 2, 0 }, { 0, 0 }, sch_sportsevent, sp_awayteam },
    { { 2, 0 }, { 0, 0 }, sch_sportsevent, sp_competitor },
    { { 2, 0 }, { 0, 0 }, sch_sportsevent, sp_hometeam },
    { { 6, 0 }, { 0, 0 }, sch_sportsevent, sp_sport },

    { { 2, 0 }, { 0, 0 }, sch_sportsorganisation, sp_sport },

    { { 2, 0 }, { 0, 0 }, sch_sportsteam, sp_athlete },
    { { 2, 0 }, { 0, 0 }, sch_sportsteam, sp_coach },
    { { 4, 0 }, { 0, 0 }, sch_sportsteam, sp_gender },

    { { 3, 9 }, { 0, 0 }, sch_statisticalpopulation, sp_constrainingproperty },
    { { 3, 9 }, { 0, 0 }, sch_statisticalpopulation, sp_numconstraints },
    { { 3, 9 }, { 0, 0 }, sch_statisticalpopulation, sp_populationtype },

    { { 3, 5 }, { 0, 0 }, sch_stupidtype, sp_stupidproperty },

    { { 3, 5 }, { 0, 0 }, sch_substance, sp_activeingredient },
    { { 3, 5 }, { 0, 0 }, sch_substance, sp_maximumintake },

    { { 3, 1 }, { 0, 0 }, sch_suite, sp_bed },
    { { 3, 1 }, { 0, 0 }, sch_suite, sp_numberofrooms },
    { { 3, 1 }, { 0, 0 }, sch_suite, sp_occupancy },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_superficialanatomy, sp_associatedpathophysiology },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_superficialanatomy, sp_relatedanatomy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_superficialanatomy, sp_relatedcondition },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_superficialanatomy, sp_relatedtherapy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_superficialanatomy, sp_significance },

    { { 2, 0 }, { 0, 0 }, sch_taxireservation, sp_partysize },
    { { 2, 0 }, { 0, 0 }, sch_taxireservation, sp_pickuplocation },
    { { 2, 0 }, { 0, 0 }, sch_taxireservation, sp_pickuptime },

    { { 2, 0 }, { 0, 0 }, sch_techarticle, sp_dependencies },
    { { 2, 0 }, { 0, 0 }, sch_techarticle, sp_proficiencylevel },

    { { 3, 5 }, { 0, 0 }, sch_therapeuticprocedure, sp_adverseoutcome },
    { { 3, 5 }, { 0, 0 }, sch_therapeuticprocedure, sp_doseschedule },
    { { 3, 5 }, { 0, 0 }, sch_therapeuticprocedure, sp_drug },
    { { 3, 5 }, { 6, 0 }, sch_therapeuticprocedure, sp_indication },

    { { 3, 5 }, { 0, 0 }, sch_thesis, sp_insupportof },

    { { 2, 0 }, { 0, 0 }, sch_thing, sp_additionaltype },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_alternatename },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_description },
    { { 3, 0 }, { 0, 0 }, sch_thing, sp_disambiguatingdescription },
    { { 3, 2 }, { 0, 0 }, sch_thing, sp_identifier },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_image },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_mainentityofpage },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_name },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_potentialaction },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_sameas },
    { { 3, 5 }, { 0, 0 }, sch_thing, sp_subjectof },
    { { 2, 0 }, { 0, 0 }, sch_thing, sp_url },

    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_dateissued },
    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_issuedby },
    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_pricecurrency },
    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_ticketnumber },
    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_tickettoken },
    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_ticketedseat },
    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_totalprice },
    { { 2, 0 }, { 0, 0 }, sch_ticket, sp_undername },

    { { 2, 0 }, { 0, 0 }, sch_tipaction, sp_recipient },

    { { 3, 3 }, { 0, 0 }, sch_touristattraction, sp_availablelanguage },
    { { 3, 3 }, { 0, 0 }, sch_touristattraction, sp_touristtype },

    { { 3, 5 }, { 0, 0 }, sch_touristdestination, sp_includesattraction },
    { { 3, 5 }, { 0, 0 }, sch_touristdestination, sp_touristtype },

    { { 3, 5 }, { 0, 0 }, sch_touristtrip, sp_touristtype },

    { { 2, 0 }, { 0, 0 }, sch_trackaction, sp_deliverymethod },

    { { 2, 0 }, { 0, 0 }, sch_tradeaction, sp_price },
    { { 3, 5 }, { 0, 0 }, sch_tradeaction, sp_pricecurrency },
    { { 2, 0 }, { 0, 0 }, sch_tradeaction, sp_pricespecification },

    { { 2, 0 }, { 0, 0 }, sch_traintrip, sp_arrivalplatform },
    { { 2, 0 }, { 0, 0 }, sch_traintrip, sp_arrivalstation },
    { { 2, 0 }, { 3, 3 }, sch_traintrip, sp_arrivaltime },
    { { 2, 0 }, { 0, 0 }, sch_traintrip, sp_departureplatform },
    { { 2, 0 }, { 0, 0 }, sch_traintrip, sp_departurestation },
    { { 2, 0 }, { 3, 3 }, sch_traintrip, sp_departuretime },
    { { 2, 0 }, { 3, 3 }, sch_traintrip, sp_provider },
    { { 2, 0 }, { 0, 0 }, sch_traintrip, sp_trainname },
    { { 2, 0 }, { 0, 0 }, sch_traintrip, sp_trainnumber },

    { { 2, 0 }, { 0, 0 }, sch_transferaction, sp_fromlocation },
    { { 2, 0 }, { 0, 0 }, sch_transferaction, sp_tolocation },

    { { 2, 0 }, { 0, 0 }, sch_travelaction, sp_distance },

    { { 3, 4 }, { 0, 0 }, sch_trip, sp_arrivaltime },
    { { 3, 4 }, { 0, 0 }, sch_trip, sp_departuretime },
    { { 3, 5 }, { 0, 0 }, sch_trip, sp_itinerary },
    { { 3, 4 }, { 0, 0 }, sch_trip, sp_offers },
    { { 3, 5 }, { 0, 0 }, sch_trip, sp_partoftrip },
    { { 3, 4 }, { 0, 0 }, sch_trip, sp_provider },
    { { 3, 5 }, { 0, 0 }, sch_trip, sp_subtrip },

    { { 2, 2 }, { 0, 0 }, sch_tvepisode, sp_countryoforigin },
    { { 2, 0 }, { 0, 0 }, sch_tvepisode, sp_subtitlelanguage },
    { { 8, 0 }, { 0, 0 }, sch_tvepisode, sp_titleeidr },

    { { 2, 2 }, { 0, 0 }, sch_tvseason, sp_countryoforigin },

    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_containsseason },
    { { 2, 2 }, { 0, 0 }, sch_tvseries, sp_countryoforigin },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_episode },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_numberofepisodes },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_numberofseasons },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_tvseries, sp_trailer },

    { { 2, 0 }, { 0, 0 }, sch_typeandquantitynode, sp_amountofthisgood },
    { { 2, 0 }, { 0, 0 }, sch_typeandquantitynode, sp_businessfunction },
    { { 2, 0 }, { 0, 0 }, sch_typeandquantitynode, sp_typeofgood },
    { { 2, 0 }, { 0, 0 }, sch_typeandquantitynode, sp_unitcode },
    { { 2, 0 }, { 0, 0 }, sch_typeandquantitynode, sp_unittext },

    { { 2, 0 }, { 0, 0 }, sch_unitpricespecification, sp_billingincrement },
    { { 2, 0 }, { 0, 0 }, sch_unitpricespecification, sp_pricetype },
    { { 3, 0 }, { 0, 0 }, sch_unitpricespecification, sp_referencequantity },
    { { 2, 0 }, { 0, 0 }, sch_unitpricespecification, sp_unitcode },
    { { 2, 0 }, { 0, 0 }, sch_unitpricespecification, sp_unittext },

    { { 2, 0 }, { 0, 0 }, sch_updateaction, sp_targetcollection },

    { { 2, 0 }, { 0, 0 }, sch_usercomments, sp_commenttext },
    { { 2, 0 }, { 0, 0 }, sch_usercomments, sp_commenttime },
    { { 2, 0 }, { 0, 0 }, sch_usercomments, sp_creator },
    { { 2, 0 }, { 0, 0 }, sch_usercomments, sp_discusses },
    { { 2, 0 }, { 0, 0 }, sch_usercomments, sp_replytourl },

    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_accelerationtime },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_bodytype },
    { { 5, 0 }, { 0, 0 }, sch_vehicle, sp_callsign },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_cargovolume },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_datevehiclefirstregistered },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_drivewheelconfiguration },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_emmissionsco2 },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_fuelcapacity },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_fuelconsumption },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_fuelefficiency },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_fueltype },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_knownvehicledamages },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_meetsemissionstandard },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_mileagefromodometer },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_modeldate },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_numberofairbags },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_numberofaxles },
    { { 2, 1 }, { 0, 0 }, sch_vehicle, sp_numberofdoors },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_numberofforwardgears },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_numberofpreviousowners },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_payload },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_productiondate },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_purchasedate },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_seatingcapacity },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_speed },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_steeringposition },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_stupidproperty }, // ?!
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_tongueweight },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_trailerweight },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehicleconfiguration },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehicleengine },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehicleidentificationnumber },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehicleinteriorcolour },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehicleinteriortype },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehiclemodeldate },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehicleseatingcapacity },
    { { 3, 0 }, { 0, 0 }, sch_vehicle, sp_vehiclespecialusage },
    { { 2, 0 }, { 0, 0 }, sch_vehicle, sp_vehicletransmission },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_weighttotal },
    { { 3, 5 }, { 0, 0 }, sch_vehicle, sp_wheelbase },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_vein, sp_drainsto },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_vein, sp_regiondrained },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_vein, sp_tributary },

    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_vessel, sp_bloodsupply },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_vessel, sp_drainsto },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_vessel, sp_originatesfrom },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, sch_vessel, sp_runsto },

    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_cheatcode },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_gameplatform },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_gameserver },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_gametip },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_playmode },
    { { 2, 0 }, { 0, 0 }, sch_videogame, sp_trailer },

    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_characterattribute },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_cheatcode },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_containsseason },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_episode },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_gameitem },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_gamelocation },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_gameplatform },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_numberofepisodes },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_numberofplayers },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_numberofseasons },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_playmode },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_productioncompany },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_quest },
    { { 2, 0 }, { 0, 0 }, sch_videogameseries, sp_trailer },

    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_actor },
    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_caption },
    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_director },
    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_musicby },
    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_thumbnail },
    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_transcript },
    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_videoframesize },
    { { 2, 0 }, { 0, 0 }, sch_videoobject, sp_videoquality },

    { { 2, 0 }, { 0, 0 }, sch_visualartwork, sp_artedition },
    { { 2, 0 }, { 0, 0 }, sch_visualartwork, sp_artmedium },
    { { 2, 0 }, { 0, 0 }, sch_visualartwork, sp_artform },
    { { 3, 5 }, { 0, 0 }, sch_visualartwork, sp_artist },
    { { 2, 0 }, { 0, 0 }, sch_visualartwork, sp_artworksurface },
    { { 3, 5 }, { 0, 0 }, sch_visualartwork, sp_colourist },
    { { 2, 0 }, { 0, 0 }, sch_visualartwork, sp_depth },
    { { 2, 0 }, { 0, 0 }, sch_visualartwork, sp_height },
    { { 3, 5 }, { 0, 0 }, sch_visualartwork, sp_inker },
    { { 3, 5 }, { 0, 0 }, sch_visualartwork, sp_letterer },
    { { 3, 5 }, { 0, 0 }, sch_visualartwork, sp_penciler },
    { { 2, 0 }, { 0, 0 }, sch_visualartwork, sp_width },

    { { 2, 0 }, { 0, 0 }, sch_voteaction, sp_candidate },

    { { 2, 0 }, { 0, 0 }, sch_warrantypromise, sp_durationofwarranty },
    { { 2, 0 }, { 0, 0 }, sch_warrantypromise, sp_warrantyscope },

    { { 3, 5 }, { 0, 0 }, sch_webapi, sp_documentation },

    { { 2, 0 }, { 0, 0 }, sch_webapplication, sp_browserrequirements },

    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_breadcrumb },
    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_lastreviewed },
    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_maincontentofpage },
    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_primaryimageofpage },
    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_relatedlink },
    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_reviewedby },
    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_significantlink },
    { { 3, 5 }, { 0, 0 }, sch_webpage, sp_speakable },
    { { 2, 0 }, { 0, 0 }, sch_webpage, sp_speciality },

    { { 3, 5 }, { 0, 0 }, sch_webpageelement, sp_cssselector },
    { { 3, 5 }, { 0, 0 }, sch_webpageelement, sp_xpath },

    { { 3, 3 }, { 0, 0 }, sch_website, sp_issn },

    { { 2, 0 }, { 0, 0 }, sch_winaction, sp_loser },

    { { 3, 9 }, { 0, 0 }, sch_workbasedprogramme, sp_occupationalcategory },
    { { 3, 9 }, { 0, 0 }, sch_workbasedprogramme, sp_trainingsalary },

    { { 2, 0 }, { 0, 0 }, sch_writeaction, sp_inlanguage },

    { { 0, 0 }, { 0, 0 }, sch_illegal, sp_illegal } };

typedef ::std::pair < e_schema, e_schema_property > mmd_key;
typedef ::std::multimap < mmd_key, microdata_structure* > mmd_t;
mmd_t micromap;

void microdata_init (nitpick& )
{   assert (micromap.empty ());
    for (microdata_structure* p = &schema_structure [0]; p -> record_ != sch_illegal; ++p)
        if (micromap.find (::std::pair (p -> record_, p -> property_)) != micromap.end ())
            ::std::cerr << "microdata_init reports " << sch::name (p -> record_) << " (" << p -> record_ << "), " << schema_property_name (p -> property_) << " (" << p -> property_ << ") repeated\n";
        else
        {   mmd_key k (p -> record_, p -> property_);
            micromap.insert (mmd_t::value_type (k, p));
#if defined (_DEBUG)
            bool found = false;
            if (! check_schema_property_version (p -> from_, p -> to_, p -> property_, found))
                if (found)
                    ::std::cerr << "microdata_init reports " << sch::name (p -> record_) << " (" << p -> record_ << "), " <<
                                                                schema_property_name (p -> property_) << " (" << p -> property_ << ") is incompatible with version in property table\n";
                else
                    ::std::cerr << "microdata_init reports " << sch::name (p -> record_) << " (" << p -> record_ << "), " <<
                                                                schema_property_name (p -> property_) << " (" << p -> property_ << ") is not found in property table\n";
#endif // _DEBUG
} }

//bool test_microdata (nitpick& , const schema_version& , const ::std::string& , const ::std::string& )
//{  return true; }

bool is_schema_property (const e_schema s, const e_schema_property p)
{   mmd_t::const_iterator i = micromap.find (mmd_key (s, p));
    if (i == micromap.cend ()) return false;
    assert (i -> second != nullptr);
    return does_apply (context.schema_ver (), i -> second -> from_, i -> second -> to_); };
