/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "text.h"
#include "common.h"
#include "nitpick.h"

struct wotsit_t
{   html_version first_, last_;
    const char* wotsit_ = nullptr;
    const char* char_ = nullptr;
    wotsit_t () = default;
    wotsit_t (html_version first, html_version last, const char* wotsit, const char* sz = nullptr)
        :   first_ (first), last_ (last), wotsit_ (wotsit), char_ (sz) { }
    wotsit_t (const wotsit_t& w) = default;
    wotsit_t (wotsit_t&& w) = default;
    ~wotsit_t () = default;
    wotsit_t& operator = (const wotsit_t& w) = default;
    wotsit_t& operator = (wotsit_t&& w) = default; };

wotsit_t wotsit_table [] =
{   { { HTML_1_0 }, { HTML_UNDEF }, "AElig", "Æ" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Aacute", "À" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Abreve" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Acirc", "Å" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Acy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Afr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Agr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Agrave", "À" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Alpha", "" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Amacr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "And" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Aogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Aopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ApplyFunction" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Aring" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ascr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Assign" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Atilde", "Ã" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Auml", "Ä" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Backslash", "\\" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Barv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Barwed" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Bcy" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Because" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Bernoullis" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Beta" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Bfr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Bgr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Bopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Breve" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Bscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Bumpeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "CHcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "COPY", "©" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Cacute" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Cap" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CapitalDifferentialD" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Cayleys" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ccaron" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ccedil", "Ç" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ccirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Cconint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Cdot" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Cedilla", "¸" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CenterDot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Cfr" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Chi" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CircleDot" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CircleMinus" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CirclePlus" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CircleTimes" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ClockwiseContourIntegral" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CloseCurlyDoubleQuote" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CloseCurlyQuote" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Colon", ":" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Colone" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Congruent" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Conint" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ContourIntegral" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Copf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Coproduct" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CounterClockwiseContourIntegral" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Cross" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Cscr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Cup" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "CupCap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "DD" },
    { { HTML_5_0 }, { HTML_UNDEF }, "DDotrahd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "DJcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "DScy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "DZcy" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Dagger" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Darr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dashv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dcy" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Del" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Delta" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dfr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalAcute" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalDot" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalDoubleAcute" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalGrave" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalLeftRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalLeftRightVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalLeftVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalRightVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DiacriticalTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Diamond" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DifferentialD" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "DotDot" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DotEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleContourIntegral" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleDot" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleDownArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleLeftRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleLeftTee" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleLongLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleLongLeftRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleLongRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleRightTee" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleUpArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleUpDownArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DoubleVerticalBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownArrowBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownArrowUpArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownBreve" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownLeftRightVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownLeftTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownLeftVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownLeftVectorBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownRightTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownRightVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownRightVectorBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownTee" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "DownTeeArrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Downarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Dstrok" },
    { { HTML_PLUS }, { HTML_PLUS }, "EEgr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ENG" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ETH" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Eacute", "É" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ecaron" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ecirc", "Ê" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ecy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Edot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Efr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Egr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Egrave", "È" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Element" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Emacr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "EmptySmallSquare" },
    { { HTML_5_0 }, { HTML_UNDEF }, "EmptyVerySmallSquare" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Eogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Eopf" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Epsilon" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Equal" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "EqualTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Equilibrium" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Escr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Esim" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Eta" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Euml" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Exists" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ExponentialE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Fcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ffr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "FilledSmallSquare" },
    { { HTML_5_0 }, { HTML_UNDEF }, "FilledVerySmallSquare" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Fopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ForAll" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Fouriertrf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Fscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "GJcy" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Gamma" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gammad" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gbreve" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gcedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "GreaterEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "GreaterEqualLess" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "GreaterFullEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "GreaterGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "GreaterLess" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "GreaterSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "GreaterTilde" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Gt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "HARDcy" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Hacek" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Hat" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Hcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Hfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "HilbertSpace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Hopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "HorizontalLine" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Hscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Hstrok" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "HumpDownHump" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "HumpEqual" },
    { { HTML_5_0 }, { HTML_UNDEF }, "IEcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "IJlig" },
    { { HTML_5_0 }, { HTML_UNDEF }, "IOcy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Iacute", "Í" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Icirc", "Í" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Icy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Idot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ifr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Igr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Igrave", "Ì" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Im" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Imacr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ImaginaryI" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Implies" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Int" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Integral" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Intersection" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "InvisibleComma" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "InvisibleTimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Iogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Iopf" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Iota" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Iscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Itilde" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Iukcy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Iuml" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Jcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Jcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Jfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Jopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Jscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Jsercy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Jukcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "KHcy" },
    { { HTML_PLUS }, { HTML_PLUS }, "KHgr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "KJcy" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Kappa" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Kcedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Kcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Kfr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Kgr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Kopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Kscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "LJcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lacute" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Lambda" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lang" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Laplacetrf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Larr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lcedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lcy" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftAngleBracket" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftArrowBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftArrowRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftBracketingBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftCeiling" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftDoubleBracket" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftDoubleBracketingBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftDownTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftDownVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftDownVectorBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftFloor" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftRightVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftSkeleton" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftTee" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftTeeArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftTriangle" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftTriangleBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftTriangleEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftUpDownVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftUpTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftUpVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftUpVectorBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LeftVectorBar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Leftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Leftrightarrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LessEqualGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LessFullEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LessGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LessLess" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LessSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LessTilde" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ll" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lleftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lmidot" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LongLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LongLeftRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LongRightArrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Longleftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Longleftrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Longrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LowerLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "LowerRightArrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lsh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lstrok" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Lt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Map" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Mcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "MediumSpace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Mellintrf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Mfr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Mgr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "MinusPlus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Mopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Mscr" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Mu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "NJcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Nacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ncaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ncedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ncy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "NegativeMediumSpace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "NegativeThickSpace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "NegativeThinSpace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "NegativeVeryThinSpace" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NestedGreaterGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NestedLessLess" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Nfr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Ngr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "NoBreak" },
    { { HTML_5_0 }, { HTML_UNDEF }, "NonBreakingSpace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Nopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Not" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotCongruent" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotCupCap" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotDoubleVerticalBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotElement" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotEqualTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotExists" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotGreaterEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotGreaterFullEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotGreaterGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotGreaterLess" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotGreaterSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotGreaterTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotHumpDownHump" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotHumpEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLeftTriangle" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLeftTriangleBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLeftTriangleEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLess" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLessEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLessFullEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLessGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLessLess" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLessSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotLessTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotNestedGreaterGreater" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotNestedLessLess" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotPrecedes" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotPrecedesEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotPrecedesSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotPrecedesTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotReverseElement" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotRightTriangle" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotRightTriangleBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotRightTriangleEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSquareSubset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSquareSubsetEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSquareSuperset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSquareSupersetEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSubset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSubsetEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSucceeds" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSucceedsEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSucceedsSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSucceedsTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSuperset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotSupersetEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotTildeEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotTildeFullEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotTildeTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "NotVerticalBar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Nscr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ntilde", "Ñ" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Nu" },
    { { HTML_4_0 }, { HTML_UNDEF }, "OElig", "Œ" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Oacute", "Ó" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ocirc", "Ô" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ocy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Odblac" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ofr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Ogr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ograve", "Ò" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Omacr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Omega" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Omicron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Oopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "OpenCurlyDoubleQuote" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "OpenCurlyQuote" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Or" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Oscr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Oslash" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Otilde", "Õ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Otimes" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ouml" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "OverBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "OverBrace" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "OverBracket" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "OverParenthesis" },
    { { HTML_PLUS }, { HTML_PLUS }, "PHgr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "PartialD" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Pcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Pfr" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Phi" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Pi", "∏" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "PlusMinus", "±" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Poincareplane" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Popf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Pr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Precedes" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "PrecedesEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "PrecedesSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "PrecedesTilde" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Prime", "”" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Product" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Proportion" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Proportional" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Pscr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Psi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "QUOT" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Qfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Qopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Qscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "RBarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "REG" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Racute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rang" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rarrtl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rcedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Re" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ReverseElement" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ReverseEquilibrium" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ReverseUpEquilibrium" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rfr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Rgr" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Rho" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightAngleBracket" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightArrowBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightArrowLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightBracketingBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightCeiling" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightDoubleBracket" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightDoubleBracketingBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightDownTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightDownVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightDownVectorBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightFloor" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightSkeleton" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightTee" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightTeeArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightTriangle" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightTriangleBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightTriangleEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightUpDownVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightUpTeeVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightUpVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightUpVectorBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightVector" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RightVectorBar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ropf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "RoundImplies" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Rsh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "RuleDelayed" },
    { { HTML_5_0 }, { HTML_UNDEF }, "SHCHcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "SHcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "SOFTcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Sacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Sc" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Scaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Scedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Scirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Scy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Sfr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ShortDownArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ShortLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ShortRightArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "ShortUpArrow" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Sigma" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SmallCircle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Sopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Sqrt" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Square" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SquareIntersection" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SquareSubset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SquareSubsetEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SquareSuperset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SquareSupersetEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SquareUnion" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Sscr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Star" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Sub" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Subset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SubsetEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Succeeds" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SucceedsEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SucceedsSlantEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SucceedsTilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SuchThat" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Sum" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Sup" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Superset" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "SupersetEqual" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Supset" },
    { { HTML_1_0 }, { HTML_UNDEF }, "THORN" },
    { { HTML_5_0 }, { HTML_UNDEF }, "TRADE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "TSHcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "TScy" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Tau" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Tcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Tcedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Tcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Tfr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Tgr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Therefore" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Theta" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Tilde" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "TildeEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "TildeFullEqual" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "TildeTilde" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Topf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "TripleDot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Tscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Tstrok" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Uacute", "Ú" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Uarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Uarrocir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ubrcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ubreve" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ucirc", "Û" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ucy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Udblac" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ufr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Ugrave", "Ù" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Umacr" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UnderBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UnderBrace" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UnderBracket" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UnderParenthesis" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Union" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UnionPlus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Uogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Uopf" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpArrowBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpArrowDownArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpDownArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpEquilibrium" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpTee" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpTeeArrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Uparrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Updownarrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpperLeftArrow" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "UpperRightArrow" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Upsi" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Upsilon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Uring" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Uscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Utilde" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Uuml", "Ü" },
    { { HTML_5_0 }, { HTML_UNDEF }, "VDash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vdash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vdashl" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Vee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Verbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vert" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "VerticalBar" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "VerticalLine" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "VerticalSeparator" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "VerticalTilde" },
    { { HTML_5_0 }, { HTML_UNDEF }, "VeryThinSpace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Vvdash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Wcirc" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "Wedge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Wfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Wopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Wscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Xfr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "Xi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Xopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Xscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "YAcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "YIcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "YUcy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "Yacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ycirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Ycy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Yfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Yopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Yscr" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Yuml", "Ÿ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ZHcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Zacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Zcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Zcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Zdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ZeroWidthSpace" },
    { { HTML_4_0 }, { HTML_UNDEF }, "Zeta" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Zfr" },
    { { HTML_PLUS }, { HTML_PLUS }, "Zgr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Zopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "Zscr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "aacute", "á" },
    { { HTML_5_0 }, { HTML_UNDEF }, "abreve" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ac" },
    { { HTML_5_0 }, { HTML_UNDEF }, "acd" },
    { { HTML_1_0 }, { HTML_UNDEF }, "acirc", "å" },
    { { HTML_1_0 }, { HTML_UNDEF }, "acute", "´" },
    { { HTML_5_0 }, { HTML_UNDEF }, "acy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "aelig", "æ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "af" },
    { { HTML_5_0 }, { HTML_UNDEF }, "afr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "agrave", "à" },
    { { HTML_4_0 }, { HTML_UNDEF }, "alefsym" },
    { { HTML_PLUS }, { HTML_UNDEF }, "aleph" },
    { { HTML_PLUS }, { HTML_UNDEF }, "alpha" },
    { { HTML_5_0 }, { HTML_UNDEF }, "amacr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "amalg" },
    { { HTML_TAGS }, { HTML_UNDEF }, "amp", "" },
    { { HTML_PLUS }, { HTML_UNDEF }, "and" },
    { { HTML_5_0 }, { HTML_UNDEF }, "andand" },
    { { HTML_5_0 }, { HTML_UNDEF }, "andd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "andslope" },
    { { HTML_5_0 }, { HTML_UNDEF }, "andv" },
    { { HTML_PLUS }, { HTML_UNDEF }, "ang" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ange" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdaa" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdab" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdac" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdad" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdae" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdaf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdag" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angmsdah" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angrt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angrtvb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angrtvbd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angsph" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angst" },
    { { HTML_5_0 }, { HTML_UNDEF }, "angzarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "aogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "aopf" },
    { { HTML_PLUS }, { HTML_UNDEF }, "ap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "apE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "apacir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ape" },
    { { HTML_5_0 }, { HTML_UNDEF }, "apid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "apos" },
    { { HTML_5_0 }, { HTML_UNDEF }, "approx" },
    { { HTML_5_0 }, { HTML_UNDEF }, "approxeq" },
    { { HTML_1_0 }, { HTML_UNDEF }, "aring" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ascr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ast" },
    { { HTML_4_0 }, { HTML_UNDEF }, "asymp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "asympeq" },
    { { HTML_1_0 }, { HTML_UNDEF }, "atilde", "ã" },
    { { HTML_1_0 }, { HTML_UNDEF }, "auml", "ä" },
    { { HTML_5_0 }, { HTML_UNDEF }, "awconint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "awint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bNot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "backcong" },
    { { HTML_5_0 }, { HTML_UNDEF }, "backepsilon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "backprime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "backsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "backsimeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "barvee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "barwed" },
    { { HTML_5_0 }, { HTML_UNDEF }, "barwedge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bbrk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bbrktbrk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bcong" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bcy" },
    { { HTML_4_0 }, { HTML_UNDEF }, "bdquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "becaus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "because" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bemptyv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bepsi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bernou" },
    { { HTML_PLUS }, { HTML_UNDEF }, "beta", "ß" },
    { { HTML_5_0 }, { HTML_UNDEF }, "beth" },
    { { HTML_5_0 }, { HTML_UNDEF }, "between" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigcap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigodot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigoplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigotimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigsqcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigstar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigtriangledown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigtriangleup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "biguplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigvee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bigwedge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bkarow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blacklozenge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blacksquare" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blacktriangle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blacktriangledown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blacktriangleleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blacktriangleright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blank" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blk12" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blk14" },
    { { HTML_5_0 }, { HTML_UNDEF }, "blk34" },
    { { HTML_5_0 }, { HTML_UNDEF }, "block" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bnot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bottom" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bowtie" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxDL" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxDR" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxDl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxDr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxH" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxHD" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxHU" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxHd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxHu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxUL" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxUR" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxUl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxUr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxV" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxVH" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxVL" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxVR" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxVh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxVl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxVr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxbox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxdL" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxdR" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxdl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxdr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxhD" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxhU" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxhd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxhu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxminus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxtimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxuL" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxuR" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxul" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxur" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxvH" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxvL" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxvR" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxvh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxvl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "boxvr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bprime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "breve" },
    { { HTML_1_0 }, { HTML_UNDEF }, "brvbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bsemi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bsime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bsol" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bsolb" },
    { { HTML_PLUS }, { HTML_UNDEF }, "bull" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bullet" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bump" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bumpE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bumpe" },
    { { HTML_5_0 }, { HTML_UNDEF }, "bumpeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cacute" },
    { { HTML_PLUS }, { HTML_UNDEF }, "cap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "capand" },
    { { HTML_5_0 }, { HTML_UNDEF }, "capbrcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "capcap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "capcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "capdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "caret" },
    { { HTML_5_0 }, { HTML_UNDEF }, "caron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ccaps" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ccaron" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ccedil", "ç" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ccirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ccups" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ccupssm" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cdot" },
    { { HTML_3_0 }, { HTML_3_0 }, "cdots" },
    { { HTML_1_0 }, { HTML_UNDEF }, "cedil", "¸" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cemptyv" },
    { { HTML_1_0 }, { HTML_UNDEF }, "cent", "¢" },
    { { HTML_5_0 }, { HTML_UNDEF }, "centerdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "chcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "check" },
    { { HTML_5_0 }, { HTML_UNDEF }, "checkmark" },
    { { HTML_PLUS }, { HTML_UNDEF }, "chi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cirE" },
    { { HTML_4_0 }, { HTML_UNDEF }, "circ", "¨" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circlearrowleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circlearrowright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circledR" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circledS" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circledast" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circledcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "circleddash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cire" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cirfnint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cirmid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cirscir" },
    { { HTML_PLUS }, { HTML_UNDEF }, "clubs" },
    { { HTML_5_0 }, { HTML_UNDEF }, "clubsuit" },
    { { HTML_5_0 }, { HTML_UNDEF }, "colon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "colone" },
    { { HTML_5_0 }, { HTML_UNDEF }, "coloneq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "comma", "," },
    { { HTML_5_0 }, { HTML_UNDEF }, "commat" },
    { { HTML_5_0 }, { HTML_UNDEF }, "comp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "compfn" },
    { { HTML_5_0 }, { HTML_UNDEF }, "complement" },
    { { HTML_5_0 }, { HTML_UNDEF }, "complexes" },
    { { HTML_PLUS }, { HTML_UNDEF }, "cong" },
    { { HTML_5_0 }, { HTML_UNDEF }, "congdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "conint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "copf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "coprod" },
    { { HTML_1_0 }, { HTML_UNDEF }, "copy", "©" },
    { { HTML_5_0 }, { HTML_UNDEF }, "copysr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "cr", "\r" },
    { { HTML_4_0 }, { HTML_UNDEF }, "crarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cross", "†" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "csub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "csube" },
    { { HTML_5_0 }, { HTML_UNDEF }, "csup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "csupe" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ctdot" },
    { { HTML_3_0 }, { HTML_3_0 }, "cub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cudarrl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cudarrr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cuepr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cuesc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cularr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cularrp" },
    { { HTML_PLUS }, { HTML_UNDEF }, "cup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cupbrcap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cupcap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cupcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cupdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cupor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curarrm" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curlyeqprec" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curlyeqsucc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curlyvee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curlywedge" },
    { { HTML_1_0 }, { HTML_UNDEF }, "curren", "€" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curvearrowleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "curvearrowright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cuvee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cuwed" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cwconint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cwint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "cylcty" },
    { { HTML_4_0 }, { HTML_UNDEF }, "dArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dHar" },
    { { HTML_4_0 }, { HTML_UNDEF }, "dagger" },
    { { HTML_5_0 }, { HTML_UNDEF }, "daleth" },
    { { HTML_PLUS }, { HTML_UNDEF }, "darr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dashv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dbkarow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dblac" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dcy" },
    { { XHTML_1_0 }, { HTML_UNDEF }, "dd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ddagger" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ddarr" },
    { { HTML_3_0 }, { HTML_3_0 }, "ddots" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ddotseq" },
    { { HTML_1_0 }, { HTML_UNDEF }, "deg", "˚" },
    { { HTML_PLUS }, { HTML_PLUS }, "degree", "˚" },
    { { HTML_PLUS }, { HTML_UNDEF }, "delta", "∂" },
    { { HTML_5_0 }, { HTML_UNDEF }, "demptyv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dfisht" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dharl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dharr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "diam" },
    { { HTML_5_0 }, { HTML_UNDEF }, "diamond" },
    { { HTML_5_0 }, { HTML_UNDEF }, "diamondsuit" },
    { { HTML_PLUS }, { HTML_UNDEF }, "diams" },
    { { HTML_PLUS }, { HTML_UNDEF }, "die", "¨" },
    { { HTML_5_0 }, { HTML_UNDEF }, "digamma" },
    { { HTML_5_0 }, { HTML_UNDEF }, "disin" },
    { { HTML_5_0 }, { HTML_UNDEF }, "div" },
    { { HTML_1_0 }, { HTML_UNDEF }, "divide", "÷" },
    { { HTML_5_0 }, { HTML_UNDEF }, "divideontimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "divonx" },
    { { HTML_5_0 }, { HTML_UNDEF }, "djcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dlcorn" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dlcrop" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dollar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "doteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "doteqdot" },
    { { HTML_3_0 }, { HTML_3_0 }, "dotfill" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dotminus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dotplus" },
    { { HTML_3_0 }, { HTML_3_0 }, "dots" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dotsquare" },
    { { HTML_5_0 }, { HTML_UNDEF }, "doublebarwedge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "downarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "downdownarrows" },
    { { HTML_5_0 }, { HTML_UNDEF }, "downharpoonleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "downharpoonright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "drbkarow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "drcorn" },
    { { HTML_5_0 }, { HTML_UNDEF }, "drcrop" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dscy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dsol" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dstrok" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dtdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dtri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dtrif" },
    { { HTML_5_0 }, { HTML_UNDEF }, "duarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "duhar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dwangle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dzcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "dzigrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eDDot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eDot" },
    { { HTML_1_0 }, { HTML_UNDEF }, "eacute", "é" },
    { { HTML_5_0 }, { HTML_UNDEF }, "easter" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ecaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ecir" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ecirc", "ê" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ecolon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ecy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "edot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "efDot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "efr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eg" },
    { { HTML_1_0 }, { HTML_UNDEF }, "egrave", "è" },
    { { HTML_5_0 }, { HTML_UNDEF }, "egs" },
    { { HTML_5_0 }, { HTML_UNDEF }, "egsdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "el" },
    { { HTML_5_0 }, { HTML_UNDEF }, "elinters" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ell" },
    { { HTML_5_0 }, { HTML_UNDEF }, "els" },
    { { HTML_5_0 }, { HTML_UNDEF }, "elsdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "emacr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "empty" },
    { { HTML_5_0 }, { HTML_UNDEF }, "emptyset" },
    { { HTML_5_0 }, { HTML_UNDEF }, "emptyv" },
    { { HTML_3_0, HV_NOT32 }, { HTML_UNDEF }, "emsp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "emsp13" },
    { { HTML_5_0 }, { HTML_UNDEF }, "emsp14" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eng" },
    { { HTML_3_0, HV_NOT32 }, { HTML_UNDEF }, "ensp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "epar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eparsl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eplus" },
    { { HTML_PLUS }, { HTML_UNDEF }, "epsi" },
    { { HTML_3_0 }, { HTML_UNDEF }, "epsilon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "epsiv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eqcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eqcolon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eqsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eqslantgtr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eqslantless" },
    { { HTML_3_0 }, { HTML_UNDEF }, "equals" },
    { { HTML_5_0 }, { HTML_UNDEF }, "equest" },
    { { HTML_PLUS }, { HTML_UNDEF }, "equiv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "equivDD" },
    { { HTML_5_0 }, { HTML_UNDEF }, "eqvparsl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "erDot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "erarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "escr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "esdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "esim" },
    { { HTML_PLUS }, { HTML_UNDEF }, "eta" },
    { { HTML_1_0 }, { HTML_UNDEF }, "eth" },
    { { HTML_1_0 }, { HTML_UNDEF }, "euml", "ë" },
    { { HTML_4_0 }, { HTML_UNDEF }, "euro", "€" },
    { { HTML_5_0 }, { HTML_UNDEF }, "excl" },
    { { HTML_PLUS }, { HTML_UNDEF }, "exist" },
    { { HTML_5_0 }, { HTML_UNDEF }, "expectation" },
    { { HTML_5_0 }, { HTML_UNDEF }, "exponentiale" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fallingdotseq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "female" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ffilig" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fflig" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ffllig" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ffr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "filig", "ﬁ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "flat" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fllig", "ﬂ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fltns" },
    { { HTML_4_0 }, { HTML_UNDEF }, "fnof", "ƒ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fopf" },
    { { HTML_PLUS }, { HTML_UNDEF }, "forall" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fork" },
    { { HTML_5_0 }, { HTML_UNDEF }, "forkv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fpartint" },
    { { HTML_1_0 }, { HTML_UNDEF }, "frac12" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac13" },
    { { HTML_1_0 }, { HTML_UNDEF }, "frac14" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac15" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac16" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac18" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac23" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac25" },
    { { HTML_1_0 }, { HTML_UNDEF }, "frac34" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac35" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac38" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac45" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac56" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac58" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frac78" },
    { { HTML_4_0 }, { HTML_UNDEF }, "frasl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "frown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "fscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gEl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gacute" },
    { { HTML_PLUS }, { HTML_UNDEF }, "gamma" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gammad" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gbreve" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gdot" },
    { { HTML_PLUS }, { HTML_UNDEF }, "ge", "≥" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gel" },
    { { HTML_5_0 }, { HTML_UNDEF }, "geq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "geqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "geqslant" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ges" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gescc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gesdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gesdoto" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gesdotol" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gesles" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ggg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gimel" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gjcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "glE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gla" },
    { { HTML_5_0 }, { HTML_UNDEF }, "glj" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gnE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gnap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gnapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gne" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gneq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gneqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gnsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "grave", "`" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gsime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gsiml" },
    { { HTML_TAGS }, { HTML_UNDEF }, "gt", ">" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtcc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtcir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtlPar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtquest" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtrapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtrdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtreqless" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtreqqless" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtrless" },
    { { HTML_5_0 }, { HTML_UNDEF }, "gtrsim" },
    { { HTML_PLUS}, { HTML_UNDEF }, "hArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hairsp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "half" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hamilt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hardcy" },
    { { HTML_PLUS }, { HTML_UNDEF }, "harr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "harrcir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "harrw" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hcirc" },
    { { HTML_PLUS }, { HTML_UNDEF }, "hearts" },
    { { HTML_5_0 }, { HTML_UNDEF }, "heartsuit" },
    { { HTML_PLUS }, { HTML_UNDEF }, "hellip", "…" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hercon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hksearow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hkswarow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hoarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "homtht" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hookleftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hookrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "horbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hslash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hstrok" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ht", "\t" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hybull" },
    { { HTML_5_0 }, { HTML_UNDEF }, "hyphen" },
    { { HTML_1_0 }, { HTML_UNDEF }, "iacute", "í" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ic" },
    { { HTML_1_0 }, { HTML_UNDEF }, "icirc", "î" },
    { { HTML_5_0 }, { HTML_UNDEF }, "icy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iecy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "iexcl", "¡" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iff" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ifr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "igrave", "ì" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ii" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iiiint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iiint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iinfin" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iiota" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ijlig" },
    { { HTML_5_0 }, { HTML_UNDEF }, "imacr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "image" },
    { { HTML_5_0 }, { HTML_UNDEF }, "imagline" },
    { { HTML_5_0 }, { HTML_UNDEF }, "imagpart" },
    { { HTML_5_0 }, { HTML_UNDEF }, "imath" },
    { { HTML_5_0 }, { HTML_UNDEF }, "imof" },
    { { HTML_5_0 }, { HTML_UNDEF }, "imped" },
    { { HTML_5_0 }, { HTML_UNDEF }, "in" },
    { { HTML_5_0 }, { HTML_UNDEF }, "incare" },
    { { HTML_3_0 }, { HTML_3_0 }, "inf", "∞" },
    { { HTML_PLUS }, { HTML_UNDEF }, "infin", "∞" },
    { { HTML_5_0 }, { HTML_UNDEF }, "infintie" },
    { { HTML_5_0 }, { HTML_UNDEF }, "inodot" },
    { { HTML_PLUS }, { HTML_UNDEF }, "int" },
    { { HTML_5_0 }, { HTML_UNDEF }, "intcal" },
    { { HTML_5_0 }, { HTML_UNDEF }, "integers" },
    { { HTML_5_0 }, { HTML_UNDEF }, "intercal" },
    { { HTML_5_0 }, { HTML_UNDEF }, "intlarhk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "intprod" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iocy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iopf" },
    { { HTML_PLUS }, { HTML_UNDEF }, "iota" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iprod" },
    { { HTML_1_0 }, { HTML_UNDEF }, "iquest", "¿" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iscr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "isin" },
    { { HTML_5_0 }, { HTML_UNDEF }, "isinE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "isindot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "isins" },
    { { HTML_5_0 }, { HTML_UNDEF }, "isinsv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "isinv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "it" },
    { { HTML_5_0 }, { HTML_UNDEF }, "itilde" },
    { { HTML_5_0 }, { HTML_UNDEF }, "iukcy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "iuml", "ï" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jmath" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jsercy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "jukcy" },
    { { HTML_PLUS }, { HTML_UNDEF }, "kappa" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kappav" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kcedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kgreen" },
    { { HTML_5_0 }, { HTML_UNDEF }, "khcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kjcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "kscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lAarr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "lArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lAtail" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lBarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lEg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lHar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "laemptyv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lagran" },
    { { HTML_PLUS }, { HTML_UNDEF }, "lambda" },
    { { HTML_PLUS }, { HTML_UNDEF }, "lang" },
    { { HTML_5_0 }, { HTML_UNDEF }, "langd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "langle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lap" },
    { { HTML_1_0 }, { HTML_UNDEF }, "laquo", "«" },
    { { HTML_PLUS }, { HTML_UNDEF }, "larr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrbfs" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrfs" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrhk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrlp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrpl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "larrtl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lat" },
    { { HTML_5_0 }, { HTML_UNDEF }, "latail" },
    { { HTML_5_0 }, { HTML_UNDEF }, "late" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lbarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lbbrk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lbrace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lbrack" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lbrke" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lbrksld" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lbrkslu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lcedil" },
    { { HTML_PLUS }, { HTML_UNDEF }, "lceil" },
    { { HTML_3_0 }, { HTML_UNDEF }, "lcub", "{" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ldca" },
    { { HTML_3_0 }, { HTML_3_0 }, "ldots" },
    { { HTML_4_0 }, { HTML_UNDEF }, "ldquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ldquor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ldrdhar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ldrushar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ldsh" },
    { { HTML_PLUS }, { HTML_PLUS }, "le", "≤" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftarrowtail" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftharpoondown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftharpoonup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftleftarrows" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftrightarrows" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftrightharpoons" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftrightsquigarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leftthreetimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "leqslant" },
    { { HTML_5_0 }, { HTML_UNDEF }, "les" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lescc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lesdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lesdoto" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lesdotor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lesges" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lessapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lessdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lesseqgtr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lesseqqgtr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lessgtr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lesssim" },
    { { HTML_1_0 }, { HTML_UNDEF }, "lf", "\f" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lfisht" },
    { { HTML_PLUS }, { HTML_UNDEF }, "lfloor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lgE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lhard" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lharu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lharul" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lhblk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ljcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ll" },
    { { HTML_5_0 }, { HTML_UNDEF }, "llarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "llcorner" },
    { { HTML_5_0 }, { HTML_UNDEF }, "llhard" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lltri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lmidot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lmoust" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lmoustache" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lnE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lnap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lnapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lne" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lneq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lneqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lnsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "loang" },
    { { HTML_5_0 }, { HTML_UNDEF }, "loarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lobrk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "longleftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "longleftrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "longmapsto" },
    { { HTML_5_0 }, { HTML_UNDEF }, "longrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "looparrowleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "looparrowright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lopar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "loplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lotimes" },
    { { HTML_PLUS }, { HTML_UNDEF }, "lowast" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lowbar" },
    { { HTML_PLUS }, { HTML_UNDEF }, "loz" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lozenge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lozf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lpar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lparlt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lrcorner" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lrhar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lrhard" },
    { { HTML_2_0, HV_RFC_2070 | HV_NOT3 }, { HTML_UNDEF }, "lrm" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lrtri" },
    { { HTML_4_0 }, { HTML_UNDEF }, "lsaquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lsh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lsime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lsimg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lsqb" },
    { { HTML_4_0 }, { HTML_UNDEF }, "lsquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lsquor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lstrok" },
    { { HTML_TAGS }, { HTML_UNDEF }, "lt", "<" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltcc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltcir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lthree" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltlarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltquest" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltrPar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltrie" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ltrif" },
    { { HTML_5_0 }, { HTML_UNDEF }, "lurdshar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "luruhar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mDDot" },
    { { HTML_1_0 }, { HTML_UNDEF }, "macr", "¯" },
    { { HTML_PLUS }, { HTML_PLUS }, "macron", "¯" },
    { { HTML_5_0 }, { HTML_UNDEF }, "male" },
    { { HTML_5_0 }, { HTML_UNDEF }, "malt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "maltese" },
    { { HTML_5_0 }, { HTML_UNDEF }, "map" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mapsto" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mapstodown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mapstoleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mapstoup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "marker" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mcomma" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mcy" },
    { { HTML_3_0, HV_NOT32 }, { HTML_UNDEF }, "mdash", "—" },
    { { HTML_5_0 }, { HTML_UNDEF }, "measuredangle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mho" },
    { { HTML_1_0 }, { HTML_UNDEF }, "micro", "µ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "midast" },
    { { HTML_5_0 }, { HTML_UNDEF }, "midcir" },
    { { HTML_1_0 }, { HTML_UNDEF }, "middot", "·" },
    { { HTML_PLUS }, { HTML_UNDEF }, "minus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "minusb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "minusd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "minusdu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mlcp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mldr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mnplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "models" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mstpos" },
    { { HTML_PLUS }, { HTML_UNDEF }, "mu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "multimap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "mumap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nLeftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nLeftrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nRightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nVDash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nVdash" },
    { { HTML_PLUS }, { HTML_UNDEF }, "nabla" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "napos" },
    { { HTML_5_0 }, { HTML_UNDEF }, "napprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "natur" },
    { { HTML_5_0 }, { HTML_UNDEF }, "natural" },
    { { HTML_5_0 }, { HTML_UNDEF }, "naturals" },
    { { HTML_1_0 }, { HTML_UNDEF }, "nbsp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ncap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ncaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ncedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ncong" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ncup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ncy" },
    { { HTML_3_0, HV_NOT32 }, { HTML_UNDEF }, "ndash", "–" },
    { { HTML_PLUS }, { HTML_UNDEF }, "ne", "≠" },
    { { HTML_5_0 }, { HTML_UNDEF }, "neArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nearhk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nearr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nearrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nequiv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nesear" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nexist" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nexists" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ngeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ngsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ngt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ngtr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nhArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nharr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nhpar" },
    { { HTML_PLUS }, { HTML_UNDEF }, "ni" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nis" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nisd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "niv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "njcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nlArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nlarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nldr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nleftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nleftrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nleq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nless" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nlsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nlt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nltri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nltrie" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nmid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nopf" },
    { { HTML_1_0 }, { HTML_UNDEF }, "not", "¬" },
    { { HTML_PLUS }, { HTML_UNDEF }, "notin" },
    { { HTML_5_0 }, { HTML_UNDEF }, "notinva" },
    { { HTML_5_0 }, { HTML_UNDEF }, "notinvb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "notinvc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "notni" },
    { { HTML_5_0 }, { HTML_UNDEF }, "notniva" },
    { { HTML_5_0 }, { HTML_UNDEF }, "notnivb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "notnivc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "npar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nparallel" },
    { { HTML_5_0 }, { HTML_UNDEF }, "npolint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "npr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nprcue" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nprec" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nrArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nrightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nrtri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nrtrie" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsccue" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nshortmid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nshortparallel" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsimeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsmid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nspar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsqsube" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsqsupe" },
    { { HTML_PLUS }, { HTML_UNDEF }, "nsub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsube" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsubseteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsucc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsupe" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nsupseteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ntgl" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ntilde", "ñ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ntlg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ntriangleleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ntrianglelefteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ntriangleright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ntrianglerighteq" },
    { { HTML_PLUS }, { HTML_UNDEF }, "nu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "num" },
    { { HTML_5_0 }, { HTML_UNDEF }, "numero" },
    { { HTML_5_0 }, { HTML_UNDEF }, "numsp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nvDash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nvHarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nvdash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nvinfin" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nvlArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nvrArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nwArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nwarhk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nwarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nwarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "nwnear" },
    { { HTML_5_0 }, { HTML_UNDEF }, "oS" },
    { { HTML_1_0 }, { HTML_UNDEF }, "oacute", "ó" },
    { { HTML_5_0 }, { HTML_UNDEF }, "oast" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ocir" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ocirc", "ô" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ocy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "odash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "odblac" },
    { { HTML_5_0 }, { HTML_UNDEF }, "odiv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "odot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "odsold" },
    { { HTML_4_0 }, { HTML_UNDEF }, "oelig", "œ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ofcir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ofr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ogon" },
    { { HTML_PLUS }, { HTML_PLUS }, "ogr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ograve", "ò" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ogt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ohbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ohm" },
    { { HTML_5_0 }, { HTML_UNDEF }, "oint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "olarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "olcir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "olcross" },
    { { HTML_4_0 }, { HTML_UNDEF }, "oline" },
    { { HTML_5_0 }, { HTML_UNDEF }, "olt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "omacr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "omega" },
    { { HTML_4_0 }, { HTML_UNDEF }, "omicron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "omid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ominus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "oopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "opar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "operp" },
    { { HTML_PLUS }, { HTML_UNDEF }, "oplus" },
    { { HTML_PLUS }, { HTML_UNDEF }, "or" },
    { { HTML_5_0 }, { HTML_UNDEF }, "orarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ord" },
    { { HTML_5_0 }, { HTML_UNDEF }, "order" },
    { { HTML_5_0 }, { HTML_UNDEF }, "orderof" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ordf" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ordm" },
    { { HTML_5_0 }, { HTML_UNDEF }, "origof" },
    { { HTML_5_0 }, { HTML_UNDEF }, "oror" },
    { { HTML_5_0 }, { HTML_UNDEF }, "orslope" },
    { { HTML_5_0 }, { HTML_UNDEF }, "orv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "oscr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "oslash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "osol" },
    { { HTML_1_0 }, { HTML_UNDEF }, "otilde" },
    { { HTML_PLUS }, { HTML_UNDEF }, "otimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "otimesas" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ouml" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ovbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "par" },
    { { HTML_1_0 }, { HTML_UNDEF }, "para", "¶" },
    { { HTML_5_0 }, { HTML_UNDEF }, "parallel" },
    { { HTML_5_0 }, { HTML_UNDEF }, "parsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "parsl" },
    { { HTML_PLUS }, { HTML_UNDEF }, "part" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "percnt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "period" },
    { { HTML_4_0 }, { HTML_UNDEF }, "permil" },
    { { HTML_PLUS }, { HTML_UNDEF }, "perp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pertenk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pfr" },
    { { HTML_4_0 }, { HTML_UNDEF }, "phi" },
    { { HTML_PLUS }, { HTML_PLUS }, "phis" },
    { { HTML_PLUS }, { HTML_UNDEF }, "phiv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "phmmat" },
    { { HTML_5_0 }, { HTML_UNDEF }, "phone" },
    { { HTML_PLUS }, { HTML_UNDEF }, "pi", "π" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pitchfork" },
    { { HTML_PLUS }, { HTML_UNDEF }, "piv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "planck" },
    { { HTML_5_0 }, { HTML_UNDEF }, "planckh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plankv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plus", "+" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plusacir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plusb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pluscir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plusdo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plusdu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pluse" },
    { { HTML_1_0 }, { HTML_UNDEF }, "plusmn", "±" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plussim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "plustwo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pm" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pointint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "popf" },
    { { HTML_1_0 }, { HTML_UNDEF }, "pound", "£" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prcue" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pre" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prec" },
    { { HTML_5_0 }, { HTML_UNDEF }, "precapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "preccurlyeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "preceq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "precnapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "precneqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "precnsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "precsim" },
    { { HTML_4_0 }, { HTML_UNDEF }, "prime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "primes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prnE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prnap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prnsim" },
    { { HTML_PLUS }, { HTML_UNDEF }, "prod" },
    { { HTML_5_0 }, { HTML_UNDEF }, "profalar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "profline" },
    { { HTML_5_0 }, { HTML_UNDEF }, "profsurf" },
    { { HTML_PLUS }, { HTML_UNDEF }, "prop" },
    { { HTML_5_0 }, { HTML_UNDEF }, "propto" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "prurel" },
    { { HTML_5_0 }, { HTML_UNDEF }, "pscr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "psi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "puncsp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "qfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "qint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "qopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "qprime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "qscr" },
    { { HTML_3_0 }, { HTML_3_0 }, "quad" },
    { { HTML_5_0 }, { HTML_UNDEF }, "quaternions" },
    { { HTML_5_0 }, { HTML_UNDEF }, "quatint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "quest" },
    { { HTML_5_0 }, { HTML_UNDEF }, "questeq" },
    { { HTML_1_0 }, { HTML_UNDEF }, "quot", "\"" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rAarr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "rArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rAtail" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rBarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rHar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "race" },
    { { HTML_5_0 }, { HTML_UNDEF }, "racute" },
    { { HTML_PLUS }, { HTML_UNDEF }, "radic" },
    { { HTML_5_0 }, { HTML_UNDEF }, "raemptyv" },
    { { HTML_PLUS }, { HTML_UNDEF }, "rang" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rangd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "range" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rangle" },
    { { HTML_1_0 }, { HTML_UNDEF }, "raquo", "»" },
    { { HTML_PLUS }, { HTML_UNDEF }, "rarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrbfs" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrfs" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrhk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrlp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrpl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrtl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rarrw" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ratail" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ratio" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rationals" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rbarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rbbrk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rbrace" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rbrack" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rbrke" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rbrksld" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rbrkslu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rcedil" },
    { { HTML_PLUS }, { HTML_UNDEF }, "rceil" },
    { { HTML_3_0 }, { HTML_UNDEF }, "rcub", "}" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rdca" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rdldhar" },
    { { HTML_4_0 }, { HTML_UNDEF }, "rdquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rdquor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rdsh" },
    { { HTML_PLUS }, { HTML_UNDEF }, "real" },
    { { HTML_5_0 }, { HTML_UNDEF }, "realine" },
    { { HTML_5_0 }, { HTML_UNDEF }, "realpart" },
    { { HTML_5_0 }, { HTML_UNDEF }, "reals" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rect" },
    { { HTML_1_0 }, { HTML_UNDEF }, "reg", "®" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rfisht" },
    { { HTML_PLUS }, { HTML_UNDEF }, "rfloor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rhard" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rharu" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rharul" },
    { { HTML_PLUS }, { HTML_UNDEF }, "rho" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rhov" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightarrowtail" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightharpoondown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightharpoonup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightleftarrows" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightleftharpoons" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightrightarrows" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightsquigarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rightthreetimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ring" },
    { { HTML_5_0 }, { HTML_UNDEF }, "risingdotseq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rlarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rlhar" },
    { { HTML_2_0, HV_RFC_2070 | HV_NOT3 }, { HTML_UNDEF }, "rlm" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rmoust" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rmoustache" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rnmid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "roang" },
    { { HTML_5_0 }, { HTML_UNDEF }, "roarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "robrk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ropar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ropf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "roplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rotimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rpar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rpargt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rppolint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rrarr" },
    { { HTML_4_0 }, { HTML_UNDEF }, "rsaquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rsh" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rsqb" },
    { { HTML_4_0 }, { HTML_UNDEF }, "rsquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rsquor" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rthree" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rtimes" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rtri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rtrie" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rtrif" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rtriltri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ruluhar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "rx" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sacute" },
    { { HTML_4_0 }, { HTML_UNDEF }, "sbquo" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scap" },
    { { HTML_4_0 }, { HTML_UNDEF }, "scaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sccue" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sce" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scnE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scnap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scnsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scpolint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "scy" },
    { { HTML_PLUS }, { HTML_UNDEF }, "sdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sdotb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sdote" },
    { { HTML_5_0 }, { HTML_UNDEF }, "seArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "searhk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "searr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "searrow" },
    { { HTML_1_0 }, { HTML_UNDEF }, "sect", "§" },
    { { HTML_5_0 }, { HTML_UNDEF }, "semi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "seswar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "setminus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "setmn" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sext" },
    { { HTML_PLUS }, { HTML_PLUS }, "sfgr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sfrown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sharp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "shchcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "shcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "shortmid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "shortparallel" },
    { { HTML_1_0 }, { HTML_UNDEF }, "shy" },
    { { HTML_PLUS }, { HTML_UNDEF }, "sigma" },
    { { HTML_4_0 }, { HTML_UNDEF }, "sigmaf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sigmav" },
    { { HTML_PLUS }, { HTML_UNDEF }, "sim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simg" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simgE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "siml" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simlE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simne" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "simrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "slarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "smallsetminus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "smashp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "smeparsl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "smid" },
    { { HTML_5_0 }, { HTML_UNDEF }, "smile" },
    { { HTML_5_0 }, { HTML_UNDEF }, "smt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "smte" },
    { { HTML_5_0 }, { HTML_UNDEF }, "softcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sol" },
    { { HTML_5_0 }, { HTML_UNDEF }, "solb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "solbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sopf" },
    { { HTML_1_0 }, { HTML_UNDEF }, "sp", " " },
    { { HTML_PLUS }, { HTML_UNDEF }, "spades" },
    { { HTML_5_0 }, { HTML_UNDEF }, "spadesuit" },
    { { HTML_5_0 }, { HTML_UNDEF }, "spar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqcap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsube" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsubset" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsubseteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsupe" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsupset" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sqsupseteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "squ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "square" },
    { { HTML_5_0 }, { HTML_UNDEF }, "squarf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "squf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "srarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ssetmn" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ssmile" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sstarf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "star" },
    { { HTML_5_0 }, { HTML_UNDEF }, "starf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "straightepsilon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "straightphi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "strns" },
    { { HTML_PLUS }, { HTML_UNDEF }, "sub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subdot" },
    { { HTML_PLUS }, { HTML_UNDEF }, "sube" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subedot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "submult" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subnE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subne" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subset" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subseteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subseteqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subsetneq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subsetneqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subsub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "subsup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succ" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succcurlyeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succnapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succneqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succnsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "succsim" },
    { { HTML_PLUS }, { HTML_UNDEF }, "sum" },
    { { HTML_5_0 }, { HTML_UNDEF }, "sung" },
    { { HTML_PLUS }, { HTML_UNDEF }, "sup" },
    { { HTML_1_0 }, { HTML_UNDEF }, "sup1" },
    { { HTML_1_0 }, { HTML_UNDEF }, "sup2" },
    { { HTML_1_0 }, { HTML_UNDEF }, "sup3" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supdsub" },
    { { HTML_PLUS }, { HTML_UNDEF }, "supe" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supedot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "suphsub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "suplarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supmult" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supnE" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supne" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supset" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supseteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supseteqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supsetneq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supsetneqq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supsim" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supsub" },
    { { HTML_5_0 }, { HTML_UNDEF }, "supsup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "swArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "swarhk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "swarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "swarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "swnwar" },
    { { HTML_1_0 }, { HTML_UNDEF }, "szlig", "ß" },
    { { HTML_5_0 }, { HTML_UNDEF }, "target" },
    { { HTML_PLUS }, { HTML_UNDEF }, "tau" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tbrk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tcedil" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "telrec" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tfr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "there4" },
    { { HTML_5_0 }, { HTML_UNDEF }, "therefore" },
    { { HTML_4_0 }, { HTML_UNDEF }, "theta" },
    { { HTML_PLUS }, { HTML_PLUS }, "thetas" },
    { { HTML_4_0 }, { HTML_UNDEF }, "thetasym" },
    { { HTML_PLUS }, { HTML_UNDEF }, "thetav" },
    { { HTML_5_0 }, { HTML_UNDEF }, "thickapprox" },
    { { HTML_5_0 }, { HTML_UNDEF }, "thicksim" },
    { { HTML_3_0, HV_NOT32 }, { HTML_UNDEF }, "thinsp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "thkap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "thksim" },
    { { HTML_1_0 }, { HTML_UNDEF }, "thorn" },
    { { HTML_4_0 }, { HTML_UNDEF }, "tilde" },
    { { HTML_1_0 }, { HTML_UNDEF }, "times" },
    { { HTML_5_0 }, { HTML_UNDEF }, "timesb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "timesbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "timesd" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tint" },
    { { HTML_5_0 }, { HTML_UNDEF }, "toea" },
    { { HTML_5_0 }, { HTML_UNDEF }, "top" },
    { { HTML_5_0 }, { HTML_UNDEF }, "topbot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "topcir" },
    { { HTML_5_0 }, { HTML_UNDEF }, "topf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "topfork" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tosa" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tprime" },
    { { HTML_PLUS }, { HTML_UNDEF }, "trade", "™" },
    { { HTML_5_0 }, { HTML_UNDEF }, "triangle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "triangledown" },
    { { HTML_5_0 }, { HTML_UNDEF }, "triangleleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "trianglelefteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "triangleq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "triangleright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "trianglerighteq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tridot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "trie" },
    { { HTML_5_0 }, { HTML_UNDEF }, "triminus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "triplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "trisb" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tritime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "trpezium" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tscy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tshcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "tstrok" },
    { { HTML_5_0 }, { HTML_UNDEF }, "twixt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "twoheadleftarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "twoheadrightarrow" },
    { { HTML_4_0 }, { HTML_UNDEF }, "uArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uHar" },
    { { HTML_1_0 }, { HTML_UNDEF }, "uacute", "ú" },
    { { HTML_PLUS }, { HTML_UNDEF }, "uarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ubrcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ubreve" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ucirc", "û" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ucy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "udarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "udblac" },
    { { HTML_5_0 }, { HTML_UNDEF }, "udhar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ufisht" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ufr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "ugrave", "ù" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uharl" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uharr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uhblk" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ulcorn" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ulcorner" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ulcrop" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ultri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "umacr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "uml", "¨" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uogon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uparrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "updownarrow" },
    { { HTML_5_0 }, { HTML_UNDEF }, "upharpoonleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "upharpoonright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uplus" },
    { { HTML_PLUS }, { HTML_UNDEF }, "upsi" },
    { { HTML_4_0 }, { HTML_UNDEF }, "upsih" },
    { { HTML_4_0 }, { HTML_UNDEF }, "upsilon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "upuparrows" },
    { { HTML_5_0 }, { HTML_UNDEF }, "urcorn" },
    { { HTML_5_0 }, { HTML_UNDEF }, "urcorner" },
    { { HTML_5_0 }, { HTML_UNDEF }, "urcrop" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uring" },
    { { HTML_5_0 }, { HTML_UNDEF }, "urtri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "utdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "utilde" },
    { { HTML_5_0 }, { HTML_UNDEF }, "utri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "utrif" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uuarr" },
    { { HTML_1_0 }, { HTML_UNDEF }, "uuml", "ü" },
    { { HTML_5_0 }, { HTML_UNDEF }, "uwangle" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vBar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vBarv" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vDash" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vangrt" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varepsilon" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varkappa" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varnothing" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varphi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varpi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varpropto" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varrho" },
    { { HTML_5_0 }, { HTML_UNDEF }, "varsigma" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vartheta" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vartriangleleft" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vartriangleright" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vdash" },
    { { HTML_3_0 }, { HTML_3_0 }, "vdots" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "veebar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "veeeq" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vellip" },
    { { HTML_5_0 }, { HTML_UNDEF }, "verbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vert" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vltri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vopf" },
    { { HTML_PLUS }, { HTML_PLUS }, "vprime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vprop" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vrtri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "vzigzag" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wedbar" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wedge" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wedgeq" },
    { { HTML_PLUS }, { HTML_UNDEF }, "weierp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wp" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wreath" },
    { { HTML_5_0 }, { HTML_UNDEF }, "wscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xcap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xcirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xdtri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xhArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xharr" },
    { { HTML_PLUS }, { HTML_UNDEF }, "xi" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xlArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xlarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xmap" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xnis" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xodot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xoplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xotime" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xrArr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xsqcup" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xuplus" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xutri" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xvee" },
    { { HTML_5_0 }, { HTML_UNDEF }, "xwedge" },
    { { HTML_1_0 }, { HTML_UNDEF }, "yacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "yacy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ycirc" },
    { { HTML_5_0 }, { HTML_UNDEF }, "ycy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "yen", "¥" },
    { { HTML_5_0 }, { HTML_UNDEF }, "yfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "yicy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "yopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "yscr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "yucy" },
    { { HTML_1_0 }, { HTML_UNDEF }, "yuml" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zacute" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zcaron" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zdot" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zeetrf" },
    { { HTML_PLUS }, { HTML_UNDEF }, "zeta" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zfr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zhcy" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zigrarr" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zopf" },
    { { HTML_5_0 }, { HTML_UNDEF }, "zscr" },
    { { HTML_2_0, HV_RFC_2070 | HV_NOT3 }, { HTML_UNDEF }, "zwj" },
    { { HTML_2_0, HV_RFC_2070 | HV_NOT3 }, { HTML_UNDEF }, "zwnj" },

    { { HTML_UNDEF }, { HTML_UNDEF }, nullptr } };

typedef ssc_map < ::std::string, wotsit_t > vw_t;
vw_t wotsit;

void wotsit_init (nitpick& nits)
{   for (int index = 0; wotsit_table [index].wotsit_ != nullptr; ++index)
        if (wotsit.find (wotsit_table [index].wotsit_) != wotsit.end ())
        {   nits.pick (nit_symbol_aleady_defined, es_error, ec_program, "Program error: wotsit ", wotsit_table [index].wotsit_, " already defined"); }
        else
        wotsit.insert (vw_t::value_type (wotsit_table [index].wotsit_, wotsit_table [index])); }

void text_check (nitpick& nits, const html_version& v, const ::std::string& text)
{   nits.set_context (0, text);
    if (context.tell (e_error))
    {   char after = text.at (0);
        ::std::string::size_type equal = text.find ('=', 1);
        if (equal != ::std::string::npos) return; // probably an HREF param that hasn't been normalised
        if (text.length () > max_wotsit_len + 1)
        {   nits.pick (nit_bizarre_character_code, es_error, ec_parser, "&", text, "; is neither a known text entity nor a normalised URL");
            return; }
        if (v.major () >= 2)
        {   if (::std::string (ALPHABET HASHES).find (after) == ::std::string::npos) return;
            if (after == HASH)
            {   if (text.length () == 1)
                    nits.pick (nit_empty_denary_code, es_warning, ec_parser, "empty numeric character code");
                else
                {   after = text.at (1);
                    if ((after == 'x') || (after == 'X'))
                    {   if (text.length () == 2)
                            nits.pick (nit_empty_hex_code, es_warning, ec_parser, "empty hex character code");
                        else
                        {   after = text.at (2);
                            if (text.length () > 8)
                                nits.pick (nit_hex_too_long, es_warning, ec_parser, "hex character code too long");
                            else if (::std::string (HEX).find_first_of (after) == ::std::string::npos)
                                nits.pick (nit_dubious_denary, es_warning, ec_parser, "dubious hex character code");
                            else if (text.substr (2).find_first_not_of (HEX) != ::std::string::npos)
                                nits.pick (nit_invalid_denary, es_warning, ec_parser, "invalid hex character code"); } }
                    else if (text.length () > 7)
                        nits.pick (nit_denary_too_long, es_warning, ec_parser, "denary character code too long");
                    else if (::std::string (DENARY).find_first_of (after) == ::std::string::npos)
                        nits.pick (nit_dubious_denary, es_warning, ec_parser, " dubious denary character code");
                    else if (text.substr (1).find_first_not_of (DENARY) != ::std::string::npos)
                        nits.pick (nit_invalid_denary, es_warning, ec_parser, "invalid denary character code"); }
                return; } }
        vw_t::const_iterator i = wotsit.find (text.c_str ());
        if (i == wotsit.end ())
            nits.pick (nit_bizarre_character_code, es_error, ec_parser, "&", text, "; is neither a known text entity nor a normalised URL");
        else if (! does_apply (v, i -> second.first_, i -> second.last_))
            nits.pick (nit_code_unrecognised_here, es_warning, ec_parser, "&", text, "; is invalid in ", v.report ()); } }

void examine_character_code (const html_version& v, const ::std::string& text, bool& known, bool& invalid)
{   assert (! text.empty ());
    vw_t::const_iterator i = wotsit.find (text.c_str ());
    if (i != wotsit.end ())
        if (! may_apply (v, i -> second.first_, i -> second.last_)) invalid = true;
        else known = true; }

::std::string interpret_character_code (const html_version& v, const ::std::string& text, bool& known, bool& invalid)
{   assert (! text.empty ());
    vw_t::const_iterator i = wotsit.find (text.c_str ());
    if (i != wotsit.end ())
        if (! may_apply (v, i -> second.first_, i -> second.last_)) invalid = true;
        else
        {   known = true;
            if (i -> second.char_ != nullptr) return i -> second.char_; }
    ::std::string res ("&");
    res += text + ';';
    return res; }

::std::string interpret_character_code (const html_version& v, const ::std::string& text)
{   bool invalid = false;
    bool known = false;
    return interpret_character_code (v, text, known, invalid); }

::std::string interpret_character_code (nitpick& nits, const html_version& v, const ::std::string& text)
{   bool invalid = false;
    bool known = false;
    ::std::string res (interpret_character_code (v, text, known, invalid));
    if (invalid)
        nits.pick (nit_invalid_character_code, es_error, ec_parser, res, " is invalid in ", v.report ());
    else if (! known)
        nits.pick (nit_invalid_character_code, es_error, ec_parser, res, " is unrecognised");
    return res; }

::std::string interpret_character_number (const ::std::string& text)
{   assert (! text.empty ());
    unsigned int n = 0;
    for (auto ch : text)
    {   n *= 10;
        if ((ch >= '0') && (ch <= '9')) n += ch - '0';
        else return text;
        if (n > UINT_MAX / 4) return text; }
    return ::std::string (1, static_cast <char> (n)); }

::std::string interpret_character_number (nitpick& nits, const ::std::string& text)
{   assert (! text.empty ());
    unsigned int n = 0;
    for (auto ch : text)
    {   n *= 10;
        if ((ch >= '0') && (ch <= '9')) n += ch - '0';
        else
        {   ::std::string res = "&#";
            res += text;
            res += ';';
            nits.pick (nit_invalid_character_denary, es_error, ec_parser, quote (res), " is not a denary integer");
            return res; }
        if (n > UINT_MAX / 4)
        {   nits.pick (nit_denary_too_long, es_error, ec_parser, text, " is too big");
            break; } }
    return ::std::string (1, static_cast <char> (n)); }

::std::string interpret_character_hex (const ::std::string& text)
{   assert (! text.empty ());
    unsigned int n = 0;
    for (auto ch : text)
    {   n <<= 4;
        if ((ch >= '0') && (ch <= '9')) n += ch - '0';
        else if ((ch >= 'A') && (ch <= 'F')) n += ch - 'A' + 10;
        else if ((ch >= 'a') && (ch <= 'f')) n += ch - 'a' + 10;
        else return text;
        if (n > UINT_MAX / 4) return text; }
    return ::std::string (1, static_cast <char> (n)); }

::std::string interpret_character_hex (nitpick& nits, const ::std::string& text)
{   assert (! text.empty ());
    unsigned int n = 0;
    for (auto ch : text)
    {   n <<= 4;
        if ((ch >= '0') && (ch <= '9')) n += ch - '0';
        else if ((ch >= 'A') && (ch <= 'F')) n += ch - 'A' + 10;
        else if ((ch >= 'a') && (ch <= 'f')) n += ch - 'a' + 10;
        else
        {   ::std::string res = "&#x";
            res += text;
            res += ';';
            nits.pick (nit_invalid_character_hex, es_error, ec_parser, quote (res), " is not a hexadecimal integer");
            return res; }
        if (n > UINT_MAX / 4)
        {   nits.pick (nit_hex_too_long, es_error, ec_parser, text, " is too big");
            break; } }
    return ::std::string (1, static_cast <char> (n)); }
